/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.distribution.customer.month.sale.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.dto.TpmDistributionCustomerMonthSaleDto;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.service.TpmDistributionCustomerMonthSaleService;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.vo.TpmDistributionCustomerMonthSaleRespVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/distribution/customer/month/sale"})
@Api(tags={"TPM-\u5ba2\u6237\u6708\u5ea6\u9500\u552e\u6570\u636e\u7ba1\u7406"})
public class TpmDistributionCustomerMonthSaleController {
    private static final Logger log = LoggerFactory.getLogger(TpmDistributionCustomerMonthSaleController.class);
    @Autowired(required=false)
    private TpmDistributionCustomerMonthSaleService tpmDistributionCustomerMonthSaleService;

    @PostMapping(value={"findByConditions"})
    @ApiOperation(value="\u5ba2\u6237\u6708\u5ea6\u9500\u552e\u6570\u636e\u7ba1\u7406\u5206\u9875\u67e5\u8be2", notes="")
    public Result<Page<TpmDistributionCustomerMonthSaleRespVo>> findByConditions(Pageable pageable, @RequestBody TpmDistributionCustomerMonthSaleDto dto) {
        try {
            if (StringUtils.isEmpty((CharSequence)dto.getDelFlag())) {
                dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            }
            return Result.ok((Object)this.tpmDistributionCustomerMonthSaleService.findByConditions(pageable, dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"saleDataReset"})
    @ApiOperation(value="\u5ba2\u6237\u6708\u5ea6\u9500\u552e\u6570\u636e\u7ba1\u7406-\u9500\u552e\u6570\u636e\u8fd8\u539f", notes="")
    public Result<?> saleDataReset(@RequestBody TpmDistributionCustomerMonthSaleDto dto) {
        try {
            this.tpmDistributionCustomerMonthSaleService.saleDataResetNew(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"manualPullMonthSaleData"})
    @ApiOperation(value="\u91cd\u65b0\u62c9\u53d6\u6307\u5b9a\u5e74\u6708\u7684\u6708\u5ea6\u9500\u552e\u6570\u636e", notes="")
    public Result<?> manualPullMonthSaleData(@RequestBody TpmDistributionCustomerMonthSaleDto dto) {
        try {
            this.tpmDistributionCustomerMonthSaleService.pullData(dto.getDistributionCustomerMonthSaleYearMonth());
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

