/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.distribution.customer.month.sale.local.repository;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.eunm.YesOrNoEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.distribution.customer.month.sale.local.entity.TpmDistributionCustomerMonthSaleEntity;
import com.biz.crm.tpm.business.distribution.customer.month.sale.local.mapper.TpmDistributionCustomerMonthSaleEntityMapper;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.dto.TpmDistributionCustomerMonthSaleDto;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.vo.TpmDistributionCustomerMonthSaleRespVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class TpmDistributionCustomerMonthSaleEntityRepository
extends ServiceImpl<TpmDistributionCustomerMonthSaleEntityMapper, TpmDistributionCustomerMonthSaleEntity> {
    public List<TpmDistributionCustomerMonthSaleEntity> findByVerifyCodeList(List<String> verifyCodeList) {
        if (CollectionUtil.isEmpty(verifyCodeList)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(TpmDistributionCustomerMonthSaleEntity::getVerifyCode, verifyCodeList)).list();
    }

    public List<TpmDistributionCustomerMonthSaleEntity> findDistributionCustomerMonthSale(TpmDistributionCustomerMonthSaleDto distributionCustomerMonthSaleDto) {
        return ((TpmDistributionCustomerMonthSaleEntityMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TpmDistributionCustomerMonthSaleEntity.class).eq(TpmDistributionCustomerMonthSaleEntity::getCustomerCode, (Object)distributionCustomerMonthSaleDto.getCustomerCode())).eq(TpmDistributionCustomerMonthSaleEntity::getDistributionCustomerMonthSaleYearMonth, (Object)distributionCustomerMonthSaleDto.getDistributionCustomerMonthSaleYearMonth()));
    }

    public BigDecimal getTotalSaleAmount(TpmDistributionCustomerMonthSaleDto distributionCustomerMonthSale) {
        BigDecimal totalSaleAmount = ((TpmDistributionCustomerMonthSaleEntityMapper)this.baseMapper).getTotalSaleAmount(distributionCustomerMonthSale);
        return totalSaleAmount != null && totalSaleAmount.compareTo(BigDecimal.ZERO) > 0 ? totalSaleAmount : BigDecimal.ZERO;
    }

    public BigDecimal getYearTotalSaleAmount(TpmDistributionCustomerMonthSaleDto dto) {
        BigDecimal yearTotalSaleAmount = ((TpmDistributionCustomerMonthSaleEntityMapper)this.baseMapper).getYearTotalSaleAmount(dto);
        return yearTotalSaleAmount != null && yearTotalSaleAmount.compareTo(BigDecimal.ZERO) > 0 ? yearTotalSaleAmount : BigDecimal.ZERO;
    }

    public List<TpmDistributionCustomerMonthSaleRespVo> findCustomerMonthSalesByParams(TpmDistributionCustomerMonthSaleDto distributionCustomerMonthSale) {
        String distributionCustomerMonthSaleYearMonth = distributionCustomerMonthSale.getDistributionCustomerMonthSaleYearMonth();
        Integer yearMonthType = distributionCustomerMonthSaleYearMonth.length() == 4 ? 0 : 1;
        return ((TpmDistributionCustomerMonthSaleEntityMapper)this.baseMapper).findCustomerMonthSalesByParams(distributionCustomerMonthSale, yearMonthType);
    }

    public List<String> findCustomerErpCodeListByProductListAndYearMonth(Set<String> productCodeSet, String distributionCustomerMonthSaleYearMonth) {
        return ((TpmDistributionCustomerMonthSaleEntityMapper)this.baseMapper).findCustomerErpCodeListByProductListAndYearMonth(productCodeSet, distributionCustomerMonthSaleYearMonth, TenantUtils.getTenantCode());
    }

    public List<TpmDistributionCustomerMonthSaleEntity> findListByCustomerCodeAndYearMonth(String customerErpCode, String distributionCustomerMonthSaleYearMonth) {
        String lastYearMonth = DateUtil.formatAddMonth((String)(distributionCustomerMonthSaleYearMonth + "-01"), (String)"yyyy-MM-dd", (int)-1).substring(0, 7);
        return ((TpmDistributionCustomerMonthSaleEntityMapper)this.baseMapper).findListByCustomerCodeAndYearMonth(customerErpCode, distributionCustomerMonthSaleYearMonth, lastYearMonth, TenantUtils.getTenantCode());
    }

    public List<TpmDistributionCustomerMonthSaleEntity> findByYearMonth(String distributionCustomerMonthSaleYearMonth) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TpmDistributionCustomerMonthSaleEntity::getDistributionCustomerMonthSaleYearMonth, (Object)distributionCustomerMonthSaleYearMonth)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<TpmDistributionCustomerMonthSaleRespVo> findAllByYearMonth(String distributionCustomerMonthSaleYearMonth) {
        return ((TpmDistributionCustomerMonthSaleEntityMapper)this.baseMapper).findAllByYearMonth(distributionCustomerMonthSaleYearMonth, TenantUtils.getTenantCode());
    }

    public List<TpmDistributionCustomerMonthSaleRespVo> findByCustomer(Collection<TpmDistributionCustomerMonthSaleDto> customerMonthSaleDtos) {
        return ((TpmDistributionCustomerMonthSaleEntityMapper)this.baseMapper).findByCustomer(customerMonthSaleDtos, TenantUtils.getTenantCode());
    }

    public List<TpmDistributionCustomerMonthSaleEntity> findAutoCreateData(String yearMonth, Page page) {
        return ((TpmDistributionCustomerMonthSaleEntityMapper)this.baseMapper).findAutoCreateData(page, yearMonth, TenantUtils.getTenantCode());
    }

    public void deleteAutoCreateData(String yearMonth) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(TpmDistributionCustomerMonthSaleEntity::getAutoCreate, (Object)YesOrNoEnum.YES.getCode())).eq(TpmDistributionCustomerMonthSaleEntity::getDistributionCustomerMonthSaleYearMonth, (Object)yearMonth)).remove();
    }

    public List<TpmDistributionCustomerMonthSaleEntity> listForSplitCustomer(TpmDistributionCustomerMonthSaleDto dto) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(TpmDistributionCustomerMonthSaleEntity::getDistributionCustomerMonthSaleYearMonth, (Object)dto.getDistributionCustomerMonthSaleYearMonth())).in(TpmDistributionCustomerMonthSaleEntity::getCustomerCode, (Collection)dto.getCustomerCodeList())).list();
    }
}

