/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.distribution.customer.month.sale.local.service.impl;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.service.TpmDistributionCustomerMonthSaleService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TpmDistributionCustomerMonthSalePendingXxlJob {
    private static final Logger log = LoggerFactory.getLogger(TpmDistributionCustomerMonthSalePendingXxlJob.class);
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private TpmDistributionCustomerMonthSaleService tpmDistributionCustomerMonthSaleService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DynamicTaskService(cornExpression="0 0 1 1 * ?", taskDesc="\u5206\u9500\u5ba2\u6237\u6708\u5ea6\u9500\u552e\u8868-\u6839\u636e\u4e0a\u6708\u5f85\u5339\u914d\u6570\u636e\u81ea\u52a8\u751f\u6210\u6570\u636e")
    public void executeJob() {
        this.loginUserService.refreshAuthentication(null);
        log.info("\u5206\u9500\u5ba2\u6237\u6708\u5ea6\u9500\u552e\u8868-\u6839\u636e\u4e0a\u6708\u5f85\u5339\u914d\u6570\u636e\u81ea\u52a8\u751f\u6210\u6570\u636e start ===> {}", (Object)DateUtil.dateStrNowAll());
        String lockKey = "TpmDistributionCustomerMonthSalePendingXxlJob" + DateUtil.getDate((String)"yyyyMM");
        try {
            boolean locked = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 12L, 5L);
            Validate.isTrue((boolean)locked, (String)"\u6267\u884c\u4e2d...", (Object[])new Object[0]);
            String yearMonth = DateUtil.format((Date)new Date(), (String)"yyyy-MM");
            Integer count = this.tpmDistributionCustomerMonthSaleService.autoGenerateData(yearMonth);
            log.info("\u5206\u9500\u5ba2\u6237\u6708\u5ea6\u9500\u552e\u8868-\u6839\u636e\u4e0a\u6708\u5f85\u5339\u914d\u6570\u636e\u81ea\u52a8\u751f\u6210\u6570\u636e \u6570\u91cf ===> {}", (Object)count);
        }
        catch (Exception e) {
            log.error("\u5206\u9500\u5ba2\u6237\u6708\u5ea6\u9500\u552e\u8868-\u6839\u636e\u4e0a\u6708\u5f85\u5339\u914d\u6570\u636e\u81ea\u52a8\u751f\u6210\u6570\u636e \u5f02\u5e38 ===> {}\uff0c{}", (Object)DateUtil.dateStrNowAll(), (Object)e.getMessage());
        }
        finally {
            this.redisLockService.unlock(lockKey);
        }
        log.info("\u5206\u9500\u5ba2\u6237\u6708\u5ea6\u9500\u552e\u8868-\u6839\u636e\u4e0a\u6708\u5f85\u5339\u914d\u6570\u636e\u81ea\u52a8\u751f\u6210\u6570\u636e end ===> {}", (Object)DateUtil.dateStrNowAll());
    }
}

