/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.distribution.customer.month.sale.local.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDimensionItemDto;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.enums.PriceTypeEnum;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.YesOrNoEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.tpm.business.distribution.customer.month.sale.local.entity.TpmDistributionCustomerMonthSaleEntity;
import com.biz.crm.tpm.business.distribution.customer.month.sale.local.mapper.TpmDistributionCustomerMonthSaleEntityMapper;
import com.biz.crm.tpm.business.distribution.customer.month.sale.local.repository.TpmDistributionCustomerMonthSaleEntityRepository;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.dto.TpmDistributionCustomerMonthSaleDto;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.service.TpmDistributionCustomerMonthSaleService;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.vo.TpmDistributionCustomerMonthSaleRespVo;
import com.biz.crm.tpm.business.promotion.policy.sdk.service.PromotionPolicyService;
import com.biz.crm.tpm.business.promotion.policy.sdk.vo.PromotionPolicyProductVO;
import com.biz.crm.tpm.business.promotion.policy.sdk.vo.PromotionPolicyVO;
import com.biz.crm.tpm.business.third.system.sdk.service.Ce1MnjtSdkService;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1MnjtFullVo2;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jodd.util.CharSequenceUtil;
import liquibase.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class TpmDistributionCustomerMonthSaleServiceImpl
implements TpmDistributionCustomerMonthSaleService {
    private static final Logger log = LoggerFactory.getLogger(TpmDistributionCustomerMonthSaleServiceImpl.class);
    @Autowired(required=false)
    private TpmDistributionCustomerMonthSaleEntityMapper tpmDistributionCustomerMonthSaleEntityMapper;
    @Autowired(required=false)
    private TpmDistributionCustomerMonthSaleEntityRepository tpmDistributionCustomerMonthSaleEntityRepository;
    @Autowired(required=false)
    private PromotionPolicyService promotionPolicyService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private Ce1MnjtSdkService ce1MnjtSdkService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private PriceModelVoService priceModelVoService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    private static final String BUSINESS_MODEL_CODE = "distribution_mode";

    public Page<TpmDistributionCustomerMonthSaleRespVo> findByConditions(Pageable pageable, TpmDistributionCustomerMonthSaleDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.tpmDistributionCustomerMonthSaleEntityMapper.findByConditions((Page<TpmDistributionCustomerMonthSaleRespVo>)page, dto);
    }

    public void saleDataReset(TpmDistributionCustomerMonthSaleDto dto) {
        String rule = "\\d{4}-\\d{2}";
        if (!Pattern.matches(rule, dto.getDistributionCustomerMonthSaleYearMonth())) {
            return;
        }
        ArrayList modifyList = new ArrayList();
        int pageNum = 0;
        int pageSize = 1000;
        Page page = new Page((long)pageNum, (long)pageSize);
        Page<TpmDistributionCustomerMonthSaleDto> dtoPage = this.tpmDistributionCustomerMonthSaleEntityMapper.findUnRevert((Page<TpmDistributionCustomerMonthSaleDto>)page, dto);
        while (CollectionUtils.isNotEmpty((Collection)dtoPage.getRecords())) {
            List dtoList = dtoPage.getRecords();
            for (TpmDistributionCustomerMonthSaleDto monthSaleDto : dtoList) {
                if (monthSaleDto.getManualAuditSaleQuantity() == null) {
                    monthSaleDto.setManualAuditSaleQuantity(BigDecimal.ZERO);
                }
                if (monthSaleDto.getManualAuditSaleAmount() != null) continue;
                monthSaleDto.setManualAuditSaleAmount(BigDecimal.ZERO);
            }
            ArrayList totalProductCodeList = new ArrayList(dtoList.stream().map(TpmDistributionCustomerMonthSaleDto::getProductCode).collect(Collectors.toSet()));
            Calendar calendar = Calendar.getInstance();
            calendar.add(2, -1);
            String lastMonth = DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM-dd");
            List productPromotionPolicyList = this.promotionPolicyService.findForDistributionCustomerMonthSale(totalProductCodeList, lastMonth);
            Map<String, List<PromotionPolicyProductVO>> productPromotionPolicyMapByProductCode = productPromotionPolicyList.stream().collect(Collectors.groupingBy(PromotionPolicyProductVO::getProductCode));
            for (Map.Entry<String, List<PromotionPolicyProductVO>> entry : productPromotionPolicyMapByProductCode.entrySet()) {
                if (!CollectionUtils.isNotEmpty((Collection)entry.getValue())) continue;
                entry.setValue(entry.getValue().stream().sorted(Comparator.comparing(PromotionPolicyProductVO::getPriorityLevel)).collect(Collectors.toList()));
            }
            for (TpmDistributionCustomerMonthSaleDto monthSaleDto : dtoList) {
                if (!CollectionUtils.isNotEmpty((Collection)productPromotionPolicyMapByProductCode.get(monthSaleDto.getProductCode()))) continue;
                monthSaleDto.setPromotionPolicyCode(productPromotionPolicyMapByProductCode.get(monthSaleDto.getProductCode()).get(0).getPromotionCode());
            }
            Map monthSaleMap = dtoList.stream().collect(Collectors.groupingBy(o -> o.getCustomerCode() + (o.getPromotionPolicyCode() == null ? "" : o.getPromotionPolicyCode()), Collectors.toList()));
            Map<String, List<PromotionPolicyProductVO>> productPromotionPolicyMap = productPromotionPolicyList.stream().collect(Collectors.groupingBy(PromotionPolicyProductVO::getPromotionCode));
            for (Map.Entry<String, List<TpmDistributionCustomerMonthSaleDto>> entry : monthSaleMap.entrySet()) {
                String customerCode = ((TpmDistributionCustomerMonthSaleDto)entry.getValue().get(0)).getCustomerCode();
                if (customerCode.equals(entry.getKey())) {
                    for (TpmDistributionCustomerMonthSaleDto monthSaleDto : entry.getValue()) {
                        monthSaleDto.setBasicSaleAmount(monthSaleDto.getMonthSaleAmount());
                        monthSaleDto.setTotalSaleAmount(monthSaleDto.getMonthSaleAmount());
                        BigDecimal restoreBasicSaleQuantity = new BigDecimal(monthSaleDto.getMonthSaleQuantity()).subtract(monthSaleDto.getManualAuditSaleQuantity()).setScale(2, 1);
                        monthSaleDto.setBasicSaleQuantity(Integer.valueOf(restoreBasicSaleQuantity.intValue()));
                        monthSaleDto.setTotalSaleQuantity(Integer.valueOf(restoreBasicSaleQuantity.intValue()));
                        monthSaleDto.setRevertFlag(BooleanEnum.TRUE.getCapital());
                    }
                    continue;
                }
                String promotionPolicyCode = ((TpmDistributionCustomerMonthSaleDto)entry.getValue().get(0)).getPromotionPolicyCode();
                List<PromotionPolicyProductVO> customerProductPromotionPolicyList = productPromotionPolicyMap.get(promotionPolicyCode);
                String cumulative = customerProductPromotionPolicyList.get(0).getCumulative();
                int minBoundGiftQuantity = 0;
                if (BooleanEnum.FALSE.getCapital().equals(cumulative)) {
                    minBoundGiftQuantity = this.getMinBoundGiftQuantity(entry, customerProductPromotionPolicyList);
                    for (TpmDistributionCustomerMonthSaleDto monthSaleDto : dtoList) {
                        monthSaleDto.setBoundGiftSaleQuantity(Integer.valueOf(minBoundGiftQuantity));
                        monthSaleDto.setBoundGiftSaleAmount(monthSaleDto.getSupplyPrice().multiply(new BigDecimal(monthSaleDto.getBoundGiftSaleQuantity())));
                        monthSaleDto.setBasicSaleQuantity(Integer.valueOf(monthSaleDto.getMonthSaleQuantity() - monthSaleDto.getBoundGiftSaleQuantity()));
                        monthSaleDto.setBasicSaleAmount(monthSaleDto.getSupplyPrice().multiply(new BigDecimal(monthSaleDto.getBasicSaleQuantity())));
                        monthSaleDto.setWaitMatchAmount(BigDecimal.ZERO);
                        monthSaleDto.setWaitMatchQuantity(Integer.valueOf(0));
                        monthSaleDto.setRevertFlag(BooleanEnum.TRUE.getCapital());
                        BigDecimal restoreSaleQuantity = new BigDecimal(monthSaleDto.getMonthSaleQuantity()).subtract(monthSaleDto.getManualAuditSaleQuantity());
                        monthSaleDto.setTotalSaleQuantity(Integer.valueOf(restoreSaleQuantity.intValue()));
                        monthSaleDto.setTotalSaleAmount(restoreSaleQuantity);
                    }
                    continue;
                }
                for (TpmDistributionCustomerMonthSaleDto monthSaleDto : entry.getValue()) {
                    String translateDate = monthSaleDto.getDistributionCustomerMonthSaleYearMonth() + "-01";
                    Calendar calendar1 = Calendar.getInstance();
                    calendar1.setTime(DateUtil.parse((String)translateDate, (String)"yyyy-MM-dd"));
                    calendar1.add(2, -1);
                    String lastYearMonthStr = DateUtil.format((Date)calendar1.getTime(), (String)"yyyy-MM-dd");
                    TpmDistributionCustomerMonthSaleDto lastMonthSaleDto = this.tpmDistributionCustomerMonthSaleEntityMapper.findByCustomerCodeAndProductCodeAndYearMonth(customerCode, monthSaleDto.getProductCode(), lastYearMonthStr);
                    if (lastMonthSaleDto == null) continue;
                    BigDecimal restoreTotalSaleQuantity = new BigDecimal(monthSaleDto.getMonthSaleQuantity()).subtract(monthSaleDto.getManualAuditSaleQuantity()).add(new BigDecimal(lastMonthSaleDto.getWaitMatchQuantity()));
                    monthSaleDto.setTotalSaleQuantity(Integer.valueOf(restoreTotalSaleQuantity.intValue()));
                    monthSaleDto.setTotalSaleAmount(monthSaleDto.getTotalSaleAmount().add(lastMonthSaleDto.getWaitMatchAmount()));
                }
                minBoundGiftQuantity = this.getMinBoundGiftQuantity(entry, customerProductPromotionPolicyList);
                for (TpmDistributionCustomerMonthSaleDto monthSaleDto : dtoList) {
                    Optional<PromotionPolicyProductVO> productPromotionPolicy = customerProductPromotionPolicyList.stream().filter(o -> o.getProductCode().equals(monthSaleDto.getProductCode())).findFirst();
                    if (productPromotionPolicy.isPresent() && monthSaleDto.getDistributionCustomerMonthSaleYearMonth().equals(DateUtil.format((Date)productPromotionPolicy.get().getBindEndDate(), (String)"yyyy-MM"))) {
                        monthSaleDto.setBoundGiftSaleQuantity(Integer.valueOf(minBoundGiftQuantity));
                        monthSaleDto.setBoundGiftSaleAmount(monthSaleDto.getSupplyPrice().multiply(new BigDecimal(monthSaleDto.getBoundGiftSaleQuantity())));
                        monthSaleDto.setBasicSaleQuantity(Integer.valueOf(monthSaleDto.getMonthSaleQuantity() - monthSaleDto.getBoundGiftSaleQuantity()));
                        monthSaleDto.setBasicSaleAmount(monthSaleDto.getSupplyPrice().multiply(new BigDecimal(monthSaleDto.getBasicSaleQuantity())));
                        monthSaleDto.setWaitMatchAmount(BigDecimal.ZERO);
                        monthSaleDto.setWaitMatchQuantity(Integer.valueOf(0));
                        monthSaleDto.setRevertFlag(BooleanEnum.TRUE.getCapital());
                        continue;
                    }
                    if (!productPromotionPolicy.isPresent() || monthSaleDto.getDistributionCustomerMonthSaleYearMonth().equals(DateUtil.format((Date)productPromotionPolicy.get().getBindEndDate(), (String)"yyyy-MM"))) continue;
                    monthSaleDto.setBoundGiftSaleQuantity(Integer.valueOf(minBoundGiftQuantity));
                    monthSaleDto.setBoundGiftSaleAmount(monthSaleDto.getSupplyPrice().multiply(new BigDecimal(monthSaleDto.getBoundGiftSaleQuantity())));
                    monthSaleDto.setWaitMatchQuantity(Integer.valueOf(minBoundGiftQuantity));
                    monthSaleDto.setWaitMatchQuantity(Integer.valueOf(monthSaleDto.getMonthSaleQuantity() - monthSaleDto.getBoundGiftSaleQuantity()));
                    monthSaleDto.setWaitMatchAmount(monthSaleDto.getSupplyPrice().multiply(new BigDecimal(monthSaleDto.getBasicSaleQuantity())));
                    monthSaleDto.setBasicSaleAmount(BigDecimal.ZERO);
                    monthSaleDto.setBasicSaleQuantity(Integer.valueOf(0));
                    monthSaleDto.setRevertFlag(BooleanEnum.TRUE.getCapital());
                }
            }
            modifyList.addAll(new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dtoList, TpmDistributionCustomerMonthSaleDto.class, TpmDistributionCustomerMonthSaleEntity.class, LinkedHashSet.class, ArrayList.class, new String[0])));
            if (!page.hasNext()) break;
            page = new Page((long)(++pageNum), (long)pageSize);
            dtoPage = this.tpmDistributionCustomerMonthSaleEntityMapper.findUnRevert((Page<TpmDistributionCustomerMonthSaleDto>)page, dto);
        }
        this.tpmDistributionCustomerMonthSaleEntityRepository.updateBatchById(modifyList);
    }

    public void saleDataResetNew(TpmDistributionCustomerMonthSaleDto dto) {
        ArrayList<TpmDistributionCustomerMonthSaleEntity> result = new ArrayList<TpmDistributionCustomerMonthSaleEntity>();
        HashSet finalProductCodeList = new HashSet();
        List promotionPolicyVOList = this.promotionPolicyService.findListByYearMonth(dto.getDistributionCustomerMonthSaleYearMonth());
        for (Object policy : promotionPolicyVOList) {
            if (dto.getDistributionCustomerMonthSaleYearMonth().compareTo(DateUtil.format((Date)policy.getBindEndDate(), (String)"yyyy-MM")) <= -1) continue;
            finalProductCodeList.addAll(policy.getPromotionPolicyProducts().stream().map(PromotionPolicyProductVO::getProductCode).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isEmpty(promotionPolicyVOList = promotionPolicyVOList.stream().sorted(Comparator.comparing(PromotionPolicyVO::getPriorityLevel)).collect(Collectors.toList()))) {
            List<TpmDistributionCustomerMonthSaleEntity> monthSaleList = this.tpmDistributionCustomerMonthSaleEntityRepository.findByYearMonth(dto.getDistributionCustomerMonthSaleYearMonth());
            for (TpmDistributionCustomerMonthSaleEntity entity : monthSaleList) {
                HashSet<String> productCodeSet = new HashSet<String>();
                productCodeSet.add(entity.getProductCode());
                Map<String, PriceModelVo> priceModelVoMap = this.getPlatformSupplyPrice(entity.getCustomerCode(), productCodeSet, dto.getDistributionCustomerMonthSaleYearMonth());
                if (entity.getManualAuditSaleQuantity() == null) {
                    entity.setManualAuditSaleQuantity(BigDecimal.ZERO);
                }
                BigDecimal restoreBasicSaleQuantity = new BigDecimal(entity.getMonthSaleQuantity()).subtract(entity.getManualAuditSaleQuantity()).setScale(2, 1);
                entity.setBasicSaleQuantity(restoreBasicSaleQuantity.intValue());
                entity.setTotalSaleQuantity(restoreBasicSaleQuantity.intValue());
                if (priceModelVoMap == null || priceModelVoMap.get(entity.getProductCode()) == null || priceModelVoMap.get(entity.getProductCode()).getPrice() == null) continue;
                entity.setSupplyPrice(priceModelVoMap.get(entity.getProductCode()).getPrice());
                entity.setBasicSaleAmount(restoreBasicSaleQuantity.multiply(entity.getSupplyPrice()));
                entity.setTotalSaleAmount(restoreBasicSaleQuantity.multiply(entity.getSupplyPrice()));
            }
            this.tpmDistributionCustomerMonthSaleEntityRepository.updateBatchById(monthSaleList);
            this.setNewDate(dto);
            return;
        }
        ArrayList policyProductVOList = new ArrayList();
        for (PromotionPolicyVO policy : promotionPolicyVOList) {
            policyProductVOList.addAll(policy.getPromotionPolicyProducts());
        }
        if (CollectionUtils.isEmpty(policyProductVOList)) {
            return;
        }
        Set<String> policyProductCodeSet = policyProductVOList.stream().map(PromotionPolicyProductVO::getProductCode).collect(Collectors.toSet());
        List<String> customerErpCodeList = this.tpmDistributionCustomerMonthSaleEntityRepository.findCustomerErpCodeListByProductListAndYearMonth(policyProductCodeSet, dto.getDistributionCustomerMonthSaleYearMonth());
        for (String customerErpCode : customerErpCodeList) {
            List<TpmDistributionCustomerMonthSaleEntity> monthSaleEntityList = this.tpmDistributionCustomerMonthSaleEntityRepository.findListByCustomerCodeAndYearMonth(customerErpCode, dto.getDistributionCustomerMonthSaleYearMonth());
            if (CollectionUtils.isEmpty(monthSaleEntityList)) continue;
            for (TpmDistributionCustomerMonthSaleEntity entity : monthSaleEntityList) {
                if (entity.getManualAuditSaleQuantity() == null) {
                    entity.setManualAuditSaleQuantity(BigDecimal.ZERO);
                }
                if (entity.getWaitMatchQuantity() == null) {
                    entity.setWaitMatchQuantity(0);
                }
                entity.setTotalSaleQuantity(new BigDecimal(entity.getMonthSaleQuantity()).subtract(entity.getManualAuditSaleQuantity()).add(new BigDecimal(entity.getWaitMatchQuantity())).intValue());
                entity.setWaitMatchQuantity(0);
            }
            Map monthSaleMap = monthSaleEntityList.stream().collect(Collectors.toMap(TpmDistributionCustomerMonthSaleEntity::getProductCode, Function.identity()));
            Map<String, Integer> monthSaleRemainMap = monthSaleEntityList.stream().collect(Collectors.toMap(TpmDistributionCustomerMonthSaleEntity::getProductCode, TpmDistributionCustomerMonthSaleEntity::getTotalSaleQuantity));
            Optional<PromotionPolicyVO> policyOptional = promotionPolicyVOList.stream().filter(o -> BooleanEnum.TRUE.getCapital().equals(o.getCumulative())).findAny();
            if (policyOptional.isPresent()) {
                HashSet<String> usedProductCodeSet = new HashSet<String>();
                for (PromotionPolicyVO promotionPolicyVO : promotionPolicyVOList) {
                    int minNum = 0;
                    if (!CollectionUtils.isNotEmpty((Collection)promotionPolicyVO.getPromotionPolicyProducts())) continue;
                    int counter = 0;
                    for (PromotionPolicyProductVO policyProductVO : promotionPolicyVO.getPromotionPolicyProducts()) {
                        usedProductCodeSet.add(policyProductVO.getProductCode());
                        Integer remainNum = monthSaleRemainMap.get(policyProductVO.getProductCode());
                        if (remainNum == null) {
                            minNum = 0;
                            break;
                        }
                        if (counter == 0 || minNum > remainNum / policyProductVO.getBindingCoefficient()) {
                            minNum = remainNum / policyProductVO.getBindingCoefficient();
                        }
                        ++counter;
                    }
                    if (minNum == 0) continue;
                    for (PromotionPolicyProductVO policyProductVO : promotionPolicyVO.getPromotionPolicyProducts()) {
                        String productCode = policyProductVO.getProductCode();
                        monthSaleRemainMap.put(productCode, monthSaleRemainMap.get(productCode) - minNum * policyProductVO.getBindingCoefficient());
                    }
                }
                for (Map.Entry entry : monthSaleMap.entrySet()) {
                    if (!usedProductCodeSet.contains(entry.getKey())) continue;
                    String productCode = entry.getKey();
                    Integer remainNum = monthSaleRemainMap.get(productCode);
                    TpmDistributionCustomerMonthSaleEntity entity = (TpmDistributionCustomerMonthSaleEntity)((Object)entry.getValue());
                    if (finalProductCodeList.contains(productCode)) {
                        entity.setWaitMatchQuantity(0);
                        entity.setBasicSaleQuantity(remainNum);
                    } else {
                        entity.setWaitMatchQuantity(remainNum);
                        entity.setBasicSaleQuantity(0);
                    }
                    entity.setBoundGiftSaleQuantity(entity.getTotalSaleQuantity() - remainNum);
                    HashSet<String> productCodeSet = new HashSet<String>();
                    productCodeSet.add(productCode);
                    Map<String, PriceModelVo> priceModelVoMap = this.getPlatformSupplyPrice(customerErpCode, productCodeSet, dto.getDistributionCustomerMonthSaleYearMonth());
                    if (priceModelVoMap != null && priceModelVoMap.get(entity.getProductCode()) != null && priceModelVoMap.get(entity.getProductCode()).getPrice() != null) {
                        BigDecimal price = priceModelVoMap.get(productCode).getPrice();
                        entity.setSupplyPrice(price);
                        entity.setTotalSaleAmount(price.multiply(new BigDecimal(entity.getTotalSaleQuantity())));
                        entity.setBoundGiftSaleAmount(price.multiply(new BigDecimal(entity.getBoundGiftSaleQuantity())));
                        entity.setBasicSaleAmount(price.multiply(new BigDecimal(entity.getBasicSaleQuantity())));
                        entity.setWaitMatchAmount(price.multiply(new BigDecimal(entity.getWaitMatchQuantity())));
                    }
                    result.add(entity);
                }
                List list = monthSaleEntityList.stream().filter(o -> !usedProductCodeSet.contains(o.getProductCode())).collect(Collectors.toList());
                for (TpmDistributionCustomerMonthSaleEntity entity : list) {
                    entity.setBoundGiftSaleQuantity(0);
                    entity.setBasicSaleQuantity(entity.getTotalSaleQuantity());
                    entity.setWaitMatchQuantity(0);
                    HashSet<String> productCodeSet = new HashSet<String>();
                    productCodeSet.add(entity.getProductCode());
                    Map<String, PriceModelVo> priceModelVoMap = this.getPlatformSupplyPrice(customerErpCode, productCodeSet, dto.getDistributionCustomerMonthSaleYearMonth());
                    if (priceModelVoMap != null && priceModelVoMap.get(entity.getProductCode()) != null && priceModelVoMap.get(entity.getProductCode()).getPrice() != null) {
                        BigDecimal price = priceModelVoMap.get(entity.getProductCode()).getPrice();
                        entity.setSupplyPrice(price);
                        entity.setTotalSaleAmount(price.multiply(new BigDecimal(entity.getTotalSaleQuantity())));
                        entity.setBoundGiftSaleAmount(price.multiply(new BigDecimal(entity.getBoundGiftSaleQuantity())));
                        entity.setBasicSaleAmount(price.multiply(new BigDecimal(entity.getBasicSaleQuantity())));
                        entity.setWaitMatchAmount(price.multiply(new BigDecimal(entity.getWaitMatchQuantity())));
                    }
                    result.add(entity);
                }
                continue;
            }
            for (PromotionPolicyVO promotionPolicyVO : promotionPolicyVOList) {
                int n = 0;
                if (!CollectionUtils.isNotEmpty((Collection)promotionPolicyVO.getPromotionPolicyProducts())) continue;
                int counter = 0;
                for (PromotionPolicyProductVO policyProductVO : promotionPolicyVO.getPromotionPolicyProducts()) {
                    Integer remainNum = monthSaleRemainMap.get(policyProductVO.getProductCode());
                    if (remainNum == null) {
                        n = 0;
                        break;
                    }
                    if (counter == 0 || n > remainNum / policyProductVO.getBindingCoefficient()) {
                        n = remainNum / policyProductVO.getBindingCoefficient();
                    }
                    ++counter;
                }
                if (n == 0) continue;
                for (PromotionPolicyProductVO policyProductVO : promotionPolicyVO.getPromotionPolicyProducts()) {
                    String productCode = policyProductVO.getProductCode();
                    monthSaleRemainMap.put(productCode, monthSaleRemainMap.get(productCode) - n * policyProductVO.getBindingCoefficient());
                }
            }
            for (Map.Entry entry : monthSaleMap.entrySet()) {
                String string = (String)entry.getKey();
                Integer remainNum = monthSaleRemainMap.get(string);
                TpmDistributionCustomerMonthSaleEntity entity = (TpmDistributionCustomerMonthSaleEntity)((Object)entry.getValue());
                entity.setBoundGiftSaleQuantity(entity.getTotalSaleQuantity() - remainNum);
                entity.setWaitMatchQuantity(0);
                entity.setBasicSaleQuantity(remainNum);
                HashSet<String> productCodeSet = new HashSet<String>();
                productCodeSet.add(entity.getProductCode());
                Map<String, PriceModelVo> priceModelVoMap = this.getPlatformSupplyPrice(customerErpCode, productCodeSet, dto.getDistributionCustomerMonthSaleYearMonth());
                if (priceModelVoMap != null && priceModelVoMap.get(string) != null && priceModelVoMap.get(string).getPrice() != null) {
                    BigDecimal price = priceModelVoMap.get(string).getPrice();
                    entity.setSupplyPrice(price);
                    entity.setTotalSaleAmount(price.multiply(new BigDecimal(entity.getTotalSaleQuantity())));
                    entity.setBoundGiftSaleAmount(price.multiply(new BigDecimal(entity.getBoundGiftSaleQuantity())));
                    entity.setBasicSaleAmount(price.multiply(new BigDecimal(entity.getBasicSaleQuantity())));
                    entity.setWaitMatchAmount(price.multiply(new BigDecimal(entity.getWaitMatchQuantity())));
                }
                result.add(entity);
            }
        }
        if (CollectionUtils.isNotEmpty(result)) {
            this.tpmDistributionCustomerMonthSaleEntityRepository.updateBatchById(result);
        }
        this.setNewDate(dto);
    }

    private void setNewDate(TpmDistributionCustomerMonthSaleDto dto) {
        String month = dto.getDistributionCustomerMonthSaleYearMonth();
        if (StringUtils.isEmpty((CharSequence)month)) {
            return;
        }
        String lastMonth = month + "-01";
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        DateTimeFormatter dtf2 = DateTimeFormatter.ofPattern("yyyy-MM");
        lastMonth = dtf2.format(LocalDate.parse(lastMonth, dtf).minusMonths(1L));
        log.info("\u5206\u9500\u5ba2\u6237\u6708\u5ea6\u9500\u552e\u62a5\u8868\u8fd8\u539f1\uff1alastMonth\uff1a{},month:{}", (Object)lastMonth, (Object)month);
        List<TpmDistributionCustomerMonthSaleEntity> lastMonthData = this.tpmDistributionCustomerMonthSaleEntityRepository.findByYearMonth(lastMonth);
        List<TpmDistributionCustomerMonthSaleEntity> thisMonthData = this.tpmDistributionCustomerMonthSaleEntityRepository.findByYearMonth(month);
        if (CollectionUtils.isEmpty(thisMonthData)) {
            return;
        }
        log.info("\u5206\u9500\u5ba2\u6237\u6708\u5ea6\u9500\u552e\u62a5\u8868\u8fd8\u539f2:lastMonthData:{},thisMonthData:{}", (Object)JsonUtils.obj2JsonString(lastMonthData), (Object)JsonUtils.obj2JsonString(thisMonthData));
        Map lastMonthDataMap = lastMonthData.stream().collect(Collectors.toMap(o -> o.getCustomerCode() + o.getProductCode(), Function.identity(), (n, o) -> o));
        ArrayList<TpmDistributionCustomerMonthSaleEntity> update = new ArrayList<TpmDistributionCustomerMonthSaleEntity>();
        Iterator<TpmDistributionCustomerMonthSaleEntity> iterator = thisMonthData.iterator();
        while (iterator.hasNext()) {
            TpmDistributionCustomerMonthSaleEntity thisMonthDatum;
            TpmDistributionCustomerMonthSaleEntity one = (TpmDistributionCustomerMonthSaleEntity)((Object)lastMonthDataMap.get((thisMonthDatum = iterator.next()).getCustomerCode() + thisMonthDatum.getProductCode()));
            thisMonthDatum.setLastMonthNoMatchingQuantity(one == null || one.getWaitMatchQuantity() == null ? BigDecimal.ZERO : new BigDecimal(one.getWaitMatchQuantity()));
            BigDecimal boundGiftSaleQuantity = new BigDecimal(Optional.ofNullable(thisMonthDatum.getBoundGiftSaleQuantity()).orElse(0));
            thisMonthDatum.setLastMonthSaleCombinationQuantity(thisMonthDatum.getLastMonthNoMatchingQuantity().compareTo(boundGiftSaleQuantity) <= 0 ? thisMonthDatum.getLastMonthNoMatchingQuantity() : boundGiftSaleQuantity);
            thisMonthDatum.setLastMonthBaseSaleQuantity(thisMonthDatum.getLastMonthNoMatchingQuantity().subtract(thisMonthDatum.getLastMonthSaleCombinationQuantity()));
            thisMonthDatum.setThisMonthSaleCombinationQuantity(boundGiftSaleQuantity.subtract(thisMonthDatum.getLastMonthSaleCombinationQuantity()));
            BigDecimal monthSaleQuantity = new BigDecimal(Optional.ofNullable(thisMonthDatum.getMonthSaleQuantity()).orElse(0));
            BigDecimal manualAuditSaleQuantity = Optional.ofNullable(thisMonthDatum.getManualAuditSaleQuantity()).orElse(BigDecimal.ZERO);
            thisMonthDatum.setBasicSaleQuantity(monthSaleQuantity.subtract(manualAuditSaleQuantity).subtract(thisMonthDatum.getThisMonthSaleCombinationQuantity()).intValue());
            TpmDistributionCustomerMonthSaleEntity one2 = new TpmDistributionCustomerMonthSaleEntity();
            one2.setId(thisMonthDatum.getId());
            one2.setLastMonthNoMatchingQuantity(thisMonthDatum.getLastMonthNoMatchingQuantity());
            one2.setLastMonthSaleCombinationQuantity(thisMonthDatum.getLastMonthSaleCombinationQuantity());
            one2.setLastMonthBaseSaleQuantity(thisMonthDatum.getLastMonthBaseSaleQuantity());
            one2.setThisMonthSaleCombinationQuantity(thisMonthDatum.getThisMonthSaleCombinationQuantity());
            one2.setBasicSaleQuantity(thisMonthDatum.getBasicSaleQuantity());
            update.add(one2);
        }
        if (CollectionUtils.isNotEmpty(update)) {
            this.tpmDistributionCustomerMonthSaleEntityRepository.updateBatchById(update);
        }
    }

    private Map<String, PriceModelVo> getPlatformSupplyPrice(String customerErpCode, Set<String> productCodeList, String yearMonth) {
        this.loginUserService.refreshAuthentication(null);
        SearchPriceDto searchPriceDto = new SearchPriceDto();
        searchPriceDto.setPriceTypeCode(PriceTypeEnum.PLATFORM_SUPPLY_PRICE.getDictCode());
        searchPriceDto.setDimensionItems(new ArrayList());
        SearchPriceDimensionItemDto customerDimension = new SearchPriceDimensionItemDto();
        customerDimension.setDimensionCode(PriceDimensionEnum.CUSTOMER.getDictCode());
        HashSet<String> customerCodeSet = new HashSet<String>();
        customerCodeSet.add(customerErpCode);
        customerDimension.setRelateCodeSet(customerCodeSet);
        searchPriceDto.getDimensionItems().add(customerDimension);
        SearchPriceDimensionItemDto productDimension = new SearchPriceDimensionItemDto();
        productDimension.setDimensionCode(PriceDimensionEnum.MATERIAL.getDictCode());
        productDimension.setRelateCodeSet(productCodeList);
        searchPriceDto.getDimensionItems().add(productDimension);
        searchPriceDto.setSearchTime(DateUtil.parse((String)(yearMonth + "-01"), (String)"yyyy-MM-dd"));
        return this.priceModelVoService.handleSearchPrice(searchPriceDto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchUpdate(List<TpmDistributionCustomerMonthSaleDto> distributionCustomerMonthSaleDtos) {
        Collection entities = this.nebulaToolkitService.copyCollectionByWhiteList(distributionCustomerMonthSaleDtos, TpmDistributionCustomerMonthSaleDto.class, TpmDistributionCustomerMonthSaleEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.tpmDistributionCustomerMonthSaleEntityRepository.updateBatchById(entities);
    }

    public List<TpmDistributionCustomerMonthSaleRespVo> findDistribution(TpmDistributionCustomerMonthSaleDto distributionCustomerMonthSaleDto) {
        List<TpmDistributionCustomerMonthSaleEntity> list = this.tpmDistributionCustomerMonthSaleEntityRepository.findDistributionCustomerMonthSale(distributionCustomerMonthSaleDto);
        return this.nebulaToolkitService.copyCollectionByWhiteList(list, TpmDistributionCustomerMonthSaleEntity.class, TpmDistributionCustomerMonthSaleRespVo.class, HashSet.class, ArrayList.class, new String[0]).stream().collect(Collectors.toList());
    }

    public BigDecimal getTotalSaleAmount(TpmDistributionCustomerMonthSaleDto distributionCustomerMonthSale) {
        return this.tpmDistributionCustomerMonthSaleEntityRepository.getTotalSaleAmount(distributionCustomerMonthSale);
    }

    public BigDecimal getYearTotalSaleAmount(TpmDistributionCustomerMonthSaleDto dto) {
        return this.tpmDistributionCustomerMonthSaleEntityRepository.getYearTotalSaleAmount(dto);
    }

    public List<TpmDistributionCustomerMonthSaleRespVo> findCustomerMonthSalesByParams(TpmDistributionCustomerMonthSaleDto distributionCustomerMonthSale) {
        return this.tpmDistributionCustomerMonthSaleEntityRepository.findCustomerMonthSalesByParams(distributionCustomerMonthSale);
    }

    public void beRepeat(List<TpmDistributionCustomerMonthSaleDto> distributionCustomerMonthSaleDtos) {
        distributionCustomerMonthSaleDtos.forEach(e -> {
            Integer count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.tpmDistributionCustomerMonthSaleEntityRepository.lambdaQuery().ne(UuidEntity::getId, (Object)e.getId())).eq(TpmDistributionCustomerMonthSaleEntity::getCustomerCode, (Object)e.getCustomerCode())).eq(TpmDistributionCustomerMonthSaleEntity::getDistributionCustomerMonthSaleYearMonth, (Object)e.getDistributionCustomerMonthSaleYearMonth())).eq(TpmDistributionCustomerMonthSaleEntity::getChannelCode, (Object)e.getChannelCode())).eq(TpmDistributionCustomerMonthSaleEntity::getSalesInstitutionCode, (Object)e.getSalesInstitutionCode())).eq(TpmDistributionCustomerMonthSaleEntity::getBusinessFormatCode, (Object)e.getBusinessFormatCode())).eq(TpmDistributionCustomerMonthSaleEntity::getProductCode, (Object)e.getProductCode())).count();
            if (count > 0) {
                throw new IllegalArgumentException("\u884cid\u3010" + e.getId() + "\u3011\u5728\u8868\u4e2d\u5b58\u5728\u91cd\u590d\u6570\u636e");
            }
        });
    }

    public List<TpmDistributionCustomerMonthSaleRespVo> listForVariable(TpmDistributionCustomerMonthSaleDto dto, String yearMonthType) {
        if (StringUtils.isNotEmpty((CharSequence)dto.getCustomerCode()) && StringUtils.isNotEmpty((CharSequence)dto.getSalesInstitutionCode()) && StringUtils.isNotEmpty((CharSequence)dto.getBusinessFormatCode()) && StringUtils.isNotEmpty((CharSequence)dto.getChannelCode()) && StringUtils.isNotEmpty((CharSequence)dto.getDistributionCustomerMonthSaleYearMonth())) {
            if (yearMonthType.equals("year")) {
                String year = dto.getDistributionCustomerMonthSaleYearMonth().substring(0, 4);
                String m = dto.getDistributionCustomerMonthSaleYearMonth().substring(5, dto.getDistributionCustomerMonthSaleYearMonth().length());
                StringBuilder start = new StringBuilder();
                StringBuilder end = new StringBuilder();
                if (m.equals("01")) {
                    start = start.append(Integer.parseInt(year) - 1).append("-01");
                    end = end.append(Integer.parseInt(year) - 1).append("-12");
                } else {
                    start = start.append(year).append("-01");
                    end = end.append(dto.getDistributionCustomerMonthSaleYearMonth());
                }
                List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.tpmDistributionCustomerMonthSaleEntityRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getCustomerCode()), TpmDistributionCustomerMonthSaleEntity::getCustomerCode, (Object)dto.getCustomerCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getSalesInstitutionCode()), TpmDistributionCustomerMonthSaleEntity::getSalesInstitutionCode, (Object)dto.getSalesInstitutionCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getBusinessFormatCode()), TpmDistributionCustomerMonthSaleEntity::getBusinessFormatCode, (Object)dto.getBusinessFormatCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getChannelCode()), TpmDistributionCustomerMonthSaleEntity::getChannelCode, (Object)dto.getChannelCode())).between(StringUtils.isNotEmpty((CharSequence)start) && StringUtils.isNotEmpty((CharSequence)end), TpmDistributionCustomerMonthSaleEntity::getDistributionCustomerMonthSaleYearMonth, (Object)start.toString(), (Object)end.toString())).in(CollectionUtils.isNotEmpty((Collection)dto.getIncludeProductCodeList()), TpmDistributionCustomerMonthSaleEntity::getProductCode, (Collection)dto.getIncludeProductCodeList())).eq(StringUtils.isNotEmpty((CharSequence)dto.getProductCode()), TpmDistributionCustomerMonthSaleEntity::getProductCode, (Object)dto.getProductCode())).list();
                return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, TpmDistributionCustomerMonthSaleEntity.class, TpmDistributionCustomerMonthSaleRespVo.class, HashSet.class, ArrayList.class, new String[0]);
            }
            List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.tpmDistributionCustomerMonthSaleEntityRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getCustomerCode()), TpmDistributionCustomerMonthSaleEntity::getCustomerCode, (Object)dto.getCustomerCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getSalesInstitutionCode()), TpmDistributionCustomerMonthSaleEntity::getSalesInstitutionCode, (Object)dto.getSalesInstitutionCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getBusinessFormatCode()), TpmDistributionCustomerMonthSaleEntity::getBusinessFormatCode, (Object)dto.getBusinessFormatCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getChannelCode()), TpmDistributionCustomerMonthSaleEntity::getChannelCode, (Object)dto.getChannelCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getProductCode()), TpmDistributionCustomerMonthSaleEntity::getProductCode, (Object)dto.getProductCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getDistributionCustomerMonthSaleYearMonth()), TpmDistributionCustomerMonthSaleEntity::getDistributionCustomerMonthSaleYearMonth, (Object)dto.getDistributionCustomerMonthSaleYearMonth())).in(CollectionUtils.isNotEmpty((Collection)dto.getIncludeProductCodeList()), TpmDistributionCustomerMonthSaleEntity::getProductCode, (Collection)dto.getIncludeProductCodeList())).list();
            return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, TpmDistributionCustomerMonthSaleEntity.class, TpmDistributionCustomerMonthSaleRespVo.class, HashSet.class, ArrayList.class, new String[0]);
        }
        return Lists.newArrayList();
    }

    public List<TpmDistributionCustomerMonthSaleRespVo> listForSplitCustomer(TpmDistributionCustomerMonthSaleDto dto) {
        List<TpmDistributionCustomerMonthSaleEntity> list = this.tpmDistributionCustomerMonthSaleEntityRepository.listForSplitCustomer(dto);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<TpmDistributionCustomerMonthSaleRespVo>();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, TpmDistributionCustomerMonthSaleEntity.class, TpmDistributionCustomerMonthSaleRespVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<TpmDistributionCustomerMonthSaleRespVo> findCustomerMonthSale(List<String> onlyDimensionList) {
        List list = ((LambdaQueryChainWrapper)this.tpmDistributionCustomerMonthSaleEntityRepository.lambdaQuery().in(TpmDistributionCustomerMonthSaleEntity::getVerifyCode, onlyDimensionList)).list();
        return new ArrayList<TpmDistributionCustomerMonthSaleRespVo>(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, TpmDistributionCustomerMonthSaleEntity.class, TpmDistributionCustomerMonthSaleRespVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.NOT_SUPPORTED)
    public void pullData(String ds) {
        Assert.hasLength((String)ds, (String)"ds\u65f6\u95f4[yyyyMMdd]\u4e0d\u80fd\u4e3a\u7a7a!");
        try {
            Date date = DateUtil.date_yyyyMMdd.parse(ds);
            Assert.isTrue((boolean)ds.equals(DateUtil.date_yyyyMMdd.format(date)), (String)"\u5e74\u6708\u683c\u5f0f\u9519\u8bef\u3010yyyyMMdd\u3011");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u5e74\u6708\u683c\u5f0f\u9519\u8bef\u3010yyyyMMdd\u3011");
        }
        boolean lockSuccess = this.redisLockService.tryLock("tpm:global_distribution_customer_month_sale:lock:" + ds, TimeUnit.HOURS, 2L);
        if (!lockSuccess) {
            log.error("\u5206\u9500\u5ba2\u6237\u6708\u5ea6\u9500\u552e\u63a5\u53d7\u5230\u65e5\u9500\u552e\u6570\u636e\u5904\u7406\u4e2d");
            return;
        }
        String financialYear = ds.substring(0, 4);
        String financialMonth = String.format("%3s", ds.substring(4, 6)).replace(" ", "0");
        try {
            Page fullVo2Page = null;
            PageRequest pageable = PageRequest.of((int)1, (int)600);
            do {
                fullVo2Page = this.ce1MnjtSdkService.getMonthSummaryByFinancialYearAndFinancialMonth((Pageable)pageable, financialYear, financialMonth);
                log.info("=====>    \u5206\u9500\u5ba2\u6237\u6708\u5ea6\u9500\u552e\u63a5\u53d7\u5230\u65e5\u9500\u552e\u6570\u636e[{}],[{}/{}]  size[{}] <=====", new Object[]{ds, fullVo2Page.getCurrent(), fullVo2Page.getPages(), fullVo2Page.getSize()});
                pageable = pageable.next();
                if (CollectionUtil.isEmpty((Collection)fullVo2Page.getRecords())) {
                    return;
                }
                List<TpmDistributionCustomerMonthSaleDto> list = this.buildSalesData(fullVo2Page.getRecords());
            } while (fullVo2Page.hasNext());
        }
        catch (Exception e) {
            log.error("\u5206\u9500\u5ba2\u6237\u6708\u5ea6\u9500\u552e\u63a5\u53d7\u5230\u65e5\u9500\u552e\u6570\u636e\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        finally {
            this.redisLockService.unlock("tpm:global_distribution_customer_month_sale:lock:" + ds);
        }
    }

    private List<TpmDistributionCustomerMonthSaleDto> buildSalesData(List<Ce1MnjtFullVo2> summaryData) {
        List salesOrgVoList;
        List productVoList;
        List customerVoList;
        if (CollectionUtil.isEmpty(summaryData)) {
            return Collections.emptyList();
        }
        ArrayList saleDtoList = Lists.newArrayList();
        Set customerCodeSet = summaryData.stream().map(this::generateCustomerCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Map customerVoMap = null;
        if (CollectionUtils.isNotEmpty(customerCodeSet) && CollectionUtils.isNotEmpty((Collection)(customerVoList = this.customerVoService.findBaseByCustomerCodes(new ArrayList(customerCodeSet))))) {
            customerVoMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
        }
        Set productCodeSet = summaryData.stream().filter(k -> StringUtil.isNotEmpty((String)k.getProductCode())).map(Ce1MnjtFullVo2::getProductCode).collect(Collectors.toSet());
        Map productVoMap = null;
        if (CollectionUtils.isNotEmpty(productCodeSet) && CollectionUtils.isNotEmpty((Collection)(productVoList = this.productVoService.findByProductCodes(new ArrayList(productCodeSet))))) {
            productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
        }
        Set salesOrgCodeSet = summaryData.stream().map(this::generateSalesOrgCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Map salesOrgVoMap = null;
        if (CollectionUtils.isNotEmpty(salesOrgCodeSet) && CollectionUtils.isNotEmpty((Collection)(salesOrgVoList = this.salesOrgVoService.findBySalesOrgCodesPost(new ArrayList(salesOrgCodeSet))))) {
            salesOrgVoMap = salesOrgVoList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity()));
        }
        for (Ce1MnjtFullVo2 vo : summaryData) {
            TpmDistributionCustomerMonthSaleDto dto = new TpmDistributionCustomerMonthSaleDto();
            if (customerVoMap == null || customerVoMap.get(this.generateCustomerCode(vo)) == null || StringUtils.isEmpty((CharSequence)((CustomerVo)customerVoMap.get(this.generateCustomerCode(vo))).getBusinessModelCode()) || !CharSequenceUtil.equals((CharSequence)BUSINESS_MODEL_CODE, (CharSequence)((CustomerVo)customerVoMap.get(this.generateCustomerCode(vo))).getBusinessModelCode())) continue;
            dto.setCustomerName(((CustomerVo)customerVoMap.get(this.generateCustomerCode(vo))).getCustomerName());
            dto.setBusinessFormatCode(vo.getProductTeamCode());
            dto.setSalesInstitutionCode(vo.getSaleOrgCode());
            dto.setChannelCode(vo.getDistributionChannelCode());
            dto.setCustomerCode(vo.getCustomerCode());
            dto.setDistributionCustomerMonthSaleYearMonth(vo.getFiscalYear() + "-" + String.format("%02d", Integer.valueOf(vo.getPeriod())));
            dto.setProductCode(vo.getProductCode());
            dto.setMonthSaleQuantity(Integer.valueOf(vo.getSalesVolumes().intValue()));
            dto.setMonthSaleAmount(new BigDecimal(vo.getSalesIncludingTaxNet()));
            dto.setRevertFlag(BooleanEnum.FALSE.getCapital());
            if (salesOrgVoMap != null && salesOrgVoMap.get(this.generateSalesOrgCode(vo)) != null) {
                dto.setSalesInstitutionName(((SalesOrgVo)salesOrgVoMap.get(this.generateSalesOrgCode(vo))).getSalesOrgName());
            }
            if (productVoMap != null && productVoMap.get(vo.getProductCode()) != null) {
                dto.setProductName(((ProductVo)productVoMap.get(vo.getProductCode())).getProductName());
            }
            String verifyCode = vo.getSaleOrgCode() + vo.getDistributionChannelCode() + vo.getProductTeamCode() + vo.getCustomerCode() + vo.getProductCode() + vo.getFiscalYear() + vo.getPeriod();
            dto.setVerifyCode(verifyCode);
            saleDtoList.add(dto);
        }
        return saleDtoList;
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.NOT_SUPPORTED)
    public void batchSave(List<TpmDistributionCustomerMonthSaleDto> dtos) {
        if (CollectionUtil.isEmpty(dtos)) {
            return;
        }
        if (CollectionUtil.isEmpty(dtos = dtos.stream().filter(k -> StringUtil.isNotEmpty((String)k.getVerifyCode())).collect(Collectors.toList()))) {
            return;
        }
        List<String> verifyCodeList = dtos.stream().filter(k -> StringUtil.isNotEmpty((String)k.getVerifyCode())).map(TpmDistributionCustomerMonthSaleDto::getVerifyCode).distinct().collect(Collectors.toList());
        List<TpmDistributionCustomerMonthSaleEntity> oldSaleEntityList = this.tpmDistributionCustomerMonthSaleEntityRepository.findByVerifyCodeList(verifyCodeList);
        HashMap oldSaleEntityMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(oldSaleEntityList)) {
            oldSaleEntityMap.putAll(oldSaleEntityList.stream().collect(Collectors.toMap(TpmDistributionCustomerMonthSaleEntity::getVerifyCode, v -> v, (n, o) -> n)));
        }
        ArrayList<TpmDistributionCustomerMonthSaleEntity> newList = new ArrayList<TpmDistributionCustomerMonthSaleEntity>();
        ArrayList<TpmDistributionCustomerMonthSaleEntity> updateList = new ArrayList<TpmDistributionCustomerMonthSaleEntity>();
        Map<String, List<TpmDistributionCustomerMonthSaleDto>> saveOrUpdateMap = dtos.stream().collect(Collectors.groupingBy(TpmDistributionCustomerMonthSaleDto::getVerifyCode));
        for (Map.Entry<String, List<TpmDistributionCustomerMonthSaleDto>> one : saveOrUpdateMap.entrySet()) {
            TpmDistributionCustomerMonthSaleEntity oldEntity = (TpmDistributionCustomerMonthSaleEntity)((Object)oldSaleEntityMap.get(one.getKey()));
            if (oldEntity == null) {
                TpmDistributionCustomerMonthSaleEntity newEntity = new TpmDistributionCustomerMonthSaleEntity();
                BeanUtils.copyProperties((Object)one.getValue().get(0), (Object)((Object)newEntity));
                newEntity.setMonthSaleQuantity(one.getValue().get(0).getMonthSaleQuantity());
                newEntity.setMonthSaleAmount(BigDecimal.ZERO);
                newEntity.setMonthSaleQuantity(0);
                for (TpmDistributionCustomerMonthSaleDto dto : one.getValue()) {
                    newEntity.setMonthSaleAmount(newEntity.getMonthSaleAmount().add(Optional.ofNullable(dto.getMonthSaleAmount()).orElse(BigDecimal.ZERO)));
                    newEntity.setMonthSaleQuantity(newEntity.getMonthSaleQuantity() + Optional.ofNullable(dto.getMonthSaleQuantity()).orElse(0));
                }
                newEntity.setId(null);
                newEntity.setTenantCode(TenantUtils.getTenantCode());
                newEntity.setNumEnable(Optional.ofNullable(newEntity.getNumEnable()).orElse(0));
                newList.add(newEntity);
                continue;
            }
            for (TpmDistributionCustomerMonthSaleDto dto : one.getValue()) {
                oldEntity.setMonthSaleAmount(Optional.ofNullable(dto.getMonthSaleAmount()).orElse(BigDecimal.ZERO));
                oldEntity.setMonthSaleQuantity(Optional.ofNullable(dto.getMonthSaleQuantity()).orElse(0));
            }
            oldEntity.setNumEnable(Optional.ofNullable(oldEntity.getNumEnable()).orElse(0));
            updateList.add(oldEntity);
        }
        if (CollectionUtil.isNotEmpty(newList)) {
            this.tpmDistributionCustomerMonthSaleEntityRepository.saveBatch(newList);
        }
        if (CollectionUtil.isNotEmpty(updateList)) {
            this.tpmDistributionCustomerMonthSaleEntityRepository.updateBatchById(updateList);
        }
    }

    public List<TpmDistributionCustomerMonthSaleRespVo> findAllByYearMonth(String distributionCustomerMonthSaleYearMonth) {
        if (StringUtils.isBlank((CharSequence)distributionCustomerMonthSaleYearMonth)) {
            return null;
        }
        return this.tpmDistributionCustomerMonthSaleEntityRepository.findAllByYearMonth(distributionCustomerMonthSaleYearMonth);
    }

    public List<TpmDistributionCustomerMonthSaleRespVo> findByCustomer(Collection<TpmDistributionCustomerMonthSaleDto> customerMonthSaleDtos) {
        if (CollectionUtils.isEmpty(customerMonthSaleDtos)) {
            return null;
        }
        return this.tpmDistributionCustomerMonthSaleEntityRepository.findByCustomer(customerMonthSaleDtos);
    }

    @Transactional
    public Integer autoGenerateData(String yearMonth) {
        if (StringUtils.isEmpty((CharSequence)yearMonth)) {
            yearMonth = DateUtil.format((Date)new Date(), (String)"yyyy-MM");
        }
        this.tpmDistributionCustomerMonthSaleEntityRepository.deleteAutoCreateData(yearMonth);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.parse((String)(yearMonth + "-01"), (String)"yyyy-MM-dd"));
        calendar.add(2, -1);
        String lastYearMonth = DateUtil.getDateStrByFormat((Date)calendar.getTime(), (String)"yyyy-MM");
        int total = 0;
        int current = 1;
        while (current < 1000) {
            Page page = new Page((long)current, 2000L);
            log.info("\u5206\u9500\u5ba2\u6237\u6708\u5ea6\u9500\u552e\u8868-\u6839\u636e\u4e0a\u6708\u5f85\u5339\u914d\u6570\u636e\u81ea\u52a8\u751f\u6210\u6570\u636e \u9875\u7801[{}] \u6570\u91cf[{}]", (Object)page.getCurrent(), (Object)page.getSize());
            ++current;
            List<TpmDistributionCustomerMonthSaleEntity> autoCreateData = this.tpmDistributionCustomerMonthSaleEntityRepository.findAutoCreateData(lastYearMonth, page);
            log.info("\u5206\u9500\u5ba2\u6237\u6708\u5ea6\u9500\u552e\u8868-\u6839\u636e\u4e0a\u6708\u5f85\u5339\u914d\u6570\u636e\u81ea\u52a8\u751f\u6210\u6570\u636e \u9875\u7801[{}] \u7ed3\u679c[{}]", (Object)page.getCurrent(), (Object)autoCreateData.size());
            if (CollectionUtils.isEmpty(autoCreateData)) break;
            total += autoCreateData.size();
            for (TpmDistributionCustomerMonthSaleEntity entity : autoCreateData) {
                entity.setSupplyPrice(BigDecimal.ZERO);
                entity.setMonthSaleQuantity(0);
                entity.setMonthSaleAmount(BigDecimal.ZERO);
                entity.setTotalSaleQuantity(0);
                entity.setTotalSaleAmount(BigDecimal.ZERO);
                entity.setBoundGiftSaleQuantity(0);
                entity.setBoundGiftSaleAmount(BigDecimal.ZERO);
                entity.setBasicSaleQuantity(0);
                entity.setBasicSaleAmount(BigDecimal.ZERO);
                entity.setNumEnable(0);
                entity.setRidSaleQuantity(BigDecimal.ZERO);
                entity.setRidSaleAmount(BigDecimal.ZERO);
                entity.setManualAuditSaleQuantity(BigDecimal.ZERO);
                entity.setManualAuditSaleAmount(BigDecimal.ZERO);
                entity.setDistributorAnnualAmount(BigDecimal.ZERO);
                entity.setDistributorAnnualQuantity(BigDecimal.ZERO);
                entity.setLastMonthNoMatchingQuantity(BigDecimal.ZERO);
                entity.setLastMonthSaleCombinationQuantity(BigDecimal.ZERO);
                entity.setThisMonthSaleCombinationQuantity(BigDecimal.ZERO);
                entity.setLastMonthBaseSaleQuantity(BigDecimal.ZERO);
                entity.setAutoCreate(YesOrNoEnum.YES.getCode());
                entity.setId(UuidCrmUtil.general());
                entity.setDistributionCustomerMonthSaleYearMonth(yearMonth);
                entity.setTenantCode(TenantUtils.getTenantCode());
                entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            }
            this.tpmDistributionCustomerMonthSaleEntityRepository.saveBatch(autoCreateData);
        }
        return total;
    }

    private String generateCustomerCode(Ce1MnjtFullVo2 vo) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getCustomerCode()) && StringUtils.isNotEmpty((CharSequence)vo.getSaleOrgCode()) && StringUtils.isNotEmpty((CharSequence)vo.getDistributionChannelCode()) && StringUtils.isNotEmpty((CharSequence)vo.getProductTeamCode())) {
            return vo.getCustomerCode() + vo.getSaleOrgCode() + vo.getDistributionChannelCode() + vo.getProductTeamCode();
        }
        return null;
    }

    private String generateSalesOrgCode(Ce1MnjtFullVo2 vo) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getSaleOrgCode()) && StringUtils.isNotEmpty((CharSequence)vo.getDistributionChannelCode()) && StringUtils.isNotEmpty((CharSequence)vo.getProductTeamCode())) {
            return vo.getDistributionChannelCode() + vo.getProductTeamCode() + vo.getSaleOrgCode();
        }
        return null;
    }

    private int getMinBoundGiftQuantity(Map.Entry<String, List<TpmDistributionCustomerMonthSaleDto>> entry, List<PromotionPolicyProductVO> customerProductPromotionPolicyList) {
        int minBoundGiftQuantity = 0;
        for (TpmDistributionCustomerMonthSaleDto monthSaleDto : entry.getValue()) {
            Optional<PromotionPolicyProductVO> productPromotionPolicy = customerProductPromotionPolicyList.stream().filter(o -> o.getProductCode().equals(monthSaleDto.getProductCode())).findFirst();
            if (!productPromotionPolicy.isPresent()) continue;
            int currentBoundGiftQuantity = monthSaleDto.getMonthSaleQuantity() / productPromotionPolicy.get().getBindingCoefficient();
            if (minBoundGiftQuantity == 0) {
                minBoundGiftQuantity = currentBoundGiftQuantity;
                continue;
            }
            if (minBoundGiftQuantity <= currentBoundGiftQuantity) continue;
            minBoundGiftQuantity = currentBoundGiftQuantity;
        }
        return minBoundGiftQuantity;
    }
}

