/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.distribution.customer.month.sale.local.service.process;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.dto.TpmDistributionCustomerMonthSaleDto;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.service.TpmDistributionCustomerMonthSaleService;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.vo.TpmDistributionCustomerMonthSaleImportVo;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DistributionCustomerMonthSaleImportsProcess
implements ImportProcess<TpmDistributionCustomerMonthSaleImportVo> {
    private static final Logger log = LoggerFactory.getLogger(DistributionCustomerMonthSaleImportsProcess.class);
    @Autowired(required=false)
    private TpmDistributionCustomerMonthSaleService tpmDistributionCustomerMonthSaleService;

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, TpmDistributionCustomerMonthSaleImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        try {
            List<TpmDistributionCustomerMonthSaleDto> dtoList = this.validate(data, params);
            this.tpmDistributionCustomerMonthSaleService.batchUpdate(dtoList);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            String errorMsg = e.getMessage();
            if (StringUtils.isEmpty((CharSequence)e.getMessage())) {
                errorMsg = "\u6570\u636e\u5904\u7406\u5931\u8d25\uff01";
            }
            throw new IllegalArgumentException(errorMsg);
        }
        return null;
    }

    private List<TpmDistributionCustomerMonthSaleDto> validate(LinkedHashMap<Integer, TpmDistributionCustomerMonthSaleImportVo> data, Map<String, Object> params) {
        ArrayList<TpmDistributionCustomerMonthSaleImportVo> importList = new ArrayList<TpmDistributionCustomerMonthSaleImportVo>(data.values());
        ArrayList<TpmDistributionCustomerMonthSaleDto> dtoList = new ArrayList<TpmDistributionCustomerMonthSaleDto>();
        for (TpmDistributionCustomerMonthSaleImportVo importVo : importList) {
            Validate.notBlank((CharSequence)importVo.getId(), (String)"\u884cid\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)importVo.getRidSaleQuantity(), (String)"\u6708\u5ea6\u5243\u91cf\u6570\u91cf\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)importVo.getRidSaleAmount(), (String)"\u6708\u5ea6\u5243\u91cf\u91d1\u989d\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            TpmDistributionCustomerMonthSaleDto dto = new TpmDistributionCustomerMonthSaleDto();
            dto.setId(importVo.getId());
            dto.setRidSaleAmount(importVo.getRidSaleAmount());
            dto.setRidSaleQuantity(importVo.getRidSaleQuantity());
            dto.setManualAuditSaleAmount(importVo.getManualAuditSaleAmount());
            dto.setManualAuditSaleQuantity(importVo.getManualAuditSaleQuantity());
            dto.setDistributorAnnualAmount(importVo.getDistributorAnnualAmount());
            dto.setDistributorAnnualQuantity(importVo.getDistributorAnnualQuantity());
            dtoList.add(dto);
        }
        return dtoList;
    }

    public Class<TpmDistributionCustomerMonthSaleImportVo> findCrmExcelVoClass() {
        return TpmDistributionCustomerMonthSaleImportVo.class;
    }

    public String getTemplateCode() {
        return "TPM_DISTRIBUTION_CUSTOMER_MONTH_SALE_IMPORT";
    }

    public String getTemplateName() {
        return "TPM\u5206\u9500\u5ba2\u6237\u6708\u5ea6\u9500\u552e\u8868\u5bfc\u5165\u6a21\u677f";
    }
}

