package com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.List;

/**
 * @ClassName DistributionCustomerMonthSaleDto
 * @Description
 * @Author: jiangyin
 * @Date 2022/11/16
 */
@Data
@ApiModel("分销客户月度销售统计数据传输类")
public class TpmDistributionCustomerMonthSaleDto extends TenantFlagOpDto {

    @ApiModelProperty(value = "客户编码")
    private String customerCode;
    private List<String> customerCodeList;

    @ApiModelProperty(value = "客户名称")
    private String customerName;

    @ApiModelProperty(value = "是否试销期")
    private String isTestMarket;

    @ApiModelProperty(value = "客户等级")
    private String customerLevel;

    @ApiModelProperty(value = "年月")
    private String distributionCustomerMonthSaleYearMonth;

    @ApiModelProperty(value = "产品编码")
    private String productCode;
    private List<String> includeProductCodeList;

    @ApiModelProperty(value = "产品名称")
    private String productName;

    @ApiModelProperty(value = "供货价（元）", notes = "")
    private BigDecimal supplyPrice;

    @ApiModelProperty(value = "月度总销量（箱）", notes = "")
    private Integer monthSaleQuantity;

    @ApiModelProperty(value = "月度总销售金额（元）", notes = "")
    private BigDecimal monthSaleAmount;

    @ApiModelProperty(value = "累计总销量（箱）", notes = "")
    private Integer totalSaleQuantity;

    @ApiModelProperty(value = "累计总销售金额（元）", notes = "")
    private BigDecimal totalSaleAmount;

    @ApiModelProperty(value = "捆赠销售数量（箱）", notes = "")
    private Integer boundGiftSaleQuantity;

    @ApiModelProperty(value = "捆赠销售金额（元）", notes = "")
    private BigDecimal boundGiftSaleAmount;

    @ApiModelProperty(value = "基础销售数量（箱）", notes = "")
    private Integer basicSaleQuantity;

    @ApiModelProperty(value = "基础销售金额（元）", notes = "")
    private BigDecimal basicSaleAmount;

    @ApiModelProperty(value = "待匹配数量（箱）", notes = "")
    private Integer waitMatchQuantity;

    @ApiModelProperty(value = "待匹配销售金额（元）", notes = "")
    private BigDecimal waitMatchAmount;

    @ApiModelProperty(value = "还原标志", notes = "")
    private String revertFlag;

    @ApiModelProperty(value = "促销政策编码", notes = "")
    private String promotionPolicyCode;

    /**
     * 销售机构编码
     */
    @ApiModelProperty("销售机构编码")
    private String salesInstitutionCode;

    /**
     * 销售机构名称
     */
    @ApiModelProperty("销售机构名称")
    private String salesInstitutionName;

    /**
     * 渠道编码
     */
    @ApiModelProperty("渠道编码")
    private String channelCode;

    /**
     * 渠道名称
     */
    @ApiModelProperty("渠道名称")
    private String channelName;

    /**
     * 业态
     */
    @ApiModelProperty("业态 数据字典：mdm_business_format")
    private String businessFormatCode;

    /**
     * 剔除销量
     */
    @ApiModelProperty("剔除销量")
    private BigDecimal ridSaleQuantity;

    /**
     * 剔除金额
     */
    @ApiModelProperty("剔除金额")
    private BigDecimal ridSaleAmount;

    /**
     * 手工已核销销量
     */
    @ApiModelProperty("手工已核销销量")
    private BigDecimal manualAuditSaleQuantity;

    /**
     * 手工已核销销售额
     */
    @ApiModelProperty("手工已核销销售额")
    private BigDecimal manualAuditSaleAmount;

    private String verifyCode;

    @ApiModelProperty("分销商年度剔量金额")
    private BigDecimal distributorAnnualAmount;

    @ApiModelProperty("分销商年度剔量数量")
    private BigDecimal distributorAnnualQuantity;

    @ApiModelProperty("上月待匹配数量")
    private BigDecimal lastMonthNoMatchingQuantity;

    @ApiModelProperty("上月销售组合数量")
    private BigDecimal lastMonthSaleCombinationQuantity;

    @ApiModelProperty("当月销售组合数量")
    private BigDecimal thisMonthSaleCombinationQuantity;

    @ApiModelProperty("上月基础销售数量")
    private BigDecimal lastMonthBaseSaleQuantity;
}
