package com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.dto.TpmDistributionCustomerMonthSaleDto;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.vo.TpmDistributionCustomerMonthSaleRespVo;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;

/**
 * @ClassName TpmDistributionCustomerMonthSaleService
 * @Description
 * @Author: jiangyin
 * @Date 2022/11/16
 */
public interface TpmDistributionCustomerMonthSaleService {

    /**
     * 根据条件查询分页数据
     *
     * @param pageable 分页参数
     * @param dto      查询条件
     * @return com.biz.crm.business.common.sdk.model.Result<com.baomidou.mybatisplus.extension.plugins.pagination.Page < com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.vo.DistributionCustomerMonthSaleRespVo>>
     * @author jiangyin
     * @date 2022/11/17 14:30
     */
    Page<TpmDistributionCustomerMonthSaleRespVo> findByConditions(Pageable pageable, TpmDistributionCustomerMonthSaleDto dto);

    /**
     * 还原分销客户月度销售数据
     *
     * @param dto
     * @return com.biz.crm.business.common.sdk.model.Result<?>
     * @author jiangyin
     * @date 2022/11/17 14:31
     */
    @Deprecated
    void saleDataReset(TpmDistributionCustomerMonthSaleDto dto);

    /**
     * 还原分销客户月度销售数据
     *
     * @param dto
     * @return com.biz.crm.business.common.sdk.model.Result<?>
     * @author jiangyin
     * @date 2022/11/17 14:31
     */
    void saleDataResetNew(TpmDistributionCustomerMonthSaleDto dto);

    /**
     * 批量保存
     *
     * @param distributionCustomerMonthSaleDtos
     */
    void batchSave(List<TpmDistributionCustomerMonthSaleDto> distributionCustomerMonthSaleDtos);

    /**
     * 批量修改
     *
     * @param distributionCustomerMonthSaleDtos
     */
    void batchUpdate(List<TpmDistributionCustomerMonthSaleDto> distributionCustomerMonthSaleDtos);

    /**
     * 根据条件查询
     *
     * @param distributionCustomerMonthSaleDto 查询参数
     * @return List
     */
    List<TpmDistributionCustomerMonthSaleRespVo> findDistribution(TpmDistributionCustomerMonthSaleDto distributionCustomerMonthSaleDto);

    /**
     * 获取累计销售总金额
     *
     * @param distributionCustomerMonthSale 查询参数
     * @return BigDecimal
     */
    BigDecimal getTotalSaleAmount(TpmDistributionCustomerMonthSaleDto distributionCustomerMonthSale);

    /**
     * 查询年度销售总金额
     *
     * @param dto 查询参数
     * @return BigDecimal
     */
    BigDecimal getYearTotalSaleAmount(TpmDistributionCustomerMonthSaleDto dto);

    List<TpmDistributionCustomerMonthSaleRespVo> findCustomerMonthSalesByParams(TpmDistributionCustomerMonthSaleDto distributionCustomerMonthSale);

    /**
     * 是否有重复数据
     *
     * @param distributionCustomerMonthSaleDtos
     */
    void beRepeat(List<TpmDistributionCustomerMonthSaleDto> distributionCustomerMonthSaleDtos);

    /**
     * 变量查询
     *
     * @param distributionCustomerMonthSale
     * @return
     */
    List<TpmDistributionCustomerMonthSaleRespVo> listForVariable(TpmDistributionCustomerMonthSaleDto distributionCustomerMonthSale, String yearMonthType);

    /**
     * 拆分客户查询
     *
     * @param distributionCustomerMonthSale
     * @return
     */
    List<TpmDistributionCustomerMonthSaleRespVo> listForSplitCustomer(TpmDistributionCustomerMonthSaleDto distributionCustomerMonthSale);

    List<TpmDistributionCustomerMonthSaleRespVo> findCustomerMonthSale(List<String> onlyDimensionList);

    void pullData(String msgBody);

    /**
     * 根据年月查客户信息
     *
     * @param distributionCustomerMonthSaleYearMonth
     * @return
     */
    List<TpmDistributionCustomerMonthSaleRespVo> findAllByYearMonth(String distributionCustomerMonthSaleYearMonth);

    /**
     * 根据客户信息查销售信息
     *
     * @param customerMonthSaleDtos
     * @return
     */
    List<TpmDistributionCustomerMonthSaleRespVo> findByCustomer(Collection<TpmDistributionCustomerMonthSaleDto> customerMonthSaleDtos);

    /**
     * 根据上月待匹配数据自动生成一条对应数据
     *
     * @param yearMonth
     * @return
     */
    Integer autoGenerateData(String yearMonth);
}
