package com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 分销客户月度销售导入vo
 *
 * @author: yaoyongming
 * @date: 2023/3/20 10:35
 */
@Data
@CrmExcelImport
@EqualsAndHashCode(callSuper = true)
public class TpmDistributionCustomerMonthSaleImportVo extends CrmExcelVo {

    @CrmExcelColumn("行id")
    private String id;

    /**
     * 渠道编码
     */
    @CrmExcelColumn("渠道编码")
    private String channelCode;

    /**
     * 渠道名称
     */
    @CrmExcelColumn("渠道名称")
    private String channelName;

    /**
     * 业态
     */
    @CrmExcelColumn("业态")
    private String businessFormatCode;

    /**
     * 销售机构编码
     */
    @CrmExcelColumn("销售机构编码")
    private String salesInstitutionCode;

    /**
     * 销售机构名称
     */
    @CrmExcelColumn("销售机构名称")
    private String salesInstitutionName;

    @CrmExcelColumn("客户编码")
    private String customerCode;

    @CrmExcelColumn("客户名称")
    private String customerName;

//    @CrmExcelColumn("是否试销期")
//    private String isTestMarket;
//
//    @CrmExcelColumn("客户等级")
//    private String customerLevel;

    @CrmExcelColumn("年月")
    private String distributionCustomerMonthSaleYearMonth;

    @CrmExcelColumn("产品编码")
    private String productCode;

    @CrmExcelColumn("产品名称")
    private String productName;

    @CrmExcelColumn("供货价（元）")
    private BigDecimal supplyPrice;
    /**
     * 分销商年度剔量数量
     */
    @CrmExcelColumn("分销商年度剔量数量")
    private BigDecimal distributorAnnualQuantity;
    /**
     * 分销商年度剔量金额
     */
    @CrmExcelColumn("分销商年度剔量金额(元)")
    private BigDecimal distributorAnnualAmount;


    /**
     * 剔除销量
     */
    @CrmExcelColumn("月度剃量数量")
    private BigDecimal ridSaleQuantity;

    /**
     * 剔除金额
     */
    @CrmExcelColumn("月度剃量金额")
    private BigDecimal ridSaleAmount;

    /**
     * 手工已核销销量
     */
    @CrmExcelColumn("手工已核销销量")
    private BigDecimal manualAuditSaleQuantity;

    /**
     * 手工已核销销售额
     */
    @CrmExcelColumn("手工已核销销售额")
    private BigDecimal manualAuditSaleAmount;

    @CrmExcelColumn("月度总销量（箱）")
    private Long monthSaleQuantity;

    @CrmExcelColumn("月度总销售金额（元）")
    private BigDecimal monthSaleAmount;

    @CrmExcelColumn("累计总销量（箱）")
    private Long totalSaleQuantity;

    @CrmExcelColumn("累计总销售金额（元）")
    private BigDecimal totalSaleAmount;

    @CrmExcelColumn("捆赠销售数量（箱）")
    private Long boundGiftSaleQuantity;

    @CrmExcelColumn("捆赠销售金额（元）")
    private BigDecimal boundGiftSaleAmount;

    @CrmExcelColumn("基础销售数量（箱）")
    private Long basicSaleQuantity;

    @CrmExcelColumn("基础销售金额（元）")
    private BigDecimal basicSaleAmount;

    @CrmExcelColumn("待匹配数量（箱）")
    private Long waitMatchQuantity;

    @CrmExcelColumn("待匹配销售金额（元）")
    private BigDecimal waitMatchAmount;
}
