/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.distribution.fees.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.tpm.business.distribution.fees.local.entity.DistributionFeesEntity;
import com.biz.crm.tpm.business.distribution.fees.local.repository.DistributionFeesRepository;
import com.biz.crm.tpm.business.distribution.fees.sdk.dto.DistributionFeesDto;
import com.biz.crm.tpm.business.distribution.fees.sdk.service.DistributionFeesService;
import com.biz.crm.tpm.business.distribution.fees.sdk.vo.DistributionFeesVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="distributionFeesService")
public class DistributionFeesServiceImpl
implements DistributionFeesService {
    @Autowired(required=false)
    private DistributionFeesRepository distributionFeesRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;

    public Page<DistributionFeesVo> findByDistributions(Pageable pageable, DistributionFeesDto distributionFeesDto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(distributionFeesDto)) {
            distributionFeesDto = new DistributionFeesDto();
        }
        return this.distributionFeesRepository.findByDistributions(pageable, distributionFeesDto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.distributionFeesRepository.removeByIds(ids);
    }

    @Transactional(rollbackFor={Exception.class})
    public void importSave(List<DistributionFeesDto> importList) {
        if (CollectionUtils.isEmpty(importList)) {
            return;
        }
        HashSet customerCodeSet = new HashSet();
        importList.forEach(dto -> {
            this.createValidate((DistributionFeesDto)dto);
            customerCodeSet.add(dto.getCustomerCode());
        });
        List customerVos = this.customerVoService.findByCustomerCodes(new ArrayList(customerCodeSet));
        if (CollectionUtils.isEmpty((Collection)customerVos)) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u4efb\u610f\u5ba2\u6237\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        Map customerVoMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
        importList.forEach(dto -> {
            if (!customerVoMap.containsKey(dto.getCustomerCode())) {
                throw new IllegalArgumentException("\u5ba2\u6237\u7f16\u7801\u3010" + dto.getCustomerCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            CustomerVo customerVo = (CustomerVo)customerVoMap.get(dto.getCustomerCode());
            dto.setCustomerName(customerVo.getCustomerName());
            DistributionFeesEntity similar = this.findSimilar((DistributionFeesDto)dto);
            if (similar != null) {
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"launch_platform", (Object)dto.getLaunchPlatform());
                wrapper.eq((Object)"shop", (Object)dto.getShop());
                wrapper.eq((Object)"launch_project", (Object)dto.getLaunchProject());
                wrapper.eq((Object)"years", (Object)dto.getYears());
                wrapper.eq((Object)"customer_code", (Object)dto.getCustomerCode());
                wrapper.eq((Object)"invoice", (Object)dto.getInvoice());
                this.distributionFeesRepository.remove((Wrapper)wrapper);
            }
            dto.setTenantCode(TenantUtils.getTenantCode());
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            dto.setId(UUID.randomUUID().toString().replaceAll("-", ""));
        });
        Collection distributionWagesEntities = this.nebulaToolkitService.copyCollectionByWhiteList(importList, DistributionFeesDto.class, DistributionFeesEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.distributionFeesRepository.saveBatch(new ArrayList(distributionWagesEntities));
    }

    private void createValidate(DistributionFeesDto distributionFeesDto) {
        Validate.notBlank((CharSequence)distributionFeesDto.getLaunchPlatform(), (String)"\u6295\u653e\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)distributionFeesDto.getShop(), (String)"\u5e97\u94fa\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)distributionFeesDto.getLaunchProject(), (String)"\u6295\u653e\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)distributionFeesDto.getReleaseAmount(), (String)"\u6295\u653e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)distributionFeesDto.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)distributionFeesDto.getInvoice(), (String)"\u53d1\u7968\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)distributionFeesDto.getYears(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private DistributionFeesEntity findSimilar(DistributionFeesDto distributionFeesDto) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"launch_platform", (Object)distributionFeesDto.getLaunchPlatform());
        wrapper.eq((Object)"shop", (Object)distributionFeesDto.getShop());
        wrapper.eq((Object)"launch_project", (Object)distributionFeesDto.getLaunchProject());
        wrapper.eq((Object)"years", (Object)distributionFeesDto.getYears());
        wrapper.eq((Object)"customer_name", (Object)distributionFeesDto.getCustomerName());
        wrapper.eq((Object)"customer_code", (Object)distributionFeesDto.getCustomerCode());
        wrapper.eq((Object)"invoice", (Object)distributionFeesDto.getInvoice());
        return (DistributionFeesEntity)((Object)this.distributionFeesRepository.getOne((Wrapper)wrapper));
    }
}

