package com.biz.crm.tpm.business.distribution.fees.sdk.dto;



import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author youjun
 * @date 2022年11月15日 10:30
 */
@Data
@ApiModel(value = "分销客户投放费用dto")
public class DistributionFeesDto extends TenantFlagOpDto {

    /**
     * 投放平台
     */
    @ApiModelProperty(name = "launchPlatform",value = "投放平台",notes = "投放平台")
    private String launchPlatform;

    /**
     * 店铺
     */
    @ApiModelProperty(name = "shop",value = "店铺", notes = "店铺")
    private String shop;

    /**
     * 投放项目
     */
    @ApiModelProperty(name = "launchProject",value = "投放项目", notes = "投放项目")
    private String launchProject;

    /**
     * 投放金额
     */
    @ApiModelProperty(name = "releaseAmount",value = "投放金额",notes = "投放金额")
    private BigDecimal releaseAmount;

    /**
     * 客户名称
     */
    @ApiModelProperty(name = "customerName",value = "客户名称", notes = "客户名称")
    private String customerName;
    /**
     * 客户编码
     */
    @ApiModelProperty(name = "customerCode",value = "客户编码", notes = "客户编码")
    private String customerCode;
    /**
     * 发票
     */
    @ApiModelProperty(name = "invoice",value = "发票", notes = "发票")
    private String invoice;

    /**
     * 年月
     */
    @ApiModelProperty(name = "years",value = "年月", notes = "年月")
    private String years;


}
