package com.biz.crm.tpm.business.distribution.fees.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.distribution.fees.sdk.dto.DistributionFeesDto;
import com.biz.crm.tpm.business.distribution.fees.sdk.vo.DistributionFeesVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 分销客户投放费用表(DistributionFeesEntity)表服务接口
 *
 * @author youjun
 * @date 2022年11月15日 11:49
 */
public interface DistributionFeesService {

    /**
     * 分页查询数据
     * @param pageable 分页对象
     * @param distributionFeesDto 实体对象
     * @return
     */
    Page<DistributionFeesVo> findByDistributions(Pageable pageable, DistributionFeesDto distributionFeesDto);

    /**
     * 删除数据
     * @param ids 主键结合
     * @return 删除结果
     */
    void delete(List<String> ids);

    /**
     * 批量导入新增
     *
     * @param importList
     *
     */
    void importSave(List<DistributionFeesDto> importList);
}
