package com.biz.crm.tpm.business.distribution.fees.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author: yaoyongming
 * @date: 2022/12/29 14:02
 */
@Data
@CrmExcelImport(startRow = 2)
public class DistributionFeesImportsVo extends CrmExcelVo {

    /**
     * 投放平台
     */
    @CrmExcelColumn(value = "*投放平台名称")
    private String launchPlatform;

    /**
     * 店铺
     */
    @CrmExcelColumn(value = "*店铺")
    private String shop;

    /**
     * 投放项目
     */
    @CrmExcelColumn(value = "*投放项目")
    private String launchProject;

    /**
     * 投放金额
     */
    @CrmExcelColumn(value = "*投放金额")
    private BigDecimal releaseAmount;

    /**
     * 客户编码
     */
    @CrmExcelColumn(value = "*客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @CrmExcelColumn(value = "客户名称")
    private String customerName;

    /**
     * 发票
     */
    @CrmExcelColumn(value = "*发票")
    private String invoice;

    /**
     * 年月
     */
    @CrmExcelColumn(value = "*年月")
    private String years;
}
