package com.biz.crm.tpm.business.distribution.wages.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.distribution.wages.sdk.dto.DistributionWagesDto;
import com.biz.crm.tpm.business.distribution.wages.sdk.service.DistributionWagesService;
import com.biz.crm.tpm.business.distribution.wages.sdk.vo.DistributionWagesVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author youjun
 * @date 2022年11月14日 13:53
 */
@RestController
@RequestMapping("/v1/distribution/wages")
@Slf4j
@Api(tags = "分销客户人员工资")
public class DistributionWagesController {

    /**
     * 服务对象
     */
    @Autowired(required = false)
    private DistributionWagesService distributionWagesService;

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param distributionWagesDto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByDistributions")
    public Result<Page<DistributionWagesVo>> findByDistributions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                             @ApiParam(name = "distributionWagesDto", value = "分销客户人员工资表") DistributionWagesDto distributionWagesDto) {
        try {
            Page<DistributionWagesVo> page =  this.distributionWagesService.findByDistributions(pageable,distributionWagesDto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
    /**
     * 删除数据
     *
     * @param ids 主键结合
     * @return 删除结果
     */
    @ApiOperation(value = "删除数据")
    @DeleteMapping("delete")
    public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids) {
        try {
            this.distributionWagesService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }





}
