package com.biz.crm.tpm.business.distribution.wages.local.dataview;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 *  分销客户人员工资表 DataView
 *  * @author xiaoyoujun
 *  * @since 2022-11-21
 */
@Component
public class DistributionWagesDateView implements DataviewRegister {

    @Override
    public String code() {
        return "tpm_distribution_wages";
    }

    @Override
    public String desc() {
        return "TPM-分销客户人员工资表";
    }

    @Override
    public String buildSql() {
        return "SELECT t.* FROM tpm_distribution_wages t" +
                "  WHERE t.del_flag = '" + EnableStatusEnum.ENABLE.getCode() + "' "+
                "  AND t.tenant_code = :tenantCode ";
    }
}
