package com.biz.crm.tpm.business.distribution.wages.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author youjun
 * @date 2022年11月14日 10:27
 */
@ApiModel(value = "DistributionWagesEntity", description = "TPM-分销客户人员工资表")
@TableName("tpm_distribution_wages")
@Getter
@Setter
@Entity(name = "tpm_distribution_wages")
@Table(name = "tpm_distribution_wages", indexes = {
        @Index(name = "tpm_distribution_wages_index1", columnList = "customer_code,years", unique = false),
        @Index(name = "tpm_distribution_wages_index2", columnList = "create_time,id", unique = false),
})
@org.hibernate.annotations.Table(appliesTo = "tpm_distribution_wages", comment = "TPM-分销客户人员工资表")
public class DistributionWagesEntity extends TenantFlagOpEntity {

    /**
     * 运营人员
     */
    @ApiModelProperty(name = "operators",value = "运营人员", notes = "运营人员")
    @Column(name = "operators", length = 64, columnDefinition = "VARCHAR(64) COMMENT '运营人员 '")
    private String operators;

    /**
     * 工资金额
     */
    @ApiModelProperty(name = "salaryAmount",value = "工资金额",notes = "工资金额")
    @Column(name = "salary_amount", columnDefinition = "decimal(24,6) COMMENT '工资金额'")
    private BigDecimal salaryAmount;

    /**
     * 身份证号
     */
    @ApiModelProperty(name = "idNumber",value = "身份证号", notes = "身份证号")
    @Column(name = "id_number", length = 32, columnDefinition = "VARCHAR(32) COMMENT '身份证号 '")
    private String idNumber;
    /**
     * 电话号码
     */
    @ApiModelProperty(name = "telephoneNumber",value = "电话号码", notes = "电话号码")
    @Column(name = "telephone_number", length = 32, columnDefinition = "VARCHAR(32) COMMENT '电话号码 '")
    private String telephoneNumber;
    /**
     * 客户名称
     */
    @ApiModelProperty(name = "customerName",value = "客户名称", notes = "客户名称")
    @Column(name = "customer_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户名称 '")
    private String customerName;
    /**
     * 客户编码
     */
    @ApiModelProperty(name = "customerCode",value = "客户编码", notes = "客户编码")
    @Column(name = "customer_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码 '")
    private String customerCode;
    /**
     * 年月
     */
    @ApiModelProperty(name = "years",value = "年月", notes = "年月")
    @Column(name = "years", length = 32, columnDefinition = "VARCHAR(32) COMMENT '年月 '")
    private String years;

    /**
     * 销售机构编码
     */
    @ApiModelProperty("销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构编码'")
    private String salesInstitutionCode;

    /**
     * 销售机构名称
     */
    @ApiModelProperty("销售机构名称")
    @Column(name = "sales_institution_name", columnDefinition = "VARCHAR(255) COMMENT '销售机构名称'")
    private String salesInstitutionName;

    /**
     * 渠道编码
     */
    @ApiModelProperty("渠道编码")
    @Column(name = "channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '渠道编码'")
    private String channelCode;

    /**
     * 渠道名称
     */
    @ApiModelProperty("渠道名称")
    @Column(name = "channel_name", columnDefinition = "varchar(255) COMMENT '渠道名称'")
    private String channelName;

    /**
     * 业态
     */
    @ApiModelProperty("业态 数据字典：mdm_business_format")
    @Column(name = "business_format_code", length = 32, columnDefinition = "varchar(32) COMMENT '业态'")
    private String businessFormatCode;

}
