package com.biz.crm.tpm.business.distribution.wages.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.distribution.wages.local.entity.DistributionWagesEntity;
import com.biz.crm.tpm.business.distribution.wages.sdk.dto.DistributionWagesDto;
import com.biz.crm.tpm.business.distribution.wages.sdk.vo.DistributionWagesVo;
import org.apache.ibatis.annotations.Param;


/**
 * 分销客户人员工资表(DistributionWagesEntity)表mybatis访问层
 *
 * @author youjun
 * @date 2022年11月14日 14：09
 */
public interface DistributionWagesMapper extends BaseMapper<DistributionWagesEntity> {

    /**
     * 分页查询所有数据
     *
     * @param page 分页对象
     * @param distributionWagesDto 查询实体
     * @return 所有数据
     */
    public Page<DistributionWagesVo> findByDistributions(@Param("page") Page<DistributionWagesVo> page, @Param("dto") DistributionWagesDto distributionWagesDto);
}
