package com.biz.crm.tpm.business.distribution.wages.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.distribution.wages.local.entity.DistributionWagesEntity;
import com.biz.crm.tpm.business.distribution.wages.local.mapper.DistributionWagesMapper;
import com.biz.crm.tpm.business.distribution.wages.sdk.dto.DistributionWagesDto;
import com.biz.crm.tpm.business.distribution.wages.sdk.vo.DistributionWagesVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class DistributionWagesRepository extends ServiceImpl<DistributionWagesMapper, DistributionWagesEntity> {

    @Resource
    private DistributionWagesMapper distributionWagesMapper;

    /**
     * 分页查询数据
     * @param pageable 分页对象
     * @param distributionWagesDto 实体对象
     * @return
     */
    public Page<DistributionWagesVo> findByDistributions(Pageable pageable, DistributionWagesDto distributionWagesDto) {
        Page<DistributionWagesVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<DistributionWagesVo> pageList = this.distributionWagesMapper.findByDistributions(page, distributionWagesDto);
        return pageList;
    }
}
