package com.biz.crm.tpm.business.distribution.wages.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.tpm.business.distribution.wages.local.entity.DistributionWagesEntity;
import com.biz.crm.tpm.business.distribution.wages.local.repository.DistributionWagesRepository;
import com.biz.crm.tpm.business.distribution.wages.sdk.dto.DistributionWagesDto;
import com.biz.crm.tpm.business.distribution.wages.sdk.service.DistributionWagesService;
import com.biz.crm.tpm.business.distribution.wages.sdk.vo.DistributionWagesVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 分销客户人员工资表(DistributionWagesEntity)表服务实现类
 *
 * @author youjun
 * @date 2022年11月14日 14:16
 */
@Service("distributionWagesService")
public class DistributionWagesServiceImpl implements DistributionWagesService {

    @Autowired(required = false)
    private DistributionWagesRepository distributionWagesRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private CustomerVoService customerVoService;

    @Autowired(required = false)
    private CustomerChannelVoService customerChannelVoService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    private static final String MDM_BUSINESS_FORMAT = "mdm_business_format";
    /**
     * 分页查询数据
     * @param pageable 分页对象
     * @param distributionWagesDto 实体对象
     * @return
     */
    @Override
    public Page<DistributionWagesVo> findByDistributions(Pageable pageable, DistributionWagesDto distributionWagesDto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(distributionWagesDto)) {
            distributionWagesDto = new DistributionWagesDto();
        }
        return this.distributionWagesRepository.findByDistributions(pageable,distributionWagesDto);
    }

    /**
     * 删除数据
     * @param ids 主键结合
     * @return 删除结果
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void delete(List<String> ids) {
        Validate.isTrue(!CollectionUtils.isEmpty(ids), "删除数据时，主键集合不能为空！");
        this.distributionWagesRepository.removeByIds(ids);
    }

    /**
     * 批量导入新增
     * @param importList
     * @return 批量导入新增
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void importSave(List<DistributionWagesDto> importList) {
        importList.forEach(dto -> {
            dto.setTenantCode(TenantUtils.getTenantCode());
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            dto.setId(UUID.randomUUID().toString().replaceAll("-", ""));
        });
        // 保存分销客户人员工资
        Collection<DistributionWagesEntity> distributionWagesEntities = this.nebulaToolkitService.copyCollectionByWhiteList(importList, DistributionWagesDto.class, DistributionWagesEntity.class, LinkedHashSet.class, ArrayList.class);
        this.distributionWagesRepository.saveBatch(new ArrayList<>(distributionWagesEntities));

    }

    @Override
    public List<DistributionWagesVo> findForVariable(DistributionWagesDto dto) {
        if (Objects.isNull(dto)
                || StringUtils.isEmpty(dto.getCustomerCode())
                || StringUtils.isEmpty(dto.getYears())) {
            return Collections.emptyList();
        }
        List<DistributionWagesEntity> entities = this.distributionWagesRepository.lambdaQuery()
                .eq(DistributionWagesEntity::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .eq(DistributionWagesEntity::getTenantCode,TenantUtils.getTenantCode())
                .eq(DistributionWagesEntity::getCustomerCode,dto.getCustomerCode())
                .eq(DistributionWagesEntity::getYears,dto.getYears())
                .list();

        return (List<DistributionWagesVo>)this.nebulaToolkitService.copyCollectionByWhiteList(entities, DistributionWagesEntity.class, DistributionWagesVo.class, HashSet.class, ArrayList.class);
    }

    /**
     * 重复导入验证
     * @param distributionWagesDto
     */
    private DistributionWagesEntity findSimilar(DistributionWagesDto distributionWagesDto) {
        QueryWrapper<DistributionWagesEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("id_number",distributionWagesDto.getIdNumber());
        wrapper.eq("customer_code",distributionWagesDto.getCustomerCode());
        wrapper.eq("years",distributionWagesDto.getYears());
        return distributionWagesRepository.getOne(wrapper);
    }

}
