/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.distribution.wages.local.process;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.tpm.business.distribution.wages.sdk.dto.DistributionWagesDto;
import com.biz.crm.tpm.business.distribution.wages.sdk.service.DistributionWagesService;
import com.biz.crm.tpm.business.distribution.wages.sdk.vo.DistributionWagesImportsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DistributionWagesImportsProcess
implements ImportProcess<DistributionWagesImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(DistributionWagesImportsProcess.class);
    @Resource
    private DistributionWagesService distributionWagesService;
    @Resource
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private CustomerChannelVoService customerChannelVoService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    private static final String MDM_BUSINESS_FORMAT = "mdm_business_format";
    private static final String REGEX = "\\d{4}-\\d{2}";

    public Integer getBatchCount() {
        return 10000;
    }

    public boolean importBeforeValidationFlag() {
        return Boolean.TRUE;
    }

    public Map<Integer, String> tryVerify(LinkedHashMap<Integer, DistributionWagesImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        for (Map.Entry<Integer, DistributionWagesImportsVo> row : data.entrySet()) {
            int rowNum = row.getKey();
            DistributionWagesImportsVo vo = row.getValue();
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getOperators()), "\u8fd0\u8425\u4eba\u5458\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(this.validateSalaryAmount(vo.getSalaryAmount()), "\u5de5\u8d44\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6216\u8005\u4e0d\u80fd\u4e3a\u8d1f\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getCustomerCode()), "\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getChannelCode()), "\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getSalesInstitutionCode()), "\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getYears()), "\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(this.yearBooleanMethod(vo.getYears()), "\u5e74\u6708\u683c\u5f0f\u6709\u8bef,\u4f8b 2023-10");
            String errInfo = this.validateGetErrorInfo();
            if (errInfo == null) continue;
            errMap.put(rowNum, errInfo);
        }
        return errMap;
    }

    private Boolean validateSalaryAmount(BigDecimal salaryAmount) {
        if (salaryAmount == null || salaryAmount.compareTo(BigDecimal.ZERO) < 0) {
            return false;
        }
        return true;
    }

    private Boolean yearBooleanMethod(String years) {
        if (years.length() != 7 || !years.matches(REGEX)) {
            return false;
        }
        return true;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, DistributionWagesImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        List orgVos;
        List customerVos;
        Validate.notEmpty(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        Map<Object, Object> customerVoMap = new HashMap();
        Map<Object, Object> orgVoMap = new HashMap();
        Map<Object, Object> channelVoMap = new HashMap();
        HashSet customerCodeSet = new HashSet();
        HashSet channelCodeSet = new HashSet();
        HashSet orgCodeSet = new HashSet();
        data.values().forEach(dto -> {
            customerCodeSet.add(dto.getCustomerCode());
            channelCodeSet.add(dto.getChannelCode());
            orgCodeSet.add(dto.getSalesInstitutionCode());
        });
        Map dictDataMap = this.dictDataVoService.findByDictTypeCodeList(Arrays.asList(MDM_BUSINESS_FORMAT));
        List channelList = this.customerChannelVoService.findByCodes(new ArrayList(channelCodeSet));
        if (!CollectionUtils.isEmpty((Collection)channelList)) {
            channelVoMap = channelList.stream().collect(Collectors.toMap(e -> e.getCustomerChannelCode(), Function.identity()));
        }
        if (!CollectionUtils.isEmpty((Collection)(customerVos = this.customerVoService.findByCustomerMdgCodes(new ArrayList(customerCodeSet))))) {
            customerVoMap = customerVos.stream().collect(Collectors.groupingBy(e -> e.getErpCode()));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(orgVos = this.salesOrgVoService.findByErpCodeList(new ArrayList(orgCodeSet))))) {
            orgVoMap = orgVos.stream().collect(Collectors.groupingBy(e -> e.getErpCode()));
        }
        Map<Object, Object> finalChannelVoMap = channelVoMap;
        HashMap finalOrgVoMap = orgVoMap;
        Map<Object, Object> finalCustomerVoMap = customerVoMap;
        data.forEach((k, dto) -> {
            List list;
            DictDataVo promotionType = ((List)dictDataMap.get(MDM_BUSINESS_FORMAT)).stream().filter(e -> e.getDictValue().equals(dto.getBusinessFormatCode())).findFirst().orElse(null);
            if (promotionType != null) {
                dto.setBusinessFormatCode(promotionType.getDictCode());
            } else {
                this.validateIsTrue(false, "\u4e1a\u6001\u3010" + dto.getBusinessFormatCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            if (finalChannelVoMap.containsKey(dto.getChannelCode())) {
                dto.setChannelName(((CustomerChannelVo)finalChannelVoMap.get(dto.getChannelCode())).getCustomerChannelName());
            } else {
                this.validateIsTrue(false, "\u6e20\u9053\u7f16\u7801\u3010" + dto.getChannelCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            SalesOrgVo salesOrgVo = null;
            if (finalOrgVoMap.containsKey(dto.getSalesInstitutionCode())) {
                list = (List)finalOrgVoMap.get(dto.getSalesInstitutionCode());
                salesOrgVo = list.stream().filter(e -> dto.getChannelCode().equals(e.getChannelCode()) && dto.getBusinessFormatCode().equals(e.getBusinessFormatCode())).findFirst().orElse(null);
                if (salesOrgVo == null) {
                    this.validateIsTrue(false, "\u9500\u552e\u673a\u6784\u7f16\u7801\u3010" + dto.getSalesInstitutionCode() + "\u3011\u672a\u627e\u5230\u5bf9\u5e94\u9500\u552e\u673a\u6784\uff0c\u8bf7\u68c0\u67e5\uff01");
                } else {
                    dto.setSalesInstitutionName(salesOrgVo.getSalesOrgName());
                }
            } else {
                this.validateIsTrue(false, "\u9500\u552e\u673a\u6784\u7f16\u7801\u3010" + dto.getSalesInstitutionCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            if (finalCustomerVoMap.containsKey(dto.getCustomerCode())) {
                list = (List)finalCustomerVoMap.get(dto.getCustomerCode());
                SalesOrgVo finalSalesOrgVo = salesOrgVo;
                CustomerVo customerVo = list.stream().filter(e -> dto.getChannelCode().equals(e.getCustomerChannelCode()) && finalSalesOrgVo.getSalesInstitutionCode().equals(e.getSalesInstitutionCode()) && dto.getBusinessFormatCode().equals(e.getBusinessFormatCode())).findFirst().orElse(null);
                if (customerVo == null) {
                    this.validateIsTrue(false, "\u5ba2\u6237\u7f16\u7801\u3010" + dto.getCustomerCode() + "\u3011\u672a\u627e\u5230\u5bf9\u5e94\u5ba2\u6237\uff0c\u8bf7\u68c0\u67e5\uff01");
                } else {
                    dto.setCustomerName(customerVo.getCustomerName());
                }
            } else {
                this.validateIsTrue(false, "\u5ba2\u6237\u7f16\u7801\u3010" + dto.getCustomerCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            String errInfo = this.validateGetErrorInfo();
            if (errInfo != null) {
                errMap.put((Integer)k, errInfo);
            }
        });
        if (errMap.isEmpty()) {
            ArrayList<DistributionWagesImportsVo> importList = new ArrayList<DistributionWagesImportsVo>(data.values());
            Collection dtoList = this.nebulaToolkitService.copyCollectionByWhiteList(importList, DistributionWagesImportsVo.class, DistributionWagesDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.distributionWagesService.importSave(new ArrayList(dtoList));
        }
        return errMap;
    }

    public Class<DistributionWagesImportsVo> findCrmExcelVoClass() {
        return DistributionWagesImportsVo.class;
    }

    public String getTemplateCode() {
        return "TPM_DISTRIBUTION_WAGES_IMPORT";
    }

    public String getTemplateName() {
        return "TPM\u5206\u9500\u5ba2\u6237\u4eba\u5458\u5de5\u8d44\u8868\u5bfc\u5165";
    }
}

