/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.distribution.wages.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.tpm.business.distribution.wages.local.entity.DistributionWagesEntity;
import com.biz.crm.tpm.business.distribution.wages.local.repository.DistributionWagesRepository;
import com.biz.crm.tpm.business.distribution.wages.sdk.dto.DistributionWagesDto;
import com.biz.crm.tpm.business.distribution.wages.sdk.service.DistributionWagesService;
import com.biz.crm.tpm.business.distribution.wages.sdk.vo.DistributionWagesVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="distributionWagesService")
public class DistributionWagesServiceImpl
implements DistributionWagesService {
    @Autowired(required=false)
    private DistributionWagesRepository distributionWagesRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private CustomerChannelVoService customerChannelVoService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    private static final String MDM_BUSINESS_FORMAT = "mdm_business_format";

    public Page<DistributionWagesVo> findByDistributions(Pageable pageable, DistributionWagesDto distributionWagesDto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(distributionWagesDto)) {
            distributionWagesDto = new DistributionWagesDto();
        }
        return this.distributionWagesRepository.findByDistributions(pageable, distributionWagesDto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.distributionWagesRepository.removeByIds(ids);
    }

    @Transactional(rollbackFor={Exception.class})
    public void importSave(List<DistributionWagesDto> importList) {
        importList.forEach(dto -> {
            dto.setTenantCode(TenantUtils.getTenantCode());
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            dto.setId(UUID.randomUUID().toString().replaceAll("-", ""));
        });
        Collection distributionWagesEntities = this.nebulaToolkitService.copyCollectionByWhiteList(importList, DistributionWagesDto.class, DistributionWagesEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.distributionWagesRepository.saveBatch(new ArrayList(distributionWagesEntities));
    }

    public List<DistributionWagesVo> findForVariable(DistributionWagesDto dto) {
        if (Objects.isNull(dto) || StringUtils.isEmpty((CharSequence)dto.getCustomerCode()) || StringUtils.isEmpty((CharSequence)dto.getYears())) {
            return Collections.emptyList();
        }
        List entities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.distributionWagesRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(DistributionWagesEntity::getCustomerCode, (Object)dto.getCustomerCode())).eq(DistributionWagesEntity::getYears, (Object)dto.getYears())).list();
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, DistributionWagesEntity.class, DistributionWagesVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private DistributionWagesEntity findSimilar(DistributionWagesDto distributionWagesDto) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"id_number", (Object)distributionWagesDto.getIdNumber());
        wrapper.eq((Object)"customer_code", (Object)distributionWagesDto.getCustomerCode());
        wrapper.eq((Object)"years", (Object)distributionWagesDto.getYears());
        return (DistributionWagesEntity)((Object)this.distributionWagesRepository.getOne((Wrapper)wrapper));
    }
}

