package com.biz.crm.tpm.business.duty.profit.adjust.local.controller;


import com.biz.crm.tpm.business.duty.profit.adjust.local.entity.DutyProfitAdjust;
import com.biz.crm.tpm.business.duty.profit.adjust.sdk.dto.DutyProfitAdjustDetailHandleDto;
import com.biz.crm.tpm.business.duty.profit.adjust.sdk.dto.DutyProfitAdjustFilesDto;
import com.biz.crm.tpm.business.duty.profit.adjust.sdk.service.DutyProfitAdjustService;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.duty.profit.adjust.sdk.dto.DutyProfitAdjustDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.Date;
import java.util.List;

/**
 * 责任利润调整表(DutyProfitAdjust)表相关的http接口
 *
 * @author yaoyongming
 * @since 2022-11-10 13:55:12
 */
@RestController
@RequestMapping("/v1/dutyProfitAdjust")
@Slf4j
@Api(tags = "责任利润调整表")
public class DutyProfitAdjustController {
    /**
     * 服务对象
     */
    @Autowired(required = false)
    private DutyProfitAdjustService dutyProfitAdjustService;

    /**
     * 分页查询所有数据
     *
     * @param pageable         分页对象
     * @param dutyProfitAdjust 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<DutyProfitAdjustDto>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                              @ApiParam(name = "dutyProfitAdjust", value = "责任利润调整表") DutyProfitAdjustDto dutyProfitAdjust) {
        try {
            Page<DutyProfitAdjustDto> page = this.dutyProfitAdjustService.findByConditions(pageable, dutyProfitAdjust);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键查询单条数据")
    @GetMapping("findById")
    public Result<DutyProfitAdjustDto> findById(@RequestParam("id") @ApiParam(name = "id", value = "主键id", required = true) String id) {
        try {
            DutyProfitAdjustDto dutyProfitAdjust = this.dutyProfitAdjustService.findById(id);
            return Result.ok(dutyProfitAdjust);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 调整预算查询
     *
     * @param dutyProfitAdjustDetailCode 编码
     * @return 单条数据
     */
    @ApiOperation(value = "调整预算查询")
    @GetMapping("findHandleByCode")
    public Result<List<DutyProfitAdjustDetailHandleDto>> findHandleByCode(@RequestParam("dutyProfitAdjustDetailCode") @ApiParam(name = "dutyProfitAdjustDetailCode", value = "明细编码", required = true) String dutyProfitAdjustDetailCode) {
        try {
            List<DutyProfitAdjustDetailHandleDto> list = this.dutyProfitAdjustService.findHandleByCode(dutyProfitAdjustDetailCode);
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 调整预算查询
     *
     * @param dutyProfitAdjustDetailCode 编码
     * @return 单条数据
     */
    @ApiOperation(value = "调整预算日志查询")
    @GetMapping("findHandleLogByCode")
    public Result<List<DutyProfitAdjustDetailHandleDto>> findHandleLogByCode(@RequestParam("dutyProfitAdjustDetailCode") @ApiParam(name = "dutyProfitAdjustDetailCode", value = "明细编码", required = true) String dutyProfitAdjustDetailCode) {
        try {
            List<DutyProfitAdjustDetailHandleDto> list = this.dutyProfitAdjustService.findHandleLogByCode(dutyProfitAdjustDetailCode);
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增数据
     *
     * @param dutyProfitAdjust 实体对象
     * @return 新增结果
     */
    @ApiOperation(value = "新增数据")
    @PostMapping
    public Result<?> create(@ApiParam(name = "dutyProfitAdjust", value = "责任利润调整表") @RequestBody DutyProfitAdjustDto dutyProfitAdjust) {
        try {
            this.dutyProfitAdjustService.create(dutyProfitAdjust);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 修改数据
     *
     * @param dutyProfitAdjust 实体对象
     * @return 修改结果
     */
    @ApiOperation(value = "修改数据")
    @PatchMapping
    public Result<?> update(@ApiParam(name = "dutyProfitAdjust", value = "责任利润调整表") @RequestBody DutyProfitAdjustDto dutyProfitAdjust) {
        try {
            this.dutyProfitAdjustService.update(dutyProfitAdjust);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 预算调整确认
     *
     * @param handleDtoList 实体对象
     * @return
     */
    @ApiOperation(value = "预算调整确认")
    @PostMapping("adjust")
    public Result<?> adjust(@ApiParam(name = "handleDtoList", value = "明细调整信息") @RequestBody List<DutyProfitAdjustDetailHandleDto> handleDtoList,
                            @ApiParam(name = "dutyProfitAdjustDetailCode", value = "明细编码") @RequestParam("dutyProfitAdjustDetailCode") String dutyProfitAdjustDetailCode,
                            @ApiParam(name = "profitAdjustType", value = "调整金额类型") @RequestParam("profitAdjustType") String profitAdjustType) {
        try {
            this.dutyProfitAdjustService.adjust(handleDtoList, dutyProfitAdjustDetailCode, profitAdjustType);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除数据
     *
     * @param ids 主键结合
     * @return 删除结果
     */
    @ApiOperation(value = "删除数据")
    @DeleteMapping
    public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids) {
        try {
            this.dutyProfitAdjustService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 附件查询
     *
     * @param dutyProfitAdjustDetailCode 编码
     * @return
     */
    @ApiOperation(value = "附件查询")
    @GetMapping("findFilesByCode")
    public Result<List<DutyProfitAdjustFilesDto>> findFilesByCode(@RequestParam("dutyProfitAdjustDetailCode") @ApiParam(name = "dutyProfitAdjustDetailCode", value = "明细编码", required = true) String dutyProfitAdjustDetailCode) {
        try {
            List<DutyProfitAdjustFilesDto> list = this.dutyProfitAdjustService.findFilesByCode(dutyProfitAdjustDetailCode);
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 简道云拉取数据手动触发
     *
     * @param startDate
     * @param endDate
     * @return
     */
    @ApiOperation(value = "简道云拉取数据手动触发")
    @GetMapping("pullDutyProfitAdjustManual")
    public Result<?> pullDutyProfitAdjustManual(@RequestParam("startDate") @ApiParam(name = "startDate", value = "开始时间", required = true) String startDate,
                                                                             @RequestParam("endDate") @ApiParam(name = "endDate", value = "结束时间", required = true) String endDate) {
        try {
            this.dutyProfitAdjustService.pullDutyProfitAdjustManual(startDate, endDate);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
