package com.biz.crm.tpm.business.duty.profit.adjust.local.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 责任利润调整表
 *
 * @author: yaoyongming
 * @date: 2022/11/9 16:40
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DutyProfitAdjust", description = "责任利润调整表")
@Entity
@org.hibernate.annotations.Table(appliesTo = "`tpm_duty_profit_adjust`", comment = "责任利润调整表")
@TableName("tpm_duty_profit_adjust")
@Table(
        name = "`tpm_duty_profit_adjust`",
        indexes = @Index(name = "uk_tpm_duty_profit_adjust", columnList = "duty_profit_adjust_code", unique = true))
public class DutyProfitAdjust extends TenantFlagOpEntity {

    /**
     *简道云接口id
     */
    @ApiModelProperty("简道云接口id")
    @Column(name = "data_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '简道云接口id'")
    private String dataId;

    /**
     * 责任利润调整编码
     */
    @ApiModelProperty("责任利润调整编码")
    @Column(name = "duty_profit_adjust_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '责任利润调整编码'")
    private String dutyProfitAdjustCode;

    /**
     * 责任利润调整名称
     */
    @ApiModelProperty("责任利润调整名称")
    @Column(name = "duty_profit_adjust_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '责任利润调整名称'")
    private String dutyProfitAdjustName;

    /**
     * 日期
     */
    @ApiModelProperty("日期")
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "adjust_date" , length = 10, columnDefinition = "datetime COMMENT '日期'")
    private Date adjustDate;

    /**
     * 核减方式
     */
    @ApiModelProperty("核减方式")
    @Column(name = "audit_cost_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '核减方式'")
    private String auditCostCode;

    /**
     * 调出金额
     */
    @ApiModelProperty(value = "调出金额")
    @Column(name = "adjust_out_amount", columnDefinition = "decimal(20,6) COMMENT '调出金额'")
    private BigDecimal adjustOutAmount;

    /**
     * 调入金额
     */
    @ApiModelProperty(value = "调入金额")
    @Column(name = "adjust_in_amount", columnDefinition = "decimal(20,6) COMMENT '调入金额'")
    private BigDecimal adjustInAmount;

    /**
     * 调整原因
     */
    @ApiModelProperty("调整原因")
    @Column(name = "reason", columnDefinition = "text COMMENT '调整原因'")
    private String reason;

    /**
     * 调整状态
     */
    @ApiModelProperty("调整状态")
    @Column(name = "audit_status", length = 32, columnDefinition = "VARCHAR(32) COMMENT '调整状态'")
    private String auditStatus;
}
