package com.biz.crm.tpm.business.duty.profit.adjust.local.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 责任利润调整明细
 *
 * @author: yaoyongming
 * @date: 2022/11/9 17:23
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DutyProfitAdjustDetail", description = "责任利润调整明细表")
@Entity
@org.hibernate.annotations.Table(appliesTo = "`tpm_duty_profit_adjust_detail`", comment = "责任利润调整明细表")
@TableName("tpm_duty_profit_adjust_detail")
@Table(
        name = "`tpm_duty_profit_adjust_detail`",
        indexes = {
                @Index(name = "duty_profit_adjust_detail_index1", columnList = "duty_profit_adjust_detail_code", unique = true),
                @Index(name = "duty_profit_adjust_detail_index2", columnList = "duty_profit_adjust_code")
        })
public class DutyProfitAdjustDetail extends TenantFlagOpEntity {

    /**
     * 简道云接口id
     */
    @ApiModelProperty("简道云接口id")
    @Column(name = "data_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '简道云接口id'")
    private String dataId;

    /**
     * 简道云接口明细id
     */
    @ApiModelProperty("简道云接口id")
    @Column(name = "data_detail_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '简道云接口明细id'")
    private String dataDetailId;

    /**
     * 成员单选
     */
    @ApiModelProperty("成员单选")
    @Column(name = "user", length = 32, columnDefinition = "VARCHAR(32) COMMENT '成员单选'")
    private String user;

    /**
     * 责任利润调整编码
     */
    @ApiModelProperty("责任利润调整编码")
    @Column(name = "duty_profit_adjust_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '责任利润调整编码'")
    private String dutyProfitAdjustCode;

    /**
     * 责任利润调整名称
     */
    @ApiModelProperty("责任利润调整名称")
    @Column(name = "duty_profit_adjust_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '责任利润调整名称'")
    private String dutyProfitAdjustName;

    /**
     * 责任利润调整明细编码
     */
    @ApiModelProperty("责任利润调整明细编码")
    @Column(name = "duty_profit_adjust_detail_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '责任利润调整明细编码'")
    private String dutyProfitAdjustDetailCode;

    /**
     * 日期
     */
    @ApiModelProperty("日期")
    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NOT_EMPTY)
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "adjust_date", length = 10, columnDefinition = "datetime COMMENT '日期'")
    private Date adjustDate;

    /**
     * 核减方式
     */
    @ApiModelProperty("核减方式")
    @Column(name = "audit_cost_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '核减方式'")
    private String auditCostCode;

    /**
     * 调整原因
     */
    @ApiModelProperty("调整原因")
    @Column(name = "reason", columnDefinition = "text COMMENT '调整原因'")
    private String reason;

    /**
     * 调整状态
     */
    @ApiModelProperty("调整状态")
    @Column(name = "audit_status", length = 32, columnDefinition = "VARCHAR(32) COMMENT '调整状态'")
    private String auditStatus;

    /**
     * 调整方向
     */
    @ApiModelProperty(value = "调整方向")
    @Column(name = "adjust_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '调整方向'")
    private String adjustType;

    /**
     * 调整级别编码
     */
    @ApiModelProperty("调整级别编码")
    @Column(name = "adjust_level_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '调整级别编码'")
    private String adjustLevelCode;

    /**
     * 事业部
     */
    @ApiModelProperty("事业部")
    @Column(name = "division", columnDefinition = "VARCHAR(255) COMMENT '事业部'")
    private String division;

    /**
     * 业务单元
     */
    @ApiModelProperty("业务单元")
    @Column(name = "business_unit", columnDefinition = "VARCHAR(255) COMMENT '业务单元'")
    private String businessUnit;

    /**
     * 业务单元常温
     */
    @ApiModelProperty("业务单元常温")
    @Column(name = "business_unit_normal", columnDefinition = "VARCHAR(255) COMMENT '业务单元常温'")
    private String businessUnitNormal;

    /**
     * 业务单元
     */
    @ApiModelProperty("业务单元")
    @Column(name = "business_unit_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元'")
    private String businessUnitCode;

    /**
     * 中心
     */
    @ApiModelProperty("中心")
    @Column(name = "center", columnDefinition = "VARCHAR(255) COMMENT '中心'")
    private String center;

    /**
     * 工厂
     */
    @ApiModelProperty("工厂")
    @Column(name = "factory", columnDefinition = "VARCHAR(255) COMMENT '工厂'")
    private String factory;

    /**
     * 品牌
     */
    @ApiModelProperty(name = "品牌")
    @Column(name = "brand", columnDefinition = "VARCHAR(255) COMMENT '品牌'")
    private String brand;

    /**
     * 部门
     */
    @ApiModelProperty("部门")
    @Column(name = "department", columnDefinition = "VARCHAR(255) COMMENT '部门'")
    private String department;

    /**
     * 二级科目
     */
    @ApiModelProperty(name = "二级科目")
    @Column(name = "budget_item2", columnDefinition = "VARCHAR(255) COMMENT '二级科目'")
    private String budgetItem2;

    /**
     * 一级科目
     */
    @ApiModelProperty(name = "一级科目")
    @Column(name = "budget_item1", columnDefinition = "VARCHAR(255) COMMENT '一级科目'")
    private String budgetItem1;

    /**
     * 属性
     */
    @ApiModelProperty(name = "属性")
    @Column(name = "attribute", columnDefinition = "VARCHAR(255) COMMENT '属性'")
    private String attribute;

    /**
     * 调入/调出金额
     */
    @ApiModelProperty(value = "调入/调出金额")
    @Column(name = "amount", columnDefinition = "decimal(20,6) COMMENT '调入/调出金额'")
    private BigDecimal amount;

    /**
     * 已调整预算金额
     */
    @ApiModelProperty(value = "已调整预算金额")
    @Column(name = "adjust_amount", columnDefinition = "decimal(20,6) COMMENT '已调整预算金额'")
    private BigDecimal adjustAmount;

    /**
     * 所得税
     */
    @ApiModelProperty("所得税")
    @Column(name = "income_tax", columnDefinition = "DECIMAL(20,6) COMMENT '所得税'")
    private BigDecimal incomeTax;

    /**
     * 所得税额
     */
    @ApiModelProperty("所得税额")
    @Column(name = "income_tax_value", columnDefinition = "DECIMAL(20,6) COMMENT '所得税额'")
    private BigDecimal incomeTaxValue;

    /**
     * 净额
     */
    @ApiModelProperty("净额")
    @Column(name = "net_value", columnDefinition = "DECIMAL(20,6) COMMENT '净额'")
    private BigDecimal netValue;

    /**
     * 调整金额类型
     */
    @ApiModelProperty(name = "调整金额类型")
    @Column(name = "profit_adjust_type", columnDefinition = "VARCHAR(32) COMMENT '调整金额类型'")
    private String profitAdjustType;

}
