package com.biz.crm.tpm.business.duty.profit.adjust.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 明细调整信息
 *
 * @author: yaoyongming
 * @date: 2022/11/16 13:39
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DutyProfitAdjustDetailHandle", description = "责任利润调整明细信息扩展表")
@Entity
@org.hibernate.annotations.Table(appliesTo = "`tpm_duty_profit_adjust_detail_handle`", comment = "责任利润调整明细信息扩展表")
@TableName("tpm_duty_profit_adjust_detail_handle")
@Table(
        name = "`tpm_duty_profit_adjust_detail_handle`",
        indexes = {
                @Index(name = "duty_profit_adjust_detail_handle_index1", columnList = "duty_profit_adjust_detail_code")
        })
public class DutyProfitAdjustDetailHandle extends TenantFlagOpEntity {

    /**
     * 责任利润调整明细编码
     */
    @ApiModelProperty("责任利润调整明细编码")
    @Column(name = "duty_profit_adjust_detail_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '责任利润调整明细编码'")
    private String dutyProfitAdjustDetailCode;

    /**
     * 预算编码
     */
    @ApiModelProperty( "预算编码")
    @Column(name = "month_budget_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算编码'")
    private String monthBudgetCode;

    /**
     * 预算类型[数据字典:tpm_budget_type]
     */
    @ApiModelProperty(name = "预算类型[数据字典:tpm_budget_type]", notes = "")
    @Column(name = "budget_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算类型[数据字典:tpm_budget_type] '")
    private String budgetType;

    /**
     * 关联预算金额
     */
    @ApiModelProperty("关联预算金额")
    @Column(name = "relation_amount", columnDefinition = "decimal(20,6) COMMENT '关联预算金额'")
    private BigDecimal relationAmount;

    /**
     * 剩余需调整金额
     */
    @ApiModelProperty("剩余需调整金额")
    @Column(name = "remainder_amount", precision = 20, scale = 6, columnDefinition = "DECIMAL(20,6) COMMENT '剩余需调整金额'")
    private BigDecimal remainderAmount;

    /**
     * 已调整预算金额
     */
    @ApiModelProperty(value = "已调整预算金额")
    @Column(name = "adjust_amount", columnDefinition = "decimal(20,6) COMMENT '已调整预算金额'")
    private BigDecimal adjustAmount;

}
