package com.biz.crm.tpm.business.duty.profit.adjust.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.FileEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 责任利润调整明细附件
 * 
 * @author: yaoyongming
 * @date: 2022/11/10 10:17
 */
@ApiModel(value = "DutyProfitAdjustDetailFiles",description = "责任利润调整明细附件")
@TableName("tpm_duty_profit_adjust_files")
@Getter
@Setter
@Entity(name = "tpm_duty_profit_adjust_files")
@org.hibernate.annotations.Table(appliesTo = "tpm_duty_profit_adjust_files", comment = "责任利润调整明细附件")
@Table(name = "tpm_duty_profit_adjust_files",
        indexes = @Index(name = "duty_profit_adjust_detail_files1", columnList = "duty_profit_adjust_detail_code")
)
public class DutyProfitAdjustFiles extends FileEntity {

    /**
     * 文件url
     */
    @ApiModelProperty("文件url")
    @TableField("file_url")
    @Column(
            name = "file_url",
            columnDefinition = "text COMMENT '文件url'"
    )
    private String fileUrl;

    /**
     * 责任利润调整明细编码
     */
    @ApiModelProperty("责任利润调整明细编码")
    @Column(name = "duty_profit_adjust_detail_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '责任利润调整明细编码'")
    private String dutyProfitAdjustDetailCode;
}
