package com.biz.crm.tpm.business.duty.profit.adjust.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.duty.profit.adjust.local.entity.DutyProfitAdjustDetailHandle;
import com.biz.crm.tpm.business.duty.profit.adjust.sdk.dto.DutyProfitAdjustDetailHandleDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 责任利润调整表(DutyProfitAdjustDetailHandle)表mybatis访问层
 *
 * @author yaoyongming
 * @since 2022-11-10 13:55:43
 */
public interface DutyProfitAdjustDetailHandleMapper extends BaseMapper<DutyProfitAdjustDetailHandle> {

    /**
     * 分页查询所有数据
     *
     * @param page                         分页对象
     * @param DutyProfitAdjustDetailHandle 查询实体
     * @return 所有数据
     */
    public Page<DutyProfitAdjustDetailHandle> findByConditions(@Param("page") Page<DutyProfitAdjustDetailHandle> page, @Param("DutyProfitAdjustDetailHandle") DutyProfitAdjustDetailHandle DutyProfitAdjustDetailHandle);

    /**
     * 调整预算查询
     *
     * @param code
     * @return
     */
    List<DutyProfitAdjustDetailHandleDto> findHandleByCode(@Param("detailCode") String code);

    List<DutyProfitAdjustDetailHandleDto> findHandleLogByCode(@Param("detailCode")String code);

}

