package com.biz.crm.tpm.business.duty.profit.adjust.local.notifier.log;

import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.tpm.business.duty.profit.adjust.sdk.dto.DutyProfitAdjustDetailDto;
import com.biz.crm.tpm.business.duty.profit.adjust.sdk.dto.log.DutyProfitAdjustLogEventDto;
import com.biz.crm.tpm.business.duty.profit.adjust.sdk.event.log.DutyProfitAdjustLogEventListener;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 日志实现
 *
 * @author: yaoyongming
 * @date: 2022/11/11 14:09
 */
@Component
public class DutyProfitAdjustLogEventListenerImpl implements DutyProfitAdjustLogEventListener {

    @Autowired(required = false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    /**
     * 创建事件
     *
     * @param eventDto
     */
    @Override
    public void onCreate(DutyProfitAdjustLogEventDto eventDto) {
        DutyProfitAdjustDetailDto newest = eventDto.getNewest();
        DutyProfitAdjustDetailDto original = eventDto.getOriginal();
        String onlyKey = newest.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    /**
     * 删除事件
     *
     * @param eventDto
     */
    @Override
    public void onDelete(DutyProfitAdjustLogEventDto eventDto) {
        DutyProfitAdjustDetailDto newest = eventDto.getNewest();
        DutyProfitAdjustDetailDto original = eventDto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    /**
     * 更新日志
     *
     * @param eventDto
     */
    @Override
    public void onUpdate(DutyProfitAdjustLogEventDto eventDto) {
        DutyProfitAdjustDetailDto newest = eventDto.getNewest();
        DutyProfitAdjustDetailDto original = eventDto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    /**
     * 启用
     *
     * @param eventDto
     */
    @Override
    public void onEnable(DutyProfitAdjustLogEventDto eventDto) {

    }

    /**
     * 禁用
     *
     * @param eventDto
     */
    @Override
    public void onDisable(DutyProfitAdjustLogEventDto eventDto) {

    }
}
