package com.biz.crm.tpm.business.duty.profit.adjust.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.duty.profit.adjust.local.entity.DutyProfitAdjustDetailHandle;
import com.biz.crm.tpm.business.duty.profit.adjust.local.mapper.DutyProfitAdjustDetailHandleMapper;
import com.biz.crm.tpm.business.duty.profit.adjust.sdk.dto.DutyProfitAdjustDetailHandleDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * 责任利润调整表(DutyProfitAdjustDetailHandle)表数据库访问层
 *
 * @author yaoyongming
 * @since 2022-11-10 13:55:43
 */
@Component
public class DutyProfitAdjustDetailHandleRepository extends ServiceImpl<DutyProfitAdjustDetailHandleMapper, DutyProfitAdjustDetailHandle> {
    @Autowired(required = false)
    private DutyProfitAdjustDetailHandleMapper dutyProfitAdjustDetailHandleMapper;

    /**
     * 按编码删除
     *
     * @param code
     */
    public void removeByCode(String code) {
        this.lambdaUpdate().eq(DutyProfitAdjustDetailHandle::getDutyProfitAdjustDetailCode, code).remove();
    }

    /**
     * 按编码查询
     *
     * @param codeList
     */
    public List<DutyProfitAdjustDetailHandle> findByCode(List<String> codeList) {
        return this.lambdaQuery().in(DutyProfitAdjustDetailHandle::getDutyProfitAdjustDetailCode, codeList).list();
    }

    /**
     * 调整预算查询
     *
     * @param code
     * @return
     */
    public List<DutyProfitAdjustDetailHandleDto> findHandleByCode(String code) {
        return dutyProfitAdjustDetailHandleMapper.findHandleByCode(code);
    }

    public List<DutyProfitAdjustDetailHandleDto> findHandleLogByCode(String code) {
        return dutyProfitAdjustDetailHandleMapper.findHandleLogByCode(code);
    }
}

