package com.biz.crm.tpm.business.duty.profit.adjust.local.repository;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.biz.crm.tpm.business.duty.profit.adjust.local.entity.DutyProfitAdjustDetail;
import com.biz.crm.tpm.business.duty.profit.adjust.local.mapper.DutyProfitAdjustDetailMapper;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;


/**
 * 责任利润调整表(DutyProfitAdjustDetail)表数据库访问层
 *
 * @author yaoyongming
 * @since 2022-11-10 13:55:43
 */
@Component
public class DutyProfitAdjustDetailRepository extends ServiceImpl<DutyProfitAdjustDetailMapper, DutyProfitAdjustDetail> {

    @Autowired(required = false)
    private DutyProfitAdjustDetailMapper dutyProfitAdjustDetailMapper;

    /**
     * 分页查询数据
     *
     * @param pageable               分页对象
     * @param dutyProfitAdjustDetail 实体对象
     * @return
     */
    public Page<DutyProfitAdjustDetail> findByConditions(Pageable pageable, DutyProfitAdjustDetail dutyProfitAdjustDetail) {
        Page<DutyProfitAdjustDetail> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<DutyProfitAdjustDetail> pageList = this.dutyProfitAdjustDetailMapper.findByConditions(page, dutyProfitAdjustDetail);
        return pageList;
    }

    /**
     * 按编码删除
     *
     * @param code
     */
    public void removeByCode(String code) {
        this.lambdaUpdate().eq(DutyProfitAdjustDetail::getDutyProfitAdjustCode, code).remove();
    }

    /**
     * 按编码查询
     *
     * @param code
     */
    public List<DutyProfitAdjustDetail> findByCode(String code) {
        return this.lambdaQuery().eq(DutyProfitAdjustDetail::getDutyProfitAdjustDetailCode, code).list();
    }

    /**
     * 按父编码查询
     *
     * @param code
     */
    public List<DutyProfitAdjustDetail> findByParentCode(String code) {
        return this.lambdaQuery().eq(DutyProfitAdjustDetail::getDutyProfitAdjustCode, code).list();
    }

    /**
     * 按dataId查询
     * @param ids
     * @return
     */
    public Set<String> findByDataId(Set<String> ids) {
        LambdaQueryWrapper<DutyProfitAdjustDetail> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.in(DutyProfitAdjustDetail::getDataId, ids).select(DutyProfitAdjustDetail::getDataId);
        return dutyProfitAdjustDetailMapper.selectObjs(lambdaQueryWrapper).stream().map(e -> (String) e).collect(Collectors.toSet());
    }
}

