package com.biz.crm.tpm.business.duty.profit.adjust.local.repository;


import com.biz.crm.tpm.business.duty.profit.adjust.local.entity.DutyProfitAdjustFiles;
import com.biz.crm.tpm.business.duty.profit.adjust.local.mapper.DutyProfitAdjustFilesMapper;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;

import java.util.List;


/**
 * 责任利润调整明细附件(DutyProfitAdjustFiles)表数据库访问层
 *
 * @author yaoyongming
 * @since 2022-11-10 13:55:43
 */
@Component
public class DutyProfitAdjustFilesRepository extends ServiceImpl<DutyProfitAdjustFilesMapper, DutyProfitAdjustFiles> {

    @Autowired(required = false)
    private DutyProfitAdjustFilesMapper dutyProfitAdjustFilesMapper;

    /**
     * 分页查询数据
     *
     * @param pageable              分页对象
     * @param dutyProfitAdjustFiles 实体对象
     * @return
     */
    public Page<DutyProfitAdjustFiles> findByConditions(Pageable pageable, DutyProfitAdjustFiles dutyProfitAdjustFiles) {
        Page<DutyProfitAdjustFiles> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<DutyProfitAdjustFiles> pageList = this.dutyProfitAdjustFilesMapper.findByConditions(page, dutyProfitAdjustFiles);
        return pageList;
    }

    /**
     * 按明细编码删除
     *
     * @param code
     */
    public  void removeByCode(String code) {
        this.dutyProfitAdjustFilesMapper.removeByCode(code);
    }

    /**
     * 按明细编码查询
     *
     * @param codeList
     * @return
     */
    public List<DutyProfitAdjustFiles> findByCodeList(List<String> codeList) {
        return this.lambdaQuery().in(DutyProfitAdjustFiles::getDutyProfitAdjustDetailCode, codeList).list();
    }

    /**
     * 按明细编码查询
     *
     * @param code
     * @return
     */
    public List<DutyProfitAdjustFiles> findByCodeList(String code) {
        return this.lambdaQuery().eq(DutyProfitAdjustFiles::getDutyProfitAdjustDetailCode, code).list();
    }
}

