package com.biz.crm.tpm.business.duty.profit.adjust.local.repository;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.duty.profit.adjust.local.entity.DutyProfitAdjust;
import com.biz.crm.tpm.business.duty.profit.adjust.local.mapper.DutyProfitAdjustMapper;
import com.biz.crm.tpm.business.duty.profit.adjust.sdk.dto.DutyProfitAdjustDto;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.stream.Collectors;


/**
 * 责任利润调整表(DutyProfitAdjust)表数据库访问层
 *
 * @author yaoyongming
 * @since 2022-11-10 13:55:12
 */
@Component
public class DutyProfitAdjustRepository extends ServiceImpl<DutyProfitAdjustMapper, DutyProfitAdjust> {

    @Autowired(required = false)
    private DutyProfitAdjustMapper dutyProfitAdjustMapper;

    /**
     * 分页查询数据
     *
     * @param pageable         分页对象
     * @param dutyProfitAdjust 实体对象
     * @return
     */
    public Page<DutyProfitAdjustDto> findByConditions(Pageable pageable, DutyProfitAdjustDto dutyProfitAdjust) {
        Page<DutyProfitAdjustDto> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<DutyProfitAdjustDto> pageList = this.dutyProfitAdjustMapper.findByConditions(page, dutyProfitAdjust);
        return pageList;
    }

    /**
     * 按id批量逻辑删除
     *
     * @param idList
     */
    public void removeDutyProfitAdjustByIds(List<String> idList) {
        this.lambdaUpdate().in(DutyProfitAdjust::getId, idList).set(DutyProfitAdjust::getDelFlag, DelFlagStatusEnum.DELETE.getCode()).update();
    }

    /**
     * 按编码查询
     *
     * @param code
     */
    public List<DutyProfitAdjust> findByCode(String code) {
        return this.lambdaQuery().eq(DutyProfitAdjust::getDutyProfitAdjustCode, code).list();
    }

    /**
     * 按dataId查询
     * @param ids
     * @return
     */
    public List<String> findByDataId(List<String> ids) {
        LambdaQueryWrapper<DutyProfitAdjust> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.in(DutyProfitAdjust::getDataId, ids).select(DutyProfitAdjust::getDataId);
        return dutyProfitAdjustMapper.selectObjs(lambdaQueryWrapper).stream().map(e -> (String) e).collect(Collectors.toList());
    }
}

