package com.biz.crm.tpm.business.duty.profit.adjust.local.service.internal;


import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.utils.MultipartFileUtil;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.third.system.jiandaoyun.sdk.service.JiandaoyunService;
import com.biz.crm.tpm.business.duty.profit.adjust.local.constant.DutyProfitAdjustConstant;
import com.biz.crm.tpm.business.duty.profit.adjust.local.entity.DutyProfitAdjust;
import com.biz.crm.tpm.business.duty.profit.adjust.local.entity.DutyProfitAdjustDetail;
import com.biz.crm.tpm.business.duty.profit.adjust.local.entity.DutyProfitAdjustDetailHandle;
import com.biz.crm.tpm.business.duty.profit.adjust.local.entity.DutyProfitAdjustFiles;
import com.biz.crm.tpm.business.duty.profit.adjust.local.enums.AdjustStatusEnum;
import com.biz.crm.tpm.business.duty.profit.adjust.local.repository.DutyProfitAdjustDetailHandleRepository;
import com.biz.crm.tpm.business.duty.profit.adjust.local.repository.DutyProfitAdjustDetailRepository;
import com.biz.crm.tpm.business.duty.profit.adjust.local.repository.DutyProfitAdjustFilesRepository;
import com.biz.crm.tpm.business.duty.profit.adjust.local.repository.DutyProfitAdjustRepository;
import com.biz.crm.tpm.business.duty.profit.adjust.sdk.dto.DutyProfitAdjustDetailDto;
import com.biz.crm.tpm.business.duty.profit.adjust.sdk.dto.DutyProfitAdjustDetailHandleDto;
import com.biz.crm.tpm.business.duty.profit.adjust.sdk.dto.DutyProfitAdjustDto;
import com.biz.crm.tpm.business.duty.profit.adjust.sdk.dto.DutyProfitAdjustFilesDto;
import com.biz.crm.tpm.business.duty.profit.adjust.sdk.dto.log.DutyProfitAdjustLogEventDto;
import com.biz.crm.tpm.business.duty.profit.adjust.sdk.enums.ProfitAdjustTypeEnum;
import com.biz.crm.tpm.business.duty.profit.adjust.sdk.event.log.DutyProfitAdjustLogEventListener;
import com.biz.crm.tpm.business.duty.profit.adjust.sdk.service.DutyProfitAdjustService;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.bizunited.nebula.venus.sdk.dto.Base64UploadDto;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Base64Utils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 责任利润调整表(DutyProfitAdjust)表服务实现类
 *
 * @author yaoyongming
 * @since 2022-11-10 13:55:12
 */
@Service
@Slf4j
public class DutyProfitAdjustServiceImpl implements DutyProfitAdjustService {

    @Autowired(required = false)
    private DutyProfitAdjustRepository dutyProfitAdjustRepository;

    @Autowired(required = false)
    private DutyProfitAdjustDetailRepository dutyProfitAdjustDetailRepository;

    @Autowired(required = false)
    private DutyProfitAdjustDetailHandleRepository dutyProfitAdjustDetailHandleRepository;

    @Autowired(required = false)
    private DutyProfitAdjustFilesRepository dutyProfitAdjustFilesRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private JiandaoyunService jiandaoyunService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private MonthBudgetLockService monthBudgetLockService;

    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private FileHandleService fileHandleService;

    /**
     * 分页查询数据
     *
     * @param pageable         分页对象
     * @param dutyProfitAdjust 实体对象
     * @return
     */
    @Override
    public Page<DutyProfitAdjustDto> findByConditions(Pageable pageable, DutyProfitAdjustDto dutyProfitAdjust) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dutyProfitAdjust)) {
            dutyProfitAdjust = new DutyProfitAdjustDto();
        }
        return this.dutyProfitAdjustRepository.findByConditions(pageable, dutyProfitAdjust);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @Override
    public DutyProfitAdjustDto findById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }
        DutyProfitAdjust entity = dutyProfitAdjustRepository.getById(id);
        if (entity == null) {
            return null;
        }
        //主表dto
        DutyProfitAdjustDto dto = nebulaToolkitService.copyObjectByWhiteList(entity, DutyProfitAdjustDto.class, HashSet.class, ArrayList.class);
        //明细
        List<DutyProfitAdjustDetail> detailEntityList = dutyProfitAdjustDetailRepository.findByParentCode(entity.getDutyProfitAdjustCode());
        Collection<DutyProfitAdjustDetailDto> detailDtos = nebulaToolkitService.copyCollectionByWhiteList(detailEntityList, DutyProfitAdjustDetail.class, DutyProfitAdjustDetailDto.class, HashSet.class, ArrayList.class);
        //附件
        List<String> detailCodeList = detailEntityList.stream().map(e -> e.getDutyProfitAdjustDetailCode()).collect(Collectors.toList());
        List<DutyProfitAdjustFiles> files = dutyProfitAdjustFilesRepository.findByCodeList(detailCodeList);
        Collection<DutyProfitAdjustFilesDto> fileDtos = nebulaToolkitService.copyCollectionByWhiteList(files, DutyProfitAdjustFiles.class, DutyProfitAdjustFilesDto.class, HashSet.class, ArrayList.class);
        Map<String, List<DutyProfitAdjustFilesDto>> map = fileDtos.stream().collect(Collectors.groupingBy(e -> e.getDutyProfitAdjustDetailCode()));
        //附件加入明细
        detailDtos.stream().forEach(e -> {
            List filesDtoList = map.get(e.getDutyProfitAdjustDetailCode());
            if (filesDtoList != null) {
                e.setFiles(map.get(e.getDutyProfitAdjustDetailCode()));
            }
        });
        dto.setDetails(new ArrayList<>(detailDtos));
        //调整信息
        List<DutyProfitAdjustDetailHandle> handleList = dutyProfitAdjustDetailHandleRepository.findByCode(detailCodeList);
        Collection<DutyProfitAdjustDetailHandleDto> handleDtoList = nebulaToolkitService.copyCollectionByWhiteList(handleList, DutyProfitAdjustDetailHandle.class, DutyProfitAdjustDetailHandleDto.class, HashSet.class, ArrayList.class);
        dto.setHandleDtos(new ArrayList<>(handleDtoList));

        return dto;
    }


    /**
     * 新增数据
     *
     * @param dutyProfitAdjust 实体对象
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void create(DutyProfitAdjustDto dutyProfitAdjust) {

        // redis生成料编码code
        List<String> codeList = this.generateCodeService.generateCode(DutyProfitAdjustConstant.PREFIX_CODE + DateFormatUtils.format(new Date(), "yyyyMMdd") , 1, 5, 2, TimeUnit.DAYS);
        dutyProfitAdjust.setDutyProfitAdjustCode(codeList.get(0));
        dutyProfitAdjust.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dutyProfitAdjust.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dutyProfitAdjust.setTenantCode(TenantUtils.getTenantCode());
        dutyProfitAdjust.setAuditStatus(AdjustStatusEnum.NONE.getCode());

        store(dutyProfitAdjust, dutyProfitAdjust.getDutyProfitAdjustCode());

        //新增业务日志
//        DutyProfitAdjustLogEventDto logEventDto = new DutyProfitAdjustLogEventDto();
//        logEventDto.setOriginal(null);
//        logEventDto.setNewest(dutyProfitAdjust);
//        SerializableBiConsumer<DutyProfitAdjustLogEventListener, DutyProfitAdjustLogEventDto> onCreate =
//                DutyProfitAdjustLogEventListener::onCreate;
//        this.nebulaNetEventClient.publish(logEventDto, DutyProfitAdjustLogEventListener.class, onCreate);
    }

    /**
     * 批量新增数据
     *
     * @param map 实体对象
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void createBatch(Map<String, List<DutyProfitAdjustDetailDto>> map) {
        commonValidate(map);

        // redis生成料编码code
        List<String> codeList = this.generateCodeService.generateCode(DutyProfitAdjustConstant.PREFIX_CODE + DateFormatUtils.format(new Date(), "yyyyMMdd") , map.size(), 5, 2, TimeUnit.DAYS);

        List<DutyProfitAdjustDetailDto> list = storeBatch(map, codeList);

        //新增业务日志
        for (DutyProfitAdjustDetailDto dto : list) {
            DutyProfitAdjustLogEventDto logEventDto = new DutyProfitAdjustLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer<DutyProfitAdjustLogEventListener, DutyProfitAdjustLogEventDto> onCreate =
                    DutyProfitAdjustLogEventListener::onCreate;
            this.nebulaNetEventClient.publish(logEventDto, DutyProfitAdjustLogEventListener.class, onCreate);
        }
    }

    /**
     * 修改新据
     *
     * @param dutyProfitAdjust 实体对象
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void update(DutyProfitAdjustDto dutyProfitAdjust) {

        DutyProfitAdjust entityOld = dutyProfitAdjustRepository.getById(dutyProfitAdjust.getId());

        Validate.notNull(entityOld, "未找到修改的数据");

        //清除数据
        dutyProfitAdjustFilesRepository.removeByCode(entityOld.getDutyProfitAdjustCode());
        dutyProfitAdjustDetailRepository.removeByCode(entityOld.getDutyProfitAdjustCode());

        dutyProfitAdjust.setDutyProfitAdjustCode(null);
        dutyProfitAdjust.setEnableStatus(null);
        dutyProfitAdjust.setDelFlag(null);
        dutyProfitAdjust.setTenantCode(null);

        store(dutyProfitAdjust, entityOld.getDutyProfitAdjustCode());

        //编辑业务日志
//        DutyProfitAdjustLogEventDto logEventDto = new DutyProfitAdjustLogEventDto();
//        logEventDto.setOriginal(this.nebulaToolkitService.copyObjectByWhiteList(entityOld, DutyProfitAdjustDto.class, LinkedHashSet.class, ArrayList.class));
//        logEventDto.setNewest(dutyProfitAdjust);
//        SerializableBiConsumer<DutyProfitAdjustLogEventListener, DutyProfitAdjustLogEventDto> onUpdate =
//                DutyProfitAdjustLogEventListener::onUpdate;
//        this.nebulaNetEventClient.publish(logEventDto, DutyProfitAdjustLogEventListener.class, onUpdate);
    }

    /**
     * 预算调整确认
     *
     * @param handleDtoList
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void adjust(List<DutyProfitAdjustDetailHandleDto> handleDtoList, String dutyProfitAdjustDetailCode, String profitAdjustType) {
        Validate.notBlank(dutyProfitAdjustDetailCode, "明细编码不能为空");
        Validate.notBlank(profitAdjustType, "调整金额类型不能为空");
        Validate.notEmpty(handleDtoList, "调整的明细不能为空!");
        Validate.isTrue(ProfitAdjustTypeEnum.EBIT.getCode().equals(profitAdjustType) || ProfitAdjustTypeEnum.RETAINED.getCode().equals(profitAdjustType), "调整金额类型错误");
        //加锁
        boolean hasLock = false;
        String lockKey = DutyProfitAdjustConstant.LOCK + dutyProfitAdjustDetailCode;
        try {
            hasLock = redisLockService.tryLock(lockKey, TimeUnit.MINUTES, 3);
            Validate.isTrue(hasLock, "编码[%s]其他人操作中,加锁失败,请稍后重试",dutyProfitAdjustDetailCode);
            //获取对应预算调整明细
            List<DutyProfitAdjustDetail> details = dutyProfitAdjustDetailRepository.findByCode(handleDtoList.get(0).getDutyProfitAdjustDetailCode());
            Validate.notEmpty(details, "未找到对应的明细！");
            DutyProfitAdjustDetail detail = details.get(0);

            List<String> monthCodeList = new ArrayList<>();
            //总金额
            BigDecimal amount = detail.getAmount();
            //已调整金额
            BigDecimal adjustAmount = detail.getAdjustAmount() == null ? BigDecimal.ZERO : detail.getAdjustAmount();
            BigDecimal netValue = detail.getNetValue() == null ? BigDecimal.ZERO : detail.getNetValue();
            Map<String, DutyProfitAdjustDetailHandleDto> map = new LinkedHashMap();
            for (DutyProfitAdjustDetailHandleDto dto : handleDtoList) {
                Validate.notNull(dto.getRelationAmount(),"请填写关联预算金额");
                dto.setId(null);
                dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                dto.setTenantCode(TenantUtils.getTenantCode());
                dto.setDutyProfitAdjustDetailCode(dutyProfitAdjustDetailCode);
                adjustAmount = adjustAmount.add(dto.getRelationAmount());
                dto.setAdjustAmount(adjustAmount);
                dto.setRemainderAmount(amount.add(adjustAmount));
                monthCodeList.add(dto.getMonthBudgetCode());
                map.put(dto.getMonthBudgetCode(), dto);
            }
            //比较明细金额，调出不可小于调出金额，调入不可大于调入金额。并修改调整状态
            BigDecimal absAdjustAmount = adjustAmount.abs();
            BigDecimal absAmount = amount.abs();
            int compare = absAmount.compareTo(absAdjustAmount);
            if (ProfitAdjustTypeEnum.RETAINED.getCode().equals(profitAdjustType)) {
                Validate.isTrue(netValue.compareTo(absAdjustAmount) >= 0, "调整金额类型为净额时，总调整金额的绝对值不可大于净额！");
            }
            if (DutyProfitAdjustConstant.OUT.equals(detail.getAdjustType())) {
                if (compare == 0) {
                    detail.setAuditStatus(AdjustStatusEnum.ALL.getCode());
                } else if (compare > 0) {
                    detail.setAuditStatus(AdjustStatusEnum.PART.getCode());
                } else {
                    throw new RuntimeException("总调整金额的绝对值不可大于调出金额的绝对值");
                }
            } else if (DutyProfitAdjustConstant.IN.equals(detail.getAdjustType())) {
                if (compare == 0) {
                    detail.setAuditStatus(AdjustStatusEnum.ALL.getCode());
                } else if (compare > 0) {
                    detail.setAuditStatus(AdjustStatusEnum.PART.getCode());
                } else {
                    throw new RuntimeException("总调整金额的绝对值不可大于调入金额的绝对值");
                }
            }

            dutyProfitAdjustDetailHandleRepository.saveBatch(nebulaToolkitService.copyCollectionByWhiteList(handleDtoList, DutyProfitAdjustDetailHandleDto.class, DutyProfitAdjustDetailHandle.class,
                    LinkedHashSet.class, ArrayList.class));

            detail.setAdjustAmount(adjustAmount);
            detail.setProfitAdjustType(profitAdjustType);
            dutyProfitAdjustDetailRepository.saveOrUpdate(detail);

            //预算调增、调减
            try {
                monthBudgetLockService.lock(monthCodeList, TimeUnit.MINUTES, 10);
                //2023.03.20 正是加 负是减 所以操作预算需要取反
                map.forEach((k, v) -> monthBudgetService.operateBudget(k, v.getRelationAmount().negate(), v.getBudgetType(), BudgetOperationTypeEnum.DUTY_PROFIT_ADJUST.getCode(), detail.getDutyProfitAdjustDetailCode()));
            } finally {
                monthBudgetLockService.unLock(monthCodeList);
            }

        } finally {
            if (hasLock) {
                this.redisLockService.unlock(lockKey);
            }
        }
    }

    /**
     * 保存
     *
     * @param dutyProfitAdjust
     * @param code
     */
    private void store(DutyProfitAdjustDto dutyProfitAdjust, String code) {
        DutyProfitAdjust dEntity = nebulaToolkitService.copyObjectByWhiteList(dutyProfitAdjust, DutyProfitAdjust.class, HashSet.class, ArrayList.class);
        List<DutyProfitAdjustDetailDto> detailsDto = dutyProfitAdjust.getDetails();

        // redis生成料编码code
        List<String> codeList = this.generateCodeService.generateCode(DutyProfitAdjustConstant.PREFIX_CODE_MX + DateFormatUtils.format(new Date(), "yyyyMMdd") , detailsDto.size(), 5, 2, TimeUnit.DAYS);
        int index = 0;
        Collection<DutyProfitAdjustFilesDto> filesDtoListAll = new ArrayList<>();
        for (DutyProfitAdjustDetailDto e : detailsDto) {
            e.setDutyProfitAdjustCode(code);
            e.setTenantCode(TenantUtils.getTenantCode());
            e.setDutyProfitAdjustDetailCode(codeList.get(index));
            //附件
            List<DutyProfitAdjustFilesDto> filesDtoList = e.getFiles();
            filesDtoList.forEach(e1 -> e1.setDutyProfitAdjustDetailCode(e.getDutyProfitAdjustDetailCode()));
            filesDtoListAll.addAll(filesDtoList);
            index++;
        }

        Collection<DutyProfitAdjustDetail> dDetails = nebulaToolkitService.copyCollectionByWhiteList(
                detailsDto, DutyProfitAdjustDetailDto.class, DutyProfitAdjustDetail.class, HashSet.class, ArrayList.class);
        Collection<DutyProfitAdjustFiles> files = nebulaToolkitService.copyCollectionByWhiteList(
                filesDtoListAll, DutyProfitAdjustFilesDto.class, DutyProfitAdjustFiles.class, HashSet.class, ArrayList.class);

        this.dutyProfitAdjustRepository.saveOrUpdate(dEntity);
        this.dutyProfitAdjustDetailRepository.saveBatch(dDetails);
        this.dutyProfitAdjustFilesRepository.saveBatch(files);
    }

    /**
     * 批量保存
     * @param map
     * @param codeList
     */
    public List<DutyProfitAdjustDetailDto> storeBatch(Map<String, List<DutyProfitAdjustDetailDto>> map, List<String> codeList) {
        Collection<DutyProfitAdjustFilesDto> filesDtoListAll = new ArrayList<>();
        List<DutyProfitAdjustDetailDto> detailsDtoAll = new ArrayList<>();
        String tenantCode = TenantUtils.getTenantCode();
        int indexHead = 0;
        for (String key : map.keySet()) {
            List<DutyProfitAdjustDetailDto> detailsDto = map.get(key);
            // redis生成料编码code
            List<String> codeDetailList = this.generateCodeService.generateCode(DutyProfitAdjustConstant.PREFIX_CODE_MX + DateFormatUtils.format(new Date(), "yyyyMMdd") , detailsDto.size(), 5, 2, TimeUnit.DAYS);
            int index = 0;
            for (DutyProfitAdjustDetailDto e : detailsDto) {
                e.setDutyProfitAdjustCode(codeList.get(indexHead));
                e.setTenantCode(tenantCode);
                e.setDutyProfitAdjustDetailCode(codeDetailList.get(index));
                e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                e.setAuditStatus(AdjustStatusEnum.NONE.getCode());
                e.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                if (StringUtils.isNotEmpty(e.getBusinessUnitNormal())){
//                    分子公司--常温销售；主体--常温主体；垂直重客--KA；电商-对应的就是电商
                    if ("常温主体".equals(e.getBusinessUnitNormal())) {
                        e.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
                    }
                    if ("常温销售".equals(e.getBusinessUnitNormal())) {
                        e.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
                    }
                    if ("KA".equals(e.getBusinessUnitNormal())) {
                        e.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
                    }
                    if ("电商".equals(e.getBusinessUnitNormal())) {
                        e.setBusinessUnitCode(BusinessUnitEnum.ONLINE.getCode());
                    }
                }
                //2023.03.20 为空就是主体
                if (StringUtils.isEmpty(e.getBusinessUnitNormal())) {
                    e.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
                }
                //附件
                List<DutyProfitAdjustFilesDto> filesDtoList = e.getFiles();
                filesDtoList.forEach(e1 -> {
                    e1.setDutyProfitAdjustDetailCode(e.getDutyProfitAdjustDetailCode());
                    e1.setTenantCode(tenantCode);
                });
                filesDtoListAll.addAll(filesDtoList);
                index++;
            }
            detailsDtoAll.addAll(detailsDto);
            indexHead++;
        }


        Collection<DutyProfitAdjustDetail> dDetails = nebulaToolkitService.copyCollectionByWhiteList(
                detailsDtoAll, DutyProfitAdjustDetailDto.class, DutyProfitAdjustDetail.class, HashSet.class, ArrayList.class);
        Collection<DutyProfitAdjustFiles> files = nebulaToolkitService.copyCollectionByWhiteList(
                filesDtoListAll, DutyProfitAdjustFilesDto.class, DutyProfitAdjustFiles.class, HashSet.class, ArrayList.class);

        this.dutyProfitAdjustDetailRepository.saveBatch(dDetails);

        //将简道云的附件下载下来到我们的venus
        this.fromJDY2Crm(files);
        this.dutyProfitAdjustFilesRepository.saveBatch(files);

        return detailsDtoAll;
    }

    private void fromJDY2Crm(Collection<DutyProfitAdjustFiles> files) {
        //可能有点慢
        files.forEach(file -> {
            try{
                URL url = new URL(file.getFileUrl());
                byte[] bytes = IOUtils.toByteArray(url);
                final MultipartFile multipartFile = MultipartFileUtil.getMultipartFile(new ByteArrayInputStream(bytes), file.getOriginalFileName());
                List<OrdinaryFileVo> fileVos = venusFileUpload(multipartFile);
                file.setFileCode(fileVos.get(0).getId());
            }catch (Exception e){
                log.error("下载简道云文件出错了:",e);
            }
        });
    }

    private List<OrdinaryFileVo> venusFileUpload(MultipartFile multipartFile) throws IOException {
        Base64UploadDto base64UploadDto = new Base64UploadDto();
        base64UploadDto.setCreator("简道云");
        base64UploadDto.setFileNanmes(new String[]{multipartFile.getOriginalFilename()});
        base64UploadDto.setBase64Contents(new String[]{Base64Utils.encodeToString(multipartFile.getBytes())});

        //subsystem不能有横杠只能用下划线分隔
        List<OrdinaryFileVo> ordinaryFileVoList = this.fileHandleService.fileUpload("crm_tpm", base64UploadDto);
        log.info("图片上传返回：{}",ordinaryFileVoList);
        Validate.notEmpty(ordinaryFileVoList, "文件上传失败！");
        return ordinaryFileVoList;
    }

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void delete(List<String> idList) {
        Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
        List<DutyProfitAdjust> planlist = this.dutyProfitAdjustRepository.listByIds(idList);
        Validate.notEmpty(planlist, "根据提供的主键集合信息，未能获取到相应数据");
        this.dutyProfitAdjustRepository.removeDutyProfitAdjustByIds(idList);

        //删除业务日志
//        Collection<DutyProfitAdjustDto> dtoList = nebulaToolkitService.copyCollectionByWhiteList(planlist,
//                DutyProfitAdjust.class, DutyProfitAdjustDto.class, HashSet.class, ArrayList.class);
//        SerializableBiConsumer<DutyProfitAdjustLogEventListener, DutyProfitAdjustLogEventDto> onDelete =
//                DutyProfitAdjustLogEventListener::onDelete;
//        for (DutyProfitAdjustDto dto : dtoList) {
//            DutyProfitAdjustLogEventDto logEventDto = new DutyProfitAdjustLogEventDto();
//            logEventDto.setOriginal(dto);
//            this.nebulaNetEventClient.publish(logEventDto, DutyProfitAdjustLogEventListener.class, onDelete);
//        }
    }

    /**
     * 简道云拉取数据
     */
    @Override
    @DynamicTaskService(cornExpression = "0 30 0 * * ?", taskDesc = "每天 00:30 执行一次简道云拉取数据任务")
    public void pullDutyProfitAdjust() {
        loginUserService.refreshAuthentication(null);
        AbstractCrmUserIdentity loginUser = loginUserService.getAbstractLoginUser();
        Date endDate = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(endDate);
        c.add(Calendar.DATE, -7);
        Date startDate = c.getTime();
        List<JSONObject> form = jiandaoyunService.getDutyProfitAdjust(startDate, endDate);
        pullDutyProfitAdjustStore(form);
    }

    /**
     * 简道云拉取数据手动触发
     *
     * @param startDate
     * @param endDate
     */
    @Override
    public void pullDutyProfitAdjustManual(String startDate, String endDate) {
        loginUserService.refreshAuthentication(null);
        AbstractCrmUserIdentity loginUser = loginUserService.getAbstractLoginUser();

        List<JSONObject> form = jiandaoyunService.getDutyProfitAdjust(DateUtil.parse(startDate), DateUtil.parse(endDate));
        pullDutyProfitAdjustStore(form);
    }

    private void pullDutyProfitAdjustStore (List<JSONObject> form) {
        if(CollectionUtils.isEmpty(form)) return;
        //查询是否有数据已在系统中生成，如果已生成，不保存
        List<DutyProfitAdjustDetailDto> detailDtos = JSONArray.parseArray(form.toString(), DutyProfitAdjustDetailDto.class);
        Set<String> ids = detailDtos.stream().map(DutyProfitAdjustDetailDto::getDataId).collect(Collectors.toSet());
        Set<String> dataIds = dutyProfitAdjustDetailRepository.findByDataId(ids);
        List<DutyProfitAdjustDetailDto> existList = detailDtos.stream().filter(e -> dataIds.contains(e.getDataId())).collect(Collectors.toList());
        detailDtos.removeAll(existList);
        Map<String, List<DutyProfitAdjustDetailDto>> map = detailDtos.stream().collect(Collectors.groupingBy(DutyProfitAdjustDetailDto::getDataId));
        createBatch(map);
    }

    /**
     * 调整预算查询
     *
     * @param dutyProfitAdjustDetailCode
     * @return
     */
    @Override
    public List<DutyProfitAdjustDetailHandleDto> findHandleByCode(String dutyProfitAdjustDetailCode) {
        return dutyProfitAdjustDetailHandleRepository.findHandleByCode(dutyProfitAdjustDetailCode);
    }

    /**
     * 附件查询
     *
     * @param dutyProfitAdjustDetailCode
     */
    @Override
    public List<DutyProfitAdjustFilesDto> findFilesByCode(String dutyProfitAdjustDetailCode) {
        List<DutyProfitAdjustFiles> dtoList = dutyProfitAdjustFilesRepository.findByCodeList(dutyProfitAdjustDetailCode);
        return dtoList == null ? new ArrayList<>() : (List<DutyProfitAdjustFilesDto>) nebulaToolkitService.copyCollectionByWhiteList(
                dtoList, DutyProfitAdjustFiles.class, DutyProfitAdjustFilesDto.class, HashSet.class, ArrayList.class);
    }

    /**
     * 调整预算查询日志
     *
     * @param dutyProfitAdjustDetailCode
     * @return
     */
    @Override
    public List<DutyProfitAdjustDetailHandleDto> findHandleLogByCode(String dutyProfitAdjustDetailCode) {
        return dutyProfitAdjustDetailHandleRepository.findHandleLogByCode(dutyProfitAdjustDetailCode);
    }


    /**
     * 公共校验
     *
     * @param map
     */
    private void commonValidate(Map<String, List<DutyProfitAdjustDetailDto>> map) {
        map.forEach((k, v) -> {
            DutyProfitAdjustDetailDto dutyProfitAdjust = v.get(0);
            Validate.notBlank(dutyProfitAdjust.getDutyProfitAdjustName(), "调整名称，不能为空！");
            Validate.notBlank(dutyProfitAdjust.getAuditCostCode(), "核减方式，不能为空！");
            Validate.notNull(dutyProfitAdjust.getAdjustDate(), "日期，不能为空！");
            Validate.notBlank(dutyProfitAdjust.getReason(), "调整原因，不能为空！");

            for (DutyProfitAdjustDetailDto e : v) {
                Validate.notNull(e.getAmount(), "金额，不能为空！");
                e.getFiles().forEach(e1 -> {
                    Validate.notBlank(e1.getFileUrl(), "文件唯一识别号，不能为空！");
                    Validate.notBlank(e1.getOriginalFileName(), "原始文件名，不能为空！");
                });
            }
        });

    }

}

