package com.biz.crm.tpm.business.duty.profit.adjust.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 责任利润调整明细dto
 *
 * @author: yaoyongming
 * @date: 2022/11/10 14:16
 */
@Getter
@Setter
@ApiModel(value = "DutyProfitAdjustDetailDto", description = "责任利润调整明细dto")
public class DutyProfitAdjustDetailDto extends TenantFlagOpDto {

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(value = "业务单元[数据字典:mdm_business_unit]")
    private String businessUnitCode;

    /**
     * 简道云接口id
     */
    @ApiModelProperty("简道云接口id")
    private String dataId;

    /**
     * 简道云接口明细id
     */
    @ApiModelProperty("简道云接口id")
    private String dataDetailId;

    /**
     * 成员单选
     */
    @ApiModelProperty("成员单选")
    private String user;

    /**
     * 责任利润调整编码
     */
    @ApiModelProperty("责任利润调整编码")
    private String dutyProfitAdjustCode;

    /**
     * 责任利润调整名称
     */
    @ApiModelProperty("责任利润调整名称")
    private String dutyProfitAdjustName;

    /**
     * 责任利润调整明细编码
     */
    @ApiModelProperty("责任利润调整明细编码")
    private String dutyProfitAdjustDetailCode;

    /**
     * 日期
     */
    @ApiModelProperty("日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date adjustDate;

    /**
     * 核减方式
     */
    @ApiModelProperty("核减方式")
    private String auditCostCode;

    /**
     * 调整原因
     */
    @ApiModelProperty("调整原因")
    private String reason;

    /**
     * 调整状态
     */
    @ApiModelProperty("调整状态")
    private String auditStatus;

    /**
     * 调整方向
     */
    @ApiModelProperty(value = "调整方向")
    private String adjustType;

    /**
     * 调整级别编码
     */
    @ApiModelProperty("调整级别编码")
    private String adjustLevelCode;

    /**
     * 事业部
     */
    @ApiModelProperty("事业部")
    private String division;

    /**
     * 业务单元
     */
    @ApiModelProperty("业务单元")
    private String businessUnit;

    /**
     * 业务单元常温
     */
    @ApiModelProperty("业务单元常温")
    private String businessUnitNormal;

    /**
     * 中心
     */
    @ApiModelProperty("中心")
    private String center;

    /**
     * 工厂
     */
    @ApiModelProperty("工厂")
    private String factory;

    /**
     * 品牌
     */
    @ApiModelProperty(name = "品牌")
    private String brand;

    /**
     * 部门
     */
    @ApiModelProperty("部门")
    private String department;

    /**
     * 二级科目
     */
    @ApiModelProperty(name = "二级科目")
    private String budgetItem2;

    /**
     * 一级科目
     */
    @ApiModelProperty(name = "一级科目")
    private String budgetItem1;

    /**
     * 属性
     */
    @ApiModelProperty(name = "属性")
    private String attribute;

    /**
     * 调入/调出金额
     */
    @ApiModelProperty(value = "调入/调出金额")
    private BigDecimal amount;

    /**
     * 已调整预算金额
     */
    @ApiModelProperty(value = "已调整预算金额")
    private BigDecimal adjustAmount;

    /**
     * 所得税
     */
    @ApiModelProperty("所得税")
    private BigDecimal incomeTax;

    /**
     * 所得税额
     */
    @ApiModelProperty("所得税额")
    private BigDecimal incomeTaxValue;

    /**
     * 净额
     */
    @ApiModelProperty("净额")
    private BigDecimal netValue;

    /**
     * 附件
     */
    @ApiModelProperty("附件")
    private List<DutyProfitAdjustFilesDto> files;

    /**
     * 调整金额类型
     */
    @ApiModelProperty(name = "调整金额类型")
    private String profitAdjustType;
}
