package com.biz.crm.tpm.business.duty.profit.adjust.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * 明细调整信息dto
 *
 * @author: yaoyongming
 * @date: 2022/11/16 14:00
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DutyProfitAdjustDetailHandleDto", description = "明细调整信息dto")
public class DutyProfitAdjustDetailHandleDto extends TenantFlagOpDto {

    /**
     * 责任利润调整明细编码
     */
    @ApiModelProperty("责任利润调整明细编码")
    private String dutyProfitAdjustDetailCode;

    /**
     * 预算编码
     */
    @ApiModelProperty( "预算编码")
    private String monthBudgetCode;

    /**
     * 预算类型[数据字典:tpm_budget_type]
     */
    @ApiModelProperty(name = "预算类型[数据字典:tpm_budget_type]", notes = "")
    private String budgetType;

    /**
     * 关联预算金额
     */
    @ApiModelProperty("关联预算金额")
    private BigDecimal relationAmount;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(value = "业务单元[数据字典:mdm_business_unit]")
    private String businessUnitCode;

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月")
    private String yearMonthLy;

    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码", notes = "")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称", notes = "")
    private String orgName;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称")
    private String budgetItemName;

    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称")
    private String customerName;

    /**
     * 年初分解金额（期初金额）
     */
    @ApiModelProperty(value = "年初分解金额（期初金额）")
    private BigDecimal initResolveAmount;

    /**
     * 累计可用余额
     */
    @ApiModelProperty(value = "累计可用余额")
    private BigDecimal accumulatedAvailableBalance;

    /**
     * 剩余需调整金额
     */
    @ApiModelProperty("剩余需调整金额")
    private BigDecimal remainderAmount;

    /**
     * 已调整预算金额
     */
    @ApiModelProperty(value = "已调整预算金额")
    private BigDecimal adjustAmount;
}
