package com.biz.crm.tpm.business.duty.profit.adjust.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 责任利润调整表dto
 *
 * @author: yaoyongming
 * @date: 2022/11/10 14:16
 */
@Data
@ApiModel(value = "DutyProfitAdjustDto", description = "责任利润调整表dto")
public class DutyProfitAdjustDto extends TenantFlagOpDto {

    /**
     *简道云接口id
     */
    @ApiModelProperty("简道云接口id")
    private String dataId;

    /**
     * 责任利润调整编码
     */
    @ApiModelProperty("责任利润调整编码")
    private String dutyProfitAdjustCode;

    /**
     * 责任利润调整名称
     */
    @ApiModelProperty("责任利润调整名称")
    private String dutyProfitAdjustName;

    /**
     * 日期
     */
    @ApiModelProperty("日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date adjustDate;

    /**
     * 核减方式
     */
    @ApiModelProperty("核减方式")
    private String auditCostCode;

    /**
     * 调出金额
     */
    @ApiModelProperty(value = "调出金额")
    private BigDecimal adjustOutAmount;

    /**
     * 调入金额
     */
    @ApiModelProperty(value = "调入金额")
    private BigDecimal adjustInAmount;

    /**
     * 调整原因
     */
    @ApiModelProperty("调整原因")
    private String reason;

    /**
     * 调整状态
     */
    @ApiModelProperty("调整状态")
    private String auditStatus;

    /**
     * 调整明细
     */
    @ApiModelProperty("调整明细")
    private List<DutyProfitAdjustDetailDto> details;

    /**
     * 调整信息
     */
    @ApiModelProperty("调整信息")
    private List<DutyProfitAdjustDetailHandleDto> handleDtos;

}
