package com.biz.crm.tpm.business.duty.profit.adjust.sdk.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.duty.profit.adjust.sdk.dto.DutyProfitAdjustDetailDto;
import com.biz.crm.tpm.business.duty.profit.adjust.sdk.dto.DutyProfitAdjustDetailHandleDto;
import com.biz.crm.tpm.business.duty.profit.adjust.sdk.dto.DutyProfitAdjustDto;
import com.biz.crm.tpm.business.duty.profit.adjust.sdk.dto.DutyProfitAdjustFilesDto;
import org.springframework.data.domain.Pageable;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 责任利润调整表(DutyProfitAdjust)表服务接口
 *
 * @author yaoyongming
 * @since 2022-11-10 13:55:12
 */
public interface DutyProfitAdjustService {

    /**
     * 分页查询数据
     *
     * @param pageable         分页对象
     * @param dutyProfitAdjust 实体对象
     * @return
     */
    Page<DutyProfitAdjustDto> findByConditions(Pageable pageable, DutyProfitAdjustDto dutyProfitAdjust);

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    DutyProfitAdjustDto findById(String id);

    /**
     * 新增数据
     *
     * @param dutyProfitAdjust 实体对象
     * @return 新增结果
     */
    void create(DutyProfitAdjustDto dutyProfitAdjust);


    /**
     * 批量新增数据
     *
     * @param map
     */
    void createBatch(Map<String, List<DutyProfitAdjustDetailDto>> map);

    /**
     * 修改新据
     *
     * @param dutyProfitAdjust 实体对象
     * @return 修改结果
     */
    void update(DutyProfitAdjustDto dutyProfitAdjust);

    /**
     * 预算调整确认
     *
     * @param handleDtoList
     */
    void adjust(List<DutyProfitAdjustDetailHandleDto> handleDtoList, String dutyProfitAdjustDetailCode, String profitAdjustType);

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    void delete(List<String> idList);

    /**
     * 简道云拉取数据
     */
    void pullDutyProfitAdjust();

    /**
     * 简道云拉取数据手动触发
     */
    void pullDutyProfitAdjustManual(String startDate, String endDate);

    /**
     * 调整预算查询
     *
     * @param dutyProfitAdjustDetailCode
     * @return
     */
    List<DutyProfitAdjustDetailHandleDto> findHandleByCode(String dutyProfitAdjustDetailCode);

    /**
     * 附件查询
     *
     * @param dutyProfitAdjustDetailCode
     */
    List<DutyProfitAdjustFilesDto> findFilesByCode(String dutyProfitAdjustDetailCode);

    /**
     * 调整预算查询日志
     *
     * @param dutyProfitAdjustDetailCode
     * @return
     */
    List<DutyProfitAdjustDetailHandleDto> findHandleLogByCode(String dutyProfitAdjustDetailCode);
}

