/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.event.prepayment.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.event.prepayment.local.entity.EventPrepaymentEntity;
import com.biz.crm.tpm.business.event.prepayment.local.enums.CommitStatusEnum;
import com.biz.crm.tpm.business.event.prepayment.local.mapper.EventPrepaymentMapper;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.EventPrepaymentDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.CustomerPrepaymentVo;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.EventPrepaymentVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class EventPrepaymentRepository
extends ServiceImpl<EventPrepaymentMapper, EventPrepaymentEntity> {
    @Resource
    private EventPrepaymentMapper eventPrepaymentMapper;

    public Page<EventPrepaymentVo> findByPrepayments(Pageable pageable, EventPrepaymentDto eventPrepaymentDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<EventPrepaymentVo> pageList = this.eventPrepaymentMapper.findByPrepayments((Page<EventPrepaymentVo>)page, eventPrepaymentDto);
        return pageList;
    }

    public EventPrepaymentEntity findByCode(String code) {
        return (EventPrepaymentEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(EventPrepaymentEntity::getPrepaidCoding, (Object)code)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public List<EventPrepaymentEntity> findByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(EventPrepaymentEntity::getPrepaidCoding, codes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<EventPrepaymentEntity> findByUpAccountCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(EventPrepaymentEntity::getUpAccountCode, codes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<EventPrepaymentEntity> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public void updateSapTransferCommitMessage(EventPrepaymentVo eventPrepaymentVo, String errorMsg) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(EventPrepaymentEntity::getPrepaidCoding, (Object)eventPrepaymentVo.getPrepaidCoding())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(EventPrepaymentEntity::getSapTransferCommitMessage, (Object)errorMsg)).set(EventPrepaymentEntity::getSapTransferCommitStatus, (Object)CommitStatusEnum.COMMIT_FAIL.getCode())).update();
    }

    public List<CustomerPrepaymentVo> findActivityPrepaymentByDetailPlanItemCodes(List<String> detailPlanItemCodes) {
        if (CollectionUtils.isEmpty(detailPlanItemCodes)) {
            return Lists.newArrayList();
        }
        return ((EventPrepaymentMapper)this.getBaseMapper()).findActivityPrepaymentByDetailPlanItemCodes(detailPlanItemCodes);
    }

    public List<Date> findProcessDateByActivityDetailCodes(String detailPlanItemCode) {
        if (StringUtils.isEmpty((CharSequence)detailPlanItemCode)) {
            return Lists.newArrayList();
        }
        return ((EventPrepaymentMapper)this.getBaseMapper()).findProcessDateByActivityDetailCodes(detailPlanItemCode);
    }
}

