/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.event.prepayment.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.supplier.sdk.service.SupplierVoService;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.mn.third.system.sd.sdk.dto.AuditCostPostingCallbackDataDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.AuditCostPostingCallbackDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.AuditFeeUpAccountDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.AuditFeeUpAccountSonCompanyDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.PaymentReceiptApplyDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.PaymentReceiptDetailDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.PaymentReceiptFeeDetailDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.PaymentReceiptHeadDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.PaymentReceiptQueryStatusDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.SonAuditCostPostingCallbackDataDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.SonAuditCostPostingCallbackDto;
import com.biz.crm.mn.third.system.sd.sdk.service.SapSdApiService;
import com.biz.crm.mn.third.system.sd.sdk.vo.PaymentReceiptResultVo;
import com.biz.crm.mn.third.system.sd.sdk.vo.PaymentReceiptStatusResultVo;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.event.prepayment.local.entity.CustomerPrepaymentEntity;
import com.biz.crm.tpm.business.event.prepayment.local.entity.EventPrepaymentEntity;
import com.biz.crm.tpm.business.event.prepayment.local.entity.PaymentDetailEntity;
import com.biz.crm.tpm.business.event.prepayment.local.entity.PrepaidBySupplierEntity;
import com.biz.crm.tpm.business.event.prepayment.local.enums.CommitStatusEnum;
import com.biz.crm.tpm.business.event.prepayment.local.enums.PayInAdvanceEnum;
import com.biz.crm.tpm.business.event.prepayment.local.enums.RequestCERespCodeEnum;
import com.biz.crm.tpm.business.event.prepayment.local.enums.SucessOrFailEnum;
import com.biz.crm.tpm.business.event.prepayment.local.mapper.EventPrepaymentMapper;
import com.biz.crm.tpm.business.event.prepayment.local.repository.CustomerPrepaymentRepository;
import com.biz.crm.tpm.business.event.prepayment.local.repository.EventPrepaymentRepository;
import com.biz.crm.tpm.business.event.prepayment.local.repository.MaterialInformationRepository;
import com.biz.crm.tpm.business.event.prepayment.local.repository.MaterialProcurementRepository;
import com.biz.crm.tpm.business.event.prepayment.local.repository.PaymentDetailRepository;
import com.biz.crm.tpm.business.event.prepayment.local.repository.PrepaidBySupplierRepository;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.CommercePrepaymentDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.CustomerPrepaymentDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.EventPrepaymentDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.EventPrepaymentSubmitDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.PurchaseOrderDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.TotalPrepaidAmountDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.log.EventPrepaymentLogEventDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.event.EventPrepaymentLogEventListener;
import com.biz.crm.tpm.business.event.prepayment.sdk.service.CustomerPrepaymentService;
import com.biz.crm.tpm.business.event.prepayment.sdk.service.EventPrepaymentService;
import com.biz.crm.tpm.business.event.prepayment.sdk.service.MaterialInformationService;
import com.biz.crm.tpm.business.event.prepayment.sdk.service.MaterialProcurementService;
import com.biz.crm.tpm.business.event.prepayment.sdk.service.PrepaidBySupplierService;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.CustomerPrepaymentVo;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.EventPrepaymentStatusDetailVo;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.EventPrepaymentVo;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.MaterialInformationVo;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.MaterialProcurementVo;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.PrepaidBySupplierVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.ExpensesDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.GeneralExpensesDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.GeneralExpensesService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.GeneralExpensesVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service(value="eventPrepaymentService")
public class EventPrepaymentServiceImpl
implements EventPrepaymentService {
    private static final Logger log = LoggerFactory.getLogger(EventPrepaymentServiceImpl.class);
    @Autowired(required=false)
    private EventPrepaymentRepository eventPrepaymentRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private CustomerPrepaymentService customerPrepaymentService;
    @Autowired(required=false)
    private PrepaidBySupplierService prepaidBySupplierService;
    @Autowired(required=false)
    private ProcessBusinessService processBusinessService;
    @Autowired(required=false)
    private CustomerPrepaymentRepository customerPrepaymentRepository;
    @Autowired(required=false)
    private MaterialInformationRepository materialInformationRepository;
    @Autowired(required=false)
    private MaterialInformationService materialInformationService;
    @Autowired(required=false)
    private MaterialProcurementService materialProcurementService;
    @Autowired(required=false)
    private MaterialProcurementRepository materialProcurementRepository;
    @Autowired(required=false)
    private PrepaidBySupplierRepository prepaidBySupplierRepository;
    @Autowired(required=false)
    private SupplierVoService supplierVoService;
    @Autowired(required=false)
    private PaymentDetailRepository paymentDetailRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired
    private SapSdApiService sapSdApiService;
    @Autowired
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;
    @Value(value="${rocketmq.environment}")
    private String rocketmqEnvironment;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private GeneralExpensesService generalExpensesService;

    public Page<EventPrepaymentVo> findByPrepayments(Pageable pageable, EventPrepaymentDto eventPrepaymentDto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(eventPrepaymentDto)) {
            eventPrepaymentDto = new EventPrepaymentDto();
        }
        return this.eventPrepaymentRepository.findByPrepayments(pageable, eventPrepaymentDto);
    }

    @Transactional(rollbackFor={Exception.class})
    public EventPrepaymentVo create(EventPrepaymentDto eventPrepaymentDto) {
        this.createValidate(eventPrepaymentDto);
        this.checkPrepaidAmount(eventPrepaymentDto);
        AbstractCrmUserIdentity loginDetails = this.loginUserService.getAbstractLoginUser();
        Object orgCodeObject = loginDetails.invokeFieldValue("orgCode");
        Object orgNameObject = loginDetails.invokeFieldValue("orgName");
        eventPrepaymentDto.setOrgCode(orgCodeObject == null ? null : orgCodeObject.toString());
        eventPrepaymentDto.setOrgName(orgNameObject == null ? null : orgNameObject.toString());
        eventPrepaymentDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        eventPrepaymentDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        eventPrepaymentDto.setTenantCode(TenantUtils.getTenantCode());
        eventPrepaymentDto.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
        String eventPrepaymentCode = (String)this.generateCodeService.generateCode("YF", 1, Integer.valueOf(5), 2L, TimeUnit.DAYS).get(0);
        Validate.notBlank((CharSequence)eventPrepaymentCode, (String)"\u9884\u4ed8\u7f16\u53f7\u751f\u6210\u5931\u8d25", (Object[])new Object[0]);
        eventPrepaymentDto.setPrepaidCoding(eventPrepaymentCode);
        if (eventPrepaymentDto.getPrepaymentType().equals(PayInAdvanceEnum.ACTIVITY.getCode())) {
            if (BusinessUnitEnum.ONLINE.getCode().equals(eventPrepaymentDto.getBusinessUnitCode())) {
                this.prepaidBySupplierService.create(eventPrepaymentDto.getPrepaidBySupplier(), eventPrepaymentCode);
            } else {
                this.customerPrepaymentService.create(eventPrepaymentDto.getCustomerPrepayment(), eventPrepaymentDto);
            }
        } else if (eventPrepaymentDto.getPrepaymentType().equals(PayInAdvanceEnum.CUSTOMER.getCode())) {
            if (eventPrepaymentDto.getCustomerPrepayment() != null && eventPrepaymentDto.getCustomerPrepayment().size() > 0) {
                this.customerPrepaymentService.create(eventPrepaymentDto.getCustomerPrepayment(), eventPrepaymentDto);
            }
            if (eventPrepaymentDto.getMaterialInformation() != null && eventPrepaymentDto.getMaterialInformation().size() > 0) {
                this.materialInformationService.create(eventPrepaymentDto.getMaterialInformation(), eventPrepaymentDto);
            }
        } else if (eventPrepaymentDto.getPrepaymentType().equals(PayInAdvanceEnum.SUPPLIER.getCode())) {
            if (eventPrepaymentDto.getPrepaidBySupplier() != null && eventPrepaymentDto.getPrepaidBySupplier().size() > 0) {
                this.prepaidBySupplierService.create(eventPrepaymentDto.getPrepaidBySupplier(), eventPrepaymentCode);
            }
            if (eventPrepaymentDto.getMaterialInformation() != null && eventPrepaymentDto.getMaterialInformation().size() > 0) {
                this.materialInformationService.create(eventPrepaymentDto.getMaterialInformation(), eventPrepaymentDto);
            }
        } else if (eventPrepaymentDto.getPrepaymentType().equals(PayInAdvanceEnum.MATERIAL.getCode())) {
            if (eventPrepaymentDto.getMaterialProcurement() != null && eventPrepaymentDto.getMaterialProcurement().size() > 0) {
                this.materialProcurementService.create(eventPrepaymentDto.getMaterialProcurement(), eventPrepaymentCode);
            }
            if (eventPrepaymentDto.getMaterialInformation() != null && eventPrepaymentDto.getMaterialInformation().size() > 0) {
                this.materialInformationService.create(eventPrepaymentDto.getMaterialInformation(), eventPrepaymentDto);
            }
        }
        EventPrepaymentEntity eventPrepaymentEntity = (EventPrepaymentEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)eventPrepaymentDto, EventPrepaymentEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.eventPrepaymentRepository.saveOrUpdate((Object)eventPrepaymentEntity);
        eventPrepaymentDto.setId(eventPrepaymentEntity.getId());
        EventPrepaymentLogEventDto logEventDto = new EventPrepaymentLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(eventPrepaymentDto);
        SerializableBiConsumer & Serializable onCreate = EventPrepaymentLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, EventPrepaymentLogEventListener.class, (SerializableBiConsumer)onCreate);
        return (EventPrepaymentVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)eventPrepaymentDto, EventPrepaymentVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List eventPrepaymentEntities = this.eventPrepaymentRepository.listByIds(ids);
        Validate.notEmpty((Collection)eventPrepaymentEntities, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u4e3b\u952e\u96c6\u5408\u4fe1\u606f\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u6570\u636e", (Object[])new Object[0]);
        for (EventPrepaymentEntity entity : eventPrepaymentEntities) {
            if (ProcessStatusEnum.PREPARE.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.REJECT.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.RECOVER.getKey().equals(entity.getProcessStatus())) continue;
            throw new RuntimeException("[" + entity.getPrepaidCoding() + "]\u672a\u5904\u4e8e\u3010\u5f85\u63d0\u4ea4\u3011\u3001\u3010\u9a73\u56de\u3011\u3001\u3010\u8ffd\u56de\u3011\u72b6\u6001\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
        }
        eventPrepaymentEntities.forEach(pre -> {
            if (pre.getPrepaymentType().equals(PayInAdvanceEnum.ACTIVITY.getCode())) {
                UpdateWrapper wrapper = new UpdateWrapper();
                ((UpdateWrapper)wrapper.eq((Object)"prepaid_coding", (Object)pre.getPrepaidCoding())).set((Object)"del_flag", (Object)DelFlagStatusEnum.DELETE.getCode());
                this.customerPrepaymentRepository.update((Wrapper)wrapper);
            } else if (pre.getPrepaymentType().equals(PayInAdvanceEnum.CUSTOMER.getCode())) {
                UpdateWrapper wrapper = new UpdateWrapper();
                ((UpdateWrapper)wrapper.eq((Object)"prepaid_coding", (Object)pre.getPrepaidCoding())).set((Object)"del_flag", (Object)DelFlagStatusEnum.DELETE.getCode());
                this.customerPrepaymentRepository.update((Wrapper)wrapper);
                UpdateWrapper queryWrapper = new UpdateWrapper();
                ((UpdateWrapper)queryWrapper.eq((Object)"prepaid_coding", (Object)pre.getPrepaidCoding())).set((Object)"del_flag", (Object)DelFlagStatusEnum.DELETE.getCode());
                this.materialInformationRepository.update((Wrapper)queryWrapper);
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.paymentDetailRepository.lambdaUpdate().eq(PaymentDetailEntity::getPrepaidCoding, (Object)pre.getPrepaidCoding())).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
            } else if (pre.getPrepaymentType().equals(PayInAdvanceEnum.SUPPLIER.getCode())) {
                UpdateWrapper wrapper = new UpdateWrapper();
                ((UpdateWrapper)wrapper.eq((Object)"prepaid_coding", (Object)pre.getPrepaidCoding())).set((Object)"del_flag", (Object)DelFlagStatusEnum.DELETE.getCode());
                this.prepaidBySupplierRepository.update((Wrapper)wrapper);
                UpdateWrapper queryWrapper = new UpdateWrapper();
                ((UpdateWrapper)queryWrapper.eq((Object)"prepaid_coding", (Object)pre.getPrepaidCoding())).set((Object)"del_flag", (Object)DelFlagStatusEnum.DELETE.getCode());
                this.materialInformationRepository.update((Wrapper)queryWrapper);
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.paymentDetailRepository.lambdaUpdate().eq(PaymentDetailEntity::getPrepaidCoding, (Object)pre.getPrepaidCoding())).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
            } else if (pre.getPrepaymentType().equals(PayInAdvanceEnum.MATERIAL.getCode())) {
                UpdateWrapper wrapper = new UpdateWrapper();
                ((UpdateWrapper)wrapper.eq((Object)"prepaid_coding", (Object)pre.getPrepaidCoding())).set((Object)"del_flag", (Object)DelFlagStatusEnum.DELETE.getCode());
                this.materialProcurementRepository.update((Wrapper)wrapper);
                UpdateWrapper queryWrapper = new UpdateWrapper();
                ((UpdateWrapper)queryWrapper.eq((Object)"prepaid_coding", (Object)pre.getPrepaidCoding())).set((Object)"del_flag", (Object)DelFlagStatusEnum.DELETE.getCode());
                this.materialInformationRepository.update((Wrapper)queryWrapper);
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.paymentDetailRepository.lambdaUpdate().eq(PaymentDetailEntity::getPrepaidCoding, (Object)pre.getPrepaidCoding())).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
            }
        });
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.eventPrepaymentRepository.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
        Collection dtoList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)eventPrepaymentEntities, EventPrepaymentEntity.class, EventPrepaymentDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable onDelete = EventPrepaymentLogEventListener::onDelete;
        for (EventPrepaymentDto dto : dtoList) {
            EventPrepaymentLogEventDto logEventDto = new EventPrepaymentLogEventDto();
            logEventDto.setOriginal(dto);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, EventPrepaymentLogEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public EventPrepaymentVo update(EventPrepaymentDto eventPrepaymentDto) {
        this.checkPrepaidAmount(eventPrepaymentDto);
        EventPrepaymentVo eventPrepaymentVo = this.findByPrepaidCoding(eventPrepaymentDto.getPrepaidCoding());
        Validate.notNull((Object)eventPrepaymentVo, (String)"\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        eventPrepaymentDto.setTenantCode(TenantUtils.getTenantCode());
        if (eventPrepaymentDto.getPrepaymentType().equals(PayInAdvanceEnum.ACTIVITY.getCode())) {
            if (StringUtils.equals((CharSequence)eventPrepaymentDto.getBusinessUnitCode(), (CharSequence)BusinessUnitEnum.ONLINE.getCode())) {
                this.prepaidBySupplierService.update(eventPrepaymentDto.getPrepaidBySupplier(), eventPrepaymentDto.getPrepaidCoding());
            } else {
                this.customerPrepaymentService.update(eventPrepaymentDto.getCustomerPrepayment(), eventPrepaymentDto);
            }
        } else if (eventPrepaymentDto.getPrepaymentType().equals(PayInAdvanceEnum.CUSTOMER.getCode())) {
            this.customerPrepaymentService.update(eventPrepaymentDto.getCustomerPrepayment(), eventPrepaymentDto);
            this.materialInformationService.update(eventPrepaymentDto.getMaterialInformation(), eventPrepaymentDto);
        } else if (eventPrepaymentDto.getPrepaymentType().equals(PayInAdvanceEnum.SUPPLIER.getCode())) {
            this.prepaidBySupplierService.update(eventPrepaymentDto.getPrepaidBySupplier(), eventPrepaymentDto.getPrepaidCoding());
            this.materialInformationService.update(eventPrepaymentDto.getMaterialInformation(), eventPrepaymentDto);
        } else if (eventPrepaymentDto.getPrepaymentType().equals(PayInAdvanceEnum.MATERIAL.getCode())) {
            this.materialProcurementService.update(eventPrepaymentDto.getMaterialProcurement(), eventPrepaymentDto.getPrepaidCoding());
            this.materialInformationService.update(eventPrepaymentDto.getMaterialInformation(), eventPrepaymentDto);
        }
        EventPrepaymentEntity eventPrepaymentEntity = (EventPrepaymentEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)eventPrepaymentDto, EventPrepaymentEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.eventPrepaymentRepository.saveOrUpdate((Object)eventPrepaymentEntity);
        EventPrepaymentDto dto = (EventPrepaymentDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)eventPrepaymentVo, EventPrepaymentDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        EventPrepaymentLogEventDto logEventDto = new EventPrepaymentLogEventDto();
        logEventDto.setOriginal(dto);
        logEventDto.setNewest(eventPrepaymentDto);
        SerializableBiConsumer & Serializable onUpdate = EventPrepaymentLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, EventPrepaymentLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return eventPrepaymentVo;
    }

    public EventPrepaymentVo findByPrepaidCoding(String code) {
        EventPrepaymentEntity eventPrepaymentEntity = this.eventPrepaymentRepository.findByCode(code);
        if (eventPrepaymentEntity == null) {
            return null;
        }
        EventPrepaymentVo eventPrepaymentVo = (EventPrepaymentVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)eventPrepaymentEntity, EventPrepaymentVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        if (eventPrepaymentVo.getPrepaymentType().equals(PayInAdvanceEnum.ACTIVITY.getCode())) {
            if (BusinessUnitEnum.ONLINE.getCode().equals(eventPrepaymentVo.getBusinessUnitCode())) {
                List byPrepaid = this.prepaidBySupplierService.findByPrepaid(eventPrepaymentVo.getPrepaidCoding());
                eventPrepaymentVo.setPrepaidBySupplier(byPrepaid);
            } else {
                List byPrepaid = this.customerPrepaymentService.findByPrepaid(eventPrepaymentVo.getPrepaidCoding());
                eventPrepaymentVo.setCustomerPrepayment(byPrepaid);
            }
        } else if (eventPrepaymentVo.getPrepaymentType().equals(PayInAdvanceEnum.CUSTOMER.getCode())) {
            List byPrepaid = this.customerPrepaymentService.findByPrepaid(eventPrepaymentVo.getPrepaidCoding());
            eventPrepaymentVo.setCustomerPrepayment(byPrepaid);
            List prepaid = this.materialInformationService.findByPrepaid(eventPrepaymentVo.getPrepaidCoding());
            eventPrepaymentVo.setMaterialInformation(prepaid);
        } else if (eventPrepaymentVo.getPrepaymentType().equals(PayInAdvanceEnum.SUPPLIER.getCode())) {
            List byPrepaid = this.prepaidBySupplierService.findByPrepaid(eventPrepaymentVo.getPrepaidCoding());
            eventPrepaymentVo.setPrepaidBySupplier(byPrepaid);
            List prepaid = this.materialInformationService.findByPrepaid(eventPrepaymentVo.getPrepaidCoding());
            eventPrepaymentVo.setMaterialInformation(prepaid);
        } else if (eventPrepaymentVo.getPrepaymentType().equals(PayInAdvanceEnum.MATERIAL.getCode())) {
            List byPrepaid = this.materialProcurementService.findByPrepaid(eventPrepaymentVo.getPrepaidCoding());
            eventPrepaymentVo.setMaterialProcurement(byPrepaid);
            List prepaid = this.materialInformationService.findByPrepaid(eventPrepaymentVo.getPrepaidCoding());
            eventPrepaymentVo.setMaterialInformation(prepaid);
        }
        return eventPrepaymentVo;
    }

    public List<EventPrepaymentVo> findByIds(List<String> ids) {
        List<EventPrepaymentEntity> entities = this.eventPrepaymentRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(entities)) {
            return null;
        }
        Collection eventPrepaymentVos = this.nebulaToolkitService.copyCollectionByWhiteList(entities, EventPrepaymentEntity.class, EventPrepaymentVo.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList<EventPrepaymentVo> eventPrepaymentVoList = new ArrayList<EventPrepaymentVo>();
        for (EventPrepaymentVo eventPrepaymentVo : eventPrepaymentVos) {
            List prepaid;
            List byPrepaid;
            if (eventPrepaymentVo.getPrepaymentType().equals(PayInAdvanceEnum.ACTIVITY.getCode())) {
                byPrepaid = this.customerPrepaymentService.findByPrepaid(eventPrepaymentVo.getPrepaidCoding());
                eventPrepaymentVo.setCustomerPrepayment(byPrepaid);
            } else if (eventPrepaymentVo.getPrepaymentType().equals(PayInAdvanceEnum.CUSTOMER.getCode())) {
                byPrepaid = this.customerPrepaymentService.findByPrepaid(eventPrepaymentVo.getPrepaidCoding());
                eventPrepaymentVo.setCustomerPrepayment(byPrepaid);
                prepaid = this.materialInformationService.findByPrepaid(eventPrepaymentVo.getPrepaidCoding());
                eventPrepaymentVo.setMaterialInformation(prepaid);
            } else if (eventPrepaymentVo.getPrepaymentType().equals(PayInAdvanceEnum.SUPPLIER.getCode())) {
                byPrepaid = this.prepaidBySupplierService.findByPrepaid(eventPrepaymentVo.getPrepaidCoding());
                eventPrepaymentVo.setPrepaidBySupplier(byPrepaid);
                prepaid = this.materialInformationService.findByPrepaid(eventPrepaymentVo.getPrepaidCoding());
                eventPrepaymentVo.setMaterialInformation(prepaid);
            } else if (eventPrepaymentVo.getPrepaymentType().equals(PayInAdvanceEnum.MATERIAL.getCode())) {
                byPrepaid = this.materialProcurementService.findByPrepaid(eventPrepaymentVo.getPrepaidCoding());
                eventPrepaymentVo.setMaterialProcurement(byPrepaid);
                prepaid = this.materialInformationService.findByPrepaid(eventPrepaymentVo.getPrepaidCoding());
                eventPrepaymentVo.setMaterialInformation(prepaid);
            }
            eventPrepaymentVoList.add(eventPrepaymentVo);
        }
        return eventPrepaymentVoList;
    }

    @Transactional(rollbackFor={Exception.class})
    public void submitAndSetPass(EventPrepaymentSubmitDto dto) {
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        EventPrepaymentDto eventPrepaymentDto = (EventPrepaymentDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, EventPrepaymentDto.class, HashSet.class, ArrayList.class, new String[0]);
        Validate.isTrue((boolean)Objects.nonNull(processBusiness), (String)"\u6d41\u7a0b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)Objects.nonNull(eventPrepaymentDto), (String)"\u6d3b\u52a8\u9884\u4ed8\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        eventPrepaymentDto.setCustomerPrepayment(dto.getCustomerPrepayment());
        eventPrepaymentDto.setPrepaidBySupplier(dto.getPrepaidBySupplier());
        eventPrepaymentDto.setMaterialProcurement(dto.getMaterialProcurement());
        eventPrepaymentDto.setMaterialInformation(dto.getMaterialInformation());
        if (StringUtils.isNotBlank((CharSequence)eventPrepaymentDto.getId())) {
            this.update(eventPrepaymentDto);
        } else {
            this.create(eventPrepaymentDto);
        }
        EventPrepaymentEntity entity = (EventPrepaymentEntity)((Object)this.eventPrepaymentRepository.getById((Serializable)((Object)eventPrepaymentDto.getId())));
        Validate.notNull((Object)((Object)entity), (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6d3b\u52a8\u9884\u4ed8", (Object[])new Object[0]);
        eventPrepaymentDto = (EventPrepaymentDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, EventPrepaymentDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.adjustSubmit(eventPrepaymentDto, dto.getProcessBusiness());
    }

    @Transactional(rollbackFor={Exception.class})
    public void submit(EventPrepaymentSubmitDto dto) {
        Validate.isTrue((boolean)Objects.nonNull(dto.getProcessBusiness()), (String)"\u6d41\u7a0b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        EventPrepaymentEntity entity = (EventPrepaymentEntity)((Object)this.eventPrepaymentRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)entity), (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4fc3\u9500\u89c4\u5212", (Object[])new Object[0]);
        EventPrepaymentDto eventPrepaymentDto = (EventPrepaymentDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, EventPrepaymentDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.adjustSubmit(eventPrepaymentDto, dto.getProcessBusiness());
    }

    public List<PrepaidBySupplierVo> promotionPlan(List<GeneralExpensesVo> promotionPlanDtos) {
        ArrayList<PrepaidBySupplierVo> arrayList = new ArrayList<PrepaidBySupplierVo>();
        promotionPlanDtos.forEach(pre -> {
            PrepaidBySupplierVo prepaidBySupplierVo = new PrepaidBySupplierVo();
            prepaidBySupplierVo.setSalesOrgCode(pre.getSalesOrgCode());
            prepaidBySupplierVo.setPlatformCode(pre.getPlatformCode());
            prepaidBySupplierVo.setCustomer(pre.getCustomerName());
            prepaidBySupplierVo.setCustomerCode(pre.getCustomerCode());
            prepaidBySupplierVo.setCommerceChannel(pre.getChannelCode());
            prepaidBySupplierVo.setRequestedAmount(pre.getApplyAmount());
            prepaidBySupplierVo.setPlanningDetailsNo(pre.getExpensesCode());
            arrayList.add(prepaidBySupplierVo);
        });
        return arrayList;
    }

    public List<MaterialInformationVo> getSuppliers(List<CommercePrepaymentDto> commercePrepaymentDtos) {
        ArrayList<MaterialInformationVo> arrayList = new ArrayList<MaterialInformationVo>();
        commercePrepaymentDtos.forEach(com -> {
            MaterialInformationVo materialInformationVo = (MaterialInformationVo)this.nebulaToolkitService.copyObjectByWhiteList(com, MaterialInformationVo.class, HashSet.class, ArrayList.class, new String[0]);
            materialInformationVo.setAccountName(com.getSupplierName());
            arrayList.add(materialInformationVo);
        });
        return arrayList;
    }

    public List<MaterialInformationVo> savePurchase(List<PurchaseOrderDto> dtoList) {
        Assert.notEmpty(dtoList, (String)"\u91c7\u8d2d\u5355\u4e0d\u80fd\u4e3a\u7a7a!");
        ArrayList<MaterialInformationVo> arrayList = new ArrayList<MaterialInformationVo>();
        Map<String, PurchaseOrderDto> supplierCodesMap = dtoList.stream().filter(k -> StringUtils.isNotEmpty((CharSequence)k.getSupplierCode())).collect(Collectors.toMap(PurchaseOrderDto::getSupplierCode, v -> v, (newValue, oldValue) -> newValue));
        if (CollectionUtil.isEmpty(supplierCodesMap)) {
            return arrayList;
        }
        List byConditions = this.supplierVoService.findBySupplierCodes(new ArrayList<String>(supplierCodesMap.keySet()));
        if (CollectionUtil.isEmpty((Collection)byConditions)) {
            return arrayList;
        }
        Map<String, SupplierVo> supplierVoMap = byConditions.stream().filter(k -> StringUtils.isNotEmpty((CharSequence)k.getSupplierCode())).collect(Collectors.toMap(SupplierVo::getSupplierCode, v -> v, (newValue, oldValue) -> newValue));
        supplierCodesMap.forEach((supplierCode, vo) -> {
            SupplierVo by = (SupplierVo)supplierVoMap.get(supplierCode);
            if (Objects.nonNull(by)) {
                MaterialInformationVo materialInformationVo = (MaterialInformationVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)by, MaterialInformationVo.class, HashSet.class, ArrayList.class, new String[0]);
                materialInformationVo.setAccountName(by.getSupplierName());
                arrayList.add(materialInformationVo);
            }
        });
        return arrayList;
    }

    public void syncEventPrePaymentPushData(String body) {
        EventPrepaymentVo eventPrepaymentVo = (EventPrepaymentVo)JsonUtils.json2Obj((String)body, EventPrepaymentVo.class);
        PayInAdvanceEnum payInAdvanceEnum = PayInAdvanceEnum.codeToEnum(eventPrepaymentVo.getPrepaymentType());
        switch (payInAdvanceEnum) {
            case ACTIVITY: {
                log.info("\u3010\u6d3b\u52a8\u9884\u4ed8\u3011\u8d39\u7528\u6c60\u4e0a\u8d26");
                this.eventPrePaymentPayFeePool(eventPrepaymentVo);
                break;
            }
            case CUSTOMER: 
            case SUPPLIER: 
            case MATERIAL: {
                log.info("\u3010\u6d3b\u52a8\u9884\u4ed8\u3011\u63a8\u9001CE");
                EventPrepaymentEntity entity = new EventPrepaymentEntity();
                entity.setId(eventPrepaymentVo.getId());
                Boolean isSuccess = this.eventPrePaymentPushToCe(eventPrepaymentVo);
                if (isSuccess.booleanValue()) {
                    entity.setCeCommitStatus(CommitStatusEnum.COMMIT_SUCCESS.getCode());
                } else {
                    entity.setCeCommitStatus(CommitStatusEnum.COMMIT_FAIL.getCode());
                }
                this.eventPrepaymentRepository.updateById((Object)entity);
                break;
            }
            default: {
                throw new IllegalArgumentException("\u4e0d\u5408\u6cd5\u7684\u9884\u4ed8\u7c7b\u578b\u3010" + (Object)((Object)payInAdvanceEnum) + "");
            }
        }
    }

    public void eventPrePaymentHeadCallback(AuditCostPostingCallbackDto dto) {
        log.info("\u6d3b\u52a8\u9884\u4ed8\u7ba1\u7406 \u603b\u516c\u53f8\u56de\u8c03\u3010{}\u3011", (Object)JSON.toJSONString((Object)dto));
        List data = dto.getData();
        if (!CollectionUtils.isEmpty((Collection)data)) {
            Map map = data.stream().collect(Collectors.toMap(AuditCostPostingCallbackDataDto::getCamp_id, Function.identity()));
            Set auditUpAccountDetailCodeSet = data.stream().map(AuditCostPostingCallbackDataDto::getCamp_id).collect(Collectors.toSet());
            List prepaidBySupplierEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.prepaidBySupplierRepository.lambdaQuery().in(PrepaidBySupplierEntity::getUpAccountCode, auditUpAccountDetailCodeSet)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
            if (!CollectionUtils.isEmpty((Collection)prepaidBySupplierEntities)) {
                ArrayList<PrepaidBySupplierEntity> prepaidBySupplierUpdateList = new ArrayList<PrepaidBySupplierEntity>();
                int failCount = 0;
                for (PrepaidBySupplierEntity entity : prepaidBySupplierEntities) {
                    PrepaidBySupplierEntity supplierEntity = new PrepaidBySupplierEntity();
                    supplierEntity.setId(entity.getId());
                    AuditCostPostingCallbackDataDto auditCostPostingCallbackDataDto = (AuditCostPostingCallbackDataDto)map.get(entity.getUpAccountCode());
                    if (SucessOrFailEnum.SUCESS.getCode().equals(auditCostPostingCallbackDataDto.getFlag())) {
                        supplierEntity.setSapCommitStatus(CommitStatusEnum.COMMIT_SUCCESS.getCode());
                    } else {
                        supplierEntity.setSapCommitStatus(CommitStatusEnum.COMMIT_FAIL.getCode());
                        ++failCount;
                    }
                    prepaidBySupplierUpdateList.add(entity);
                }
                this.prepaidBySupplierRepository.updateBatchById(prepaidBySupplierUpdateList);
                PrepaidBySupplierEntity supplierEntity = (PrepaidBySupplierEntity)((Object)prepaidBySupplierEntities.get(0));
                EventPrepaymentEntity one = (EventPrepaymentEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.eventPrepaymentRepository.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(EventPrepaymentEntity::getPrepaidCoding, (Object)supplierEntity.getPrepaidCoding())).one());
                if (failCount == 0) {
                    one.setSapTransferCommitStatus(CommitStatusEnum.COMMIT_SUCCESS.getCode());
                    one.setSapTransferCommitMessage(CommitStatusEnum.COMMIT_SUCCESS.getDesc());
                } else if (failCount == data.size()) {
                    one.setSapTransferCommitStatus(CommitStatusEnum.COMMIT_FAIL.getCode());
                    one.setSapTransferCommitMessage(CommitStatusEnum.COMMIT_FAIL.getDesc());
                } else {
                    one.setSapTransferCommitStatus(CommitStatusEnum.PART_SUCCESS.getCode());
                    one.setSapTransferCommitMessage(CommitStatusEnum.PART_SUCCESS.getDesc());
                }
                this.eventPrepaymentRepository.updateById((Object)one);
            } else {
                List customerPrepaymentEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.customerPrepaymentRepository.lambdaQuery().in(CustomerPrepaymentEntity::getUpAccountCode, auditUpAccountDetailCodeSet)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
                if (CollectionUtils.isEmpty((Collection)customerPrepaymentEntities)) {
                    return;
                }
                ArrayList<CustomerPrepaymentEntity> customerPrepaymentUpdateList = new ArrayList<CustomerPrepaymentEntity>();
                int failCount = 0;
                for (CustomerPrepaymentEntity entity : customerPrepaymentEntities) {
                    CustomerPrepaymentEntity customerPrepaymentEntity = new CustomerPrepaymentEntity();
                    customerPrepaymentEntity.setId(entity.getId());
                    AuditCostPostingCallbackDataDto auditCostPostingCallbackDataDto = (AuditCostPostingCallbackDataDto)map.get(entity.getUpAccountCode());
                    if (SucessOrFailEnum.SUCESS.getCode().equals(auditCostPostingCallbackDataDto.getFlag())) {
                        customerPrepaymentEntity.setSapCommitStatus(CommitStatusEnum.COMMIT_SUCCESS.getCode());
                    } else {
                        customerPrepaymentEntity.setSapCommitStatus(CommitStatusEnum.COMMIT_FAIL.getCode());
                        ++failCount;
                    }
                    customerPrepaymentUpdateList.add(entity);
                }
                CustomerPrepaymentEntity prepaymentEntity = (CustomerPrepaymentEntity)((Object)customerPrepaymentEntities.get(0));
                EventPrepaymentEntity one = (EventPrepaymentEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.eventPrepaymentRepository.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(EventPrepaymentEntity::getPrepaidCoding, (Object)prepaymentEntity.getPrepaidCoding())).one());
                if (failCount == 0) {
                    one.setSapTransferCommitStatus(CommitStatusEnum.COMMIT_SUCCESS.getCode());
                    one.setSapTransferCommitMessage(CommitStatusEnum.COMMIT_SUCCESS.getDesc());
                } else if (failCount == data.size()) {
                    one.setSapTransferCommitStatus(CommitStatusEnum.COMMIT_FAIL.getCode());
                    one.setSapTransferCommitMessage(CommitStatusEnum.COMMIT_FAIL.getDesc());
                } else {
                    one.setSapTransferCommitStatus(CommitStatusEnum.PART_SUCCESS.getCode());
                    one.setSapTransferCommitMessage(CommitStatusEnum.PART_SUCCESS.getDesc());
                }
                this.eventPrepaymentRepository.updateById((Object)one);
            }
        }
    }

    public void eventPrePaymentSonCallback(SonAuditCostPostingCallbackDto dto) {
        log.info("\u6d3b\u52a8\u9884\u4ed8\u7ba1\u7406 \u5206\u5b50\u516c\u53f8\u56de\u8c03\u3010{}\u3011", (Object)JSON.toJSONString((Object)dto));
        List data = dto.getData();
        if (!CollectionUtils.isEmpty((Collection)data)) {
            String zftpmhxd = ((SonAuditCostPostingCallbackDataDto)data.get(0)).getZftpmhxd();
            if (!zftpmhxd.startsWith("CP")) {
                return;
            }
            Map map = data.stream().collect(Collectors.toMap(SonAuditCostPostingCallbackDataDto::getZftpmhxd, Function.identity()));
            Set auditUpAccountDetailCodeSet = data.stream().map(SonAuditCostPostingCallbackDataDto::getZftpmhxd).collect(Collectors.toSet());
            List customerPrepaymentEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.customerPrepaymentRepository.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(CustomerPrepaymentEntity::getCustomerPrepaymentDetailCode, auditUpAccountDetailCodeSet)).list();
            ArrayList<CustomerPrepaymentEntity> listUpdate = new ArrayList<CustomerPrepaymentEntity>();
            int failCount = 0;
            for (CustomerPrepaymentEntity customerPrepaymentEntity : customerPrepaymentEntities) {
                CustomerPrepaymentEntity entity = new CustomerPrepaymentEntity();
                entity.setId(customerPrepaymentEntity.getId());
                SonAuditCostPostingCallbackDataDto auditCostPostingCallbackDataDto = (SonAuditCostPostingCallbackDataDto)map.get(customerPrepaymentEntity.getCustomerPrepaymentDetailCode());
                if (SucessOrFailEnum.SUCESS.getCode().equals(auditCostPostingCallbackDataDto.getFlag())) {
                    entity.setSapCommitStatus(CommitStatusEnum.COMMIT_SUCCESS.getCode());
                } else {
                    entity.setSapCommitStatus(CommitStatusEnum.COMMIT_FAIL.getCode());
                    ++failCount;
                }
                listUpdate.add(entity);
            }
            this.customerPrepaymentRepository.updateBatchById(listUpdate);
            CustomerPrepaymentEntity prepaymentEntity = (CustomerPrepaymentEntity)((Object)customerPrepaymentEntities.get(0));
            EventPrepaymentEntity one = (EventPrepaymentEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.eventPrepaymentRepository.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(EventPrepaymentEntity::getPrepaidCoding, (Object)prepaymentEntity.getPrepaidCoding())).one());
            if (failCount == 0) {
                one.setSapTransferCommitStatus(CommitStatusEnum.COMMIT_SUCCESS.getCode());
                one.setSapTransferCommitMessage(CommitStatusEnum.COMMIT_SUCCESS.getDesc());
            } else if (failCount == data.size()) {
                one.setSapTransferCommitStatus(CommitStatusEnum.COMMIT_FAIL.getCode());
                one.setSapTransferCommitMessage(CommitStatusEnum.COMMIT_FAIL.getDesc());
            } else {
                one.setSapTransferCommitStatus(CommitStatusEnum.PART_SUCCESS.getCode());
                one.setSapTransferCommitMessage(CommitStatusEnum.PART_SUCCESS.getDesc());
            }
            this.eventPrepaymentRepository.updateById((Object)one);
        }
    }

    public void queryPaymentReceiptECStatus(PaymentReceiptQueryStatusDto paymentReceiptQueryStatusDto) {
        MqMessageVo mqMessage = new MqMessageVo();
        mqMessage.setMsgBody(JsonUtils.obj2JsonString((Object)paymentReceiptQueryStatusDto));
        mqMessage.setTag("TPM_EVENT_PRE_PAYMENT_QUERY_DATA_TAG");
        mqMessage.setTopic("TPM_EVENT_PRE_PAYMENT_QUERY_DATA_TOPIC".concat(this.rocketmqEnvironment));
        this.rocketMqProducer.sendMqMsg(mqMessage);
    }

    public void syncQueryPaymentReceiptECStatus(String body) {
        PaymentReceiptQueryStatusDto queryStatusDto = (PaymentReceiptQueryStatusDto)JSONObject.parseObject((String)body, PaymentReceiptQueryStatusDto.class);
        if (Objects.isNull(queryStatusDto)) {
            return;
        }
        Result paymentReceiptStatusResultVoResult = this.sapSdApiService.queryPaymentReceiptStatus(queryStatusDto);
        log.info("\u6d3b\u52a8\u9884\u4ed8\u5f02\u6b65\u67e5\u8be2CE\u72b6\u6001\u7ed3\u679c\uff1a\u3010{}\u3011", (Object)JSON.toJSONString((Object)paymentReceiptStatusResultVoResult));
        Validate.isTrue((boolean)Objects.nonNull(paymentReceiptStatusResultVoResult), (String)"\u67e5\u8be2CE\u72b6\u6001\u5931\u8d25", (Object[])new Object[0]);
        PaymentReceiptStatusResultVo result = (PaymentReceiptStatusResultVo)paymentReceiptStatusResultVoResult.getResult();
        List vos = JSONObject.parseArray((String)JSON.toJSONString((Object)result.getDetails()), EventPrepaymentStatusDetailVo.class);
        log.info("\u67e5\u8be2CE\u72b6\u6001\u83b7\u53d6\u4fe1\u606f\uff1a\u3010{}\u3011", (Object)JSON.toJSONString((Object)vos));
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)vos) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e", (Object[])new Object[0]);
        List codes = vos.stream().map(o -> o.getProcessInstanceId()).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.in(EventPrepaymentEntity::getPrepaidCoding, codes)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        List paymentReceipts = ((EventPrepaymentMapper)this.eventPrepaymentRepository.getBaseMapper()).selectList((Wrapper)wrapper);
        Map map = paymentReceipts.stream().collect(Collectors.toMap(EventPrepaymentEntity::getPrepaidCoding, Function.identity()));
        for (EventPrepaymentStatusDetailVo vo : vos) {
            EventPrepaymentEntity entity = (EventPrepaymentEntity)((Object)map.get(vo.getProcessInstanceId()));
            if (!Objects.nonNull((Object)entity)) continue;
            this.constructPaymentReceipt(entity, vo);
        }
        this.eventPrepaymentRepository.updateBatchById(paymentReceipts);
    }

    @Transactional
    public Map<String, String> pushEventPrepaymentToCEHandle(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u62e9\u6570\u636e", (Object[])new Object[0]);
        List<EventPrepaymentVo> eventPrepaymentVoList = this.findByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty(eventPrepaymentVoList) ? 1 : 0) != 0, (String)"\u9884\u4ed8\u5355\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        HashMap<String, String> failMap = new HashMap<String, String>();
        for (EventPrepaymentVo eventPrepaymentVo : eventPrepaymentVoList) {
            try {
                if (!StringUtils.equals((CharSequence)ProcessStatusEnum.PASS.getDictCode(), (CharSequence)eventPrepaymentVo.getProcessStatus())) {
                    failMap.put(eventPrepaymentVo.getPrepaidCoding(), "\u672a\u5ba1\u6279\u901a\u8fc7");
                    continue;
                }
                if (StringUtils.equals((CharSequence)PayInAdvanceEnum.ACTIVITY.getCode(), (CharSequence)eventPrepaymentVo.getPrepaymentType())) {
                    failMap.put(eventPrepaymentVo.getPrepaidCoding(), "\u6298\u6263\u9884\u4ed8\u4e0d\u63a8\u9001CE");
                    continue;
                }
                if (StringUtils.equals((CharSequence)CommitStatusEnum.COMMIT_SUCCESS.getCode(), (CharSequence)eventPrepaymentVo.getCeCommitStatus())) {
                    failMap.put(eventPrepaymentVo.getPrepaidCoding(), "\u4e0d\u9700\u8981\u63a8\u9001");
                    continue;
                }
                log.info("\u624b\u52a8\u63a8\u9001CE \u53c2\u6570\u3010{}\u3011", (Object)JSON.toJSONString((Object)eventPrepaymentVo));
                Boolean isSuccess = this.eventPrePaymentPushToCe(eventPrepaymentVo);
                if (!isSuccess.booleanValue()) continue;
                eventPrepaymentVo.setCeCommitStatus(CommitStatusEnum.COMMIT_SUCCESS.getCode());
                EventPrepaymentDto eventPrepaymentDto = (EventPrepaymentDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)eventPrepaymentVo, EventPrepaymentDto.class, null, null, new String[0]);
                EventPrepaymentLogEventDto logEventDto = new EventPrepaymentLogEventDto();
                logEventDto.setOriginal(eventPrepaymentDto);
                eventPrepaymentDto.setCeCommitStatus(CommitStatusEnum.COMMIT_SUCCESS.getCode());
                logEventDto.setNewest(eventPrepaymentDto);
                SerializableBiConsumer & Serializable onUpdate = EventPrepaymentLogEventListener::onUpdate;
                this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, EventPrepaymentLogEventListener.class, (SerializableBiConsumer)onUpdate);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                failMap.put(eventPrepaymentVo.getPrepaidCoding(), "\u63a8\u9001CE\u5f02\u5e38!");
            }
        }
        Collection entities = this.nebulaToolkitService.copyCollectionByWhiteList(eventPrepaymentVoList, EventPrepaymentVo.class, EventPrepaymentEntity.class, HashSet.class, ArrayList.class, new String[0]);
        this.eventPrepaymentRepository.updateBatchById(entities);
        return failMap;
    }

    public Map<String, String> pushEventPrepaymentToSAPHandle(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u62e9\u6570\u636e", (Object[])new Object[0]);
        List<EventPrepaymentVo> eventPrepaymentVoList = this.findByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty(eventPrepaymentVoList) ? 1 : 0) != 0, (String)"\u9884\u4ed8\u5355\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        HashMap<String, String> failMap = new HashMap<String, String>();
        for (EventPrepaymentVo eventPrepaymentVo : eventPrepaymentVoList) {
            if (!StringUtils.equals((CharSequence)ProcessStatusEnum.PASS.getDictCode(), (CharSequence)eventPrepaymentVo.getProcessStatus())) {
                failMap.put(eventPrepaymentVo.getPrepaidCoding(), "\u672a\u5ba1\u6279\u901a\u8fc7");
                continue;
            }
            if (!StringUtils.equals((CharSequence)PayInAdvanceEnum.ACTIVITY.getCode(), (CharSequence)eventPrepaymentVo.getPrepaymentType())) {
                failMap.put(eventPrepaymentVo.getPrepaidCoding(), "\u53ea\u63a8\u9001\u6298\u6263\u9884\u4ed8\u6570\u636e");
                continue;
            }
            if (StringUtils.equals((CharSequence)CommitStatusEnum.COMMIT_SUCCESS.getCode(), (CharSequence)eventPrepaymentVo.getCeCommitStatus())) {
                failMap.put(eventPrepaymentVo.getPrepaidCoding(), "\u4e0d\u9700\u8981\u63a8\u9001");
                continue;
            }
            log.info("\u6d3b\u52a8\u9884\u4ed8\u7ba1\u7406\u624b\u52a8\u63a8\u9001\u6298\u6263\u4e0a\u8d26 \u53c2\u6570:\u3010{}\u3011", (Object)JSON.toJSONString((Object)eventPrepaymentVo));
            this.eventPrePaymentPayFeePool(eventPrepaymentVo);
        }
        return failMap;
    }

    public List<CustomerPrepaymentVo> findTotalPrepaidAmountByDetailPlanItemList(TotalPrepaidAmountDto dto) {
        if (StringUtils.isNotEmpty((CharSequence)dto.getPrepaymentType()) && !CollectionUtils.isEmpty((Collection)dto.getDetailPlanItemCodeList())) {
            if (dto.getPrepaymentType().equals(PayInAdvanceEnum.ACTIVITY.getCode())) {
                if (BusinessUnitEnum.ONLINE.getCode().equals(dto.getBusinessUnitCode())) {
                    List voList = this.prepaidBySupplierService.findTotalPrepaidAmountByDetailPlanItemList(dto.getDetailPlanItemCodeList(), ProcessStatusEnum.PASS.getDictCode());
                    ArrayList<CustomerPrepaymentVo> result = new ArrayList<CustomerPrepaymentVo>();
                    for (PrepaidBySupplierVo vo : voList) {
                        CustomerPrepaymentVo customerPrepaymentVo = new CustomerPrepaymentVo();
                        customerPrepaymentVo.setDetailPlanItemCode(vo.getPlanningDetailsNo());
                        customerPrepaymentVo.setPrepaidAmountApplied(vo.getPrepaidAmountApplied());
                        result.add(customerPrepaymentVo);
                    }
                    return result;
                }
                return this.customerPrepaymentService.findTotalPrepaidAmountByDetailPlanItemList(dto.getDetailPlanItemCodeList(), ProcessStatusEnum.PASS.getDictCode());
            }
            if (dto.getPrepaymentType().equals(PayInAdvanceEnum.CUSTOMER.getCode())) {
                return this.customerPrepaymentService.findTotalPrepaidAmountByDetailPlanItemList(dto.getDetailPlanItemCodeList(), ProcessStatusEnum.PASS.getDictCode());
            }
            if (dto.getPrepaymentType().equals(PayInAdvanceEnum.SUPPLIER.getCode())) {
                List voList = this.prepaidBySupplierService.findTotalPrepaidAmountByDetailPlanItemList(dto.getDetailPlanItemCodeList(), ProcessStatusEnum.PASS.getDictCode());
                ArrayList<CustomerPrepaymentVo> result = new ArrayList<CustomerPrepaymentVo>();
                for (PrepaidBySupplierVo vo : voList) {
                    CustomerPrepaymentVo customerPrepaymentVo = new CustomerPrepaymentVo();
                    customerPrepaymentVo.setDetailPlanItemCode(vo.getPlanningDetailsNo());
                    customerPrepaymentVo.setPrepaidAmountApplied(vo.getPrepaidAmountApplied());
                    result.add(customerPrepaymentVo);
                }
                return result;
            }
            if (dto.getPrepaymentType().equals(PayInAdvanceEnum.MATERIAL.getCode())) {
                List byPrepaid = this.materialProcurementService.findTotalPrepaidAmountByDetailPlanItemList(dto.getDetailPlanItemCodeList(), ProcessStatusEnum.PASS.getDictCode());
                ArrayList<CustomerPrepaymentVo> result = new ArrayList<CustomerPrepaymentVo>();
                for (MaterialProcurementVo vo : byPrepaid) {
                    CustomerPrepaymentVo customerPrepaymentVo = new CustomerPrepaymentVo();
                    customerPrepaymentVo.setDetailPlanItemCode(vo.getCode());
                    customerPrepaymentVo.setPrepaidAmountApplied(vo.getPrepaidAmountApplied());
                    result.add(customerPrepaymentVo);
                }
                return result;
            }
        }
        return new ArrayList<CustomerPrepaymentVo>();
    }

    public List<CustomerPrepaymentVo> findActivityPrepaymentByDetailPlanItemCodes(List<String> detailPlanItemCodes) {
        if (CollectionUtils.isEmpty(detailPlanItemCodes)) {
            return Lists.newArrayList();
        }
        return this.eventPrepaymentRepository.findActivityPrepaymentByDetailPlanItemCodes(detailPlanItemCodes);
    }

    public List<String> findProcessDateByActivityDetailCodes(String detailPlanItemCode) {
        if (StringUtils.isEmpty((CharSequence)detailPlanItemCode)) {
            return Lists.newArrayList();
        }
        List<Date> processDate = this.eventPrepaymentRepository.findProcessDateByActivityDetailCodes(detailPlanItemCode);
        if (CollectionUtils.isEmpty(processDate)) {
            return Lists.newArrayList();
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return processDate.stream().map(df::format).collect(Collectors.toList());
    }

    private void constructPaymentReceipt(EventPrepaymentEntity receipt, EventPrepaymentStatusDetailVo vo) {
        receipt.setCeProcessStatus(vo.getProcessStatus());
        receipt.setEasOrderId(vo.getEasOrderId());
        receipt.setFlowId(vo.getFlowId());
        receipt.setPayAccountCode(vo.getPayAccountCode());
        receipt.setEasCode(vo.getEasCode());
        receipt.setEasDesc(vo.getEasDesc());
        receipt.setEasMessage(vo.getEasMsg());
        receipt.setPaySuccessDate(vo.getPaySuccessDate());
        receipt.setSapVoucherNo(vo.getFkVoucherNo());
    }

    private Boolean eventPrePaymentPushToCe(EventPrepaymentVo eventPrepaymentVo) {
        log.info("\u3010\u6d3b\u52a8\u9884\u4ed8\u3011\u63a8\u9001CE eventPrePaymentPushToCe \u53c2\u6570\u3010{}\u3011", (Object)JSON.toJSONString((Object)eventPrepaymentVo));
        PaymentReceiptApplyDto paymentReceiptApplyDto = new PaymentReceiptApplyDto();
        PaymentReceiptHeadDto headDto = new PaymentReceiptHeadDto();
        headDto.setDataFrom("4");
        headDto.setIsStartProcess(BooleanEnum.FALSE.getCapital());
        headDto.setOutDocument(eventPrepaymentVo.getPrepaidCoding());
        headDto.setBukrs(eventPrepaymentVo.getCompanyCode());
        headDto.setTitle("300204");
        String profitCenterCode = eventPrepaymentVo.getProfitCenterCode();
        if (StringUtils.isNotEmpty((CharSequence)profitCenterCode) && profitCenterCode.startsWith("000000")) {
            profitCenterCode = profitCenterCode.replace("000000", "");
        }
        headDto.setPrctr(profitCenterCode);
        String expItm = eventPrepaymentVo.getBusinessExpItem();
        if (StringUtils.isNotBlank((CharSequence)expItm)) {
            String[] split = expItm.split("--");
            expItm = split[1];
        }
        headDto.setExpItem(expItm);
        headDto.setExpItemTxt(eventPrepaymentVo.getBusinessExpItem());
        headDto.setCurrency(eventPrepaymentVo.getTradeCurrency());
        headDto.setRate(new BigDecimal(eventPrepaymentVo.getExchangeRate()).setScale(2, 1));
        headDto.setCreatedBy(eventPrepaymentVo.getOperatorWorkNo());
        headDto.setApplicantNo(eventPrepaymentVo.getOperatorWorkNo());
        headDto.setPayType(eventPrepaymentVo.getPaymentMethod());
        headDto.setUseamtDept(eventPrepaymentVo.getAuditDepart());
        headDto.setApprAmount(eventPrepaymentVo.getCurrentAmount());
        headDto.setHasContract(eventPrepaymentVo.getWhetherContract());
        headDto.setDescription(eventPrepaymentVo.getExpenseContent());
        paymentReceiptApplyDto.setHead(headDto);
        List materialInformation = eventPrepaymentVo.getMaterialInformation();
        ArrayList<PaymentReceiptFeeDetailDto> fees = new ArrayList<PaymentReceiptFeeDetailDto>();
        ArrayList<PaymentReceiptDetailDto> details = new ArrayList<PaymentReceiptDetailDto>();
        if (!CollectionUtils.isEmpty((Collection)materialInformation)) {
            for (int i = 0; i < materialInformation.size(); ++i) {
                PaymentReceiptFeeDetailDto paymentReceiptFeeDetailDto = new PaymentReceiptFeeDetailDto();
                MaterialInformationVo materialInformationVo = (MaterialInformationVo)materialInformation.get(i);
                paymentReceiptFeeDetailDto.setSeq(Integer.valueOf(i + 1));
                paymentReceiptFeeDetailDto.setReserve(materialInformationVo.getId());
                paymentReceiptFeeDetailDto.setAccountType("K");
                paymentReceiptFeeDetailDto.setLifnr(materialInformationVo.getSupplierCode());
                paymentReceiptFeeDetailDto.setLifnrTxt(materialInformationVo.getSupplierName());
                paymentReceiptFeeDetailDto.setBankl(materialInformationVo.getUnionPayBankCard());
                paymentReceiptFeeDetailDto.setBanka(materialInformationVo.getBankAccount());
                paymentReceiptFeeDetailDto.setBankn(materialInformationVo.getBankCard());
                paymentReceiptFeeDetailDto.setKoinh(materialInformationVo.getAccountName());
                paymentReceiptFeeDetailDto.setPayAmount(materialInformationVo.getPrepaidAmount() == null ? BigDecimal.ZERO : materialInformationVo.getPrepaidAmount());
                paymentReceiptFeeDetailDto.setHopePayDate(materialInformationVo.getExpectedDate() == null ? null : DateUtil.formatDate((Date)materialInformationVo.getExpectedDate()));
                paymentReceiptFeeDetailDto.setContract(materialInformationVo.getContractNo());
                paymentReceiptFeeDetailDto.setContractName(materialInformationVo.getContractName());
                fees.add(paymentReceiptFeeDetailDto);
                PaymentReceiptDetailDto paymentReceiptDetailDto = new PaymentReceiptDetailDto();
                paymentReceiptDetailDto.setSeq(Integer.valueOf(i + 1));
                paymentReceiptDetailDto.setReserve(materialInformationVo.getId());
                paymentReceiptDetailDto.setPaymentDesc(materialInformationVo.getPaymentDigest());
                paymentReceiptDetailDto.setPaymentDescTxt(materialInformationVo.getPaymentDigest());
                paymentReceiptDetailDto.setAmount(materialInformationVo.getPrepaidAmount() == null ? BigDecimal.ZERO : materialInformationVo.getPrepaidAmount());
                String profitCenterCodeDetail = materialInformationVo.getProfitCenter();
                if (StringUtils.isNotEmpty((CharSequence)profitCenterCodeDetail) && profitCenterCodeDetail.startsWith("000000")) {
                    profitCenterCodeDetail = profitCenterCodeDetail.replace("000000", "");
                }
                paymentReceiptDetailDto.setPrctr(profitCenterCodeDetail);
                paymentReceiptDetailDto.setReason(materialInformationVo.getReasonCode());
                paymentReceiptDetailDto.setReasonTxt(materialInformationVo.getReasonName());
                paymentReceiptDetailDto.setFundOutputProject(materialInformationVo.getCapitalOutflowProject());
                paymentReceiptDetailDto.setFundOutputProjectTxt(materialInformationVo.getCapitalOutflowProjectName());
                details.add(paymentReceiptDetailDto);
            }
        }
        paymentReceiptApplyDto.setFees(fees);
        paymentReceiptApplyDto.setDetails(details);
        log.info("\u6d3b\u52a8\u9884\u4ed8\u7ba1\u7406\u63a8\u9001CE\u63a5\u53e3\u5f00\u59cb \u53c2\u6570\u3010{}\u3011", (Object)JSON.toJSONString((Object)paymentReceiptApplyDto));
        Result receiptResultVoResult = this.sapSdApiService.pushPaymentReceipt(paymentReceiptApplyDto);
        log.info("\u6d3b\u52a8\u9884\u4ed8\u7ba1\u7406\u63a8\u9001CE\u63a5\u53e3\u7ed3\u675f \u54cd\u5e94\u3010{}\u3011", (Object)JSON.toJSONString((Object)receiptResultVoResult));
        if (receiptResultVoResult.isSuccess()) {
            PaymentReceiptResultVo result = (PaymentReceiptResultVo)receiptResultVoResult.getResult();
            if (StringUtils.equals((CharSequence)result.getMsgCode(), (CharSequence)RequestCERespCodeEnum.SUCCESS.getCode())) {
                log.info("\u63a8\u9001CE\u63a5\u53e3\u6210\u529f");
                Optional<String> stringOptional = Optional.ofNullable(receiptResultVoResult.getResult()).map(x -> x.getProcessInstanceId());
                stringOptional.ifPresent(x -> {
                    eventPrepaymentVo.setReturnDocCode(x);
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.eventPrepaymentRepository.lambdaUpdate().eq(UuidEntity::getId, (Object)eventPrepaymentVo.getId())).set(EventPrepaymentEntity::getReturnDocCode, x)).update();
                });
                return Boolean.TRUE;
            }
            log.info("\u63a8\u9001CE\u63a5\u53e3\u5931\u8d25");
        }
        return Boolean.FALSE;
    }

    private void eventPrePaymentPayFeePool(EventPrepaymentVo vo) {
        log.info("\u6d3b\u52a8\u9884\u4ed8\u4e0a\u8d26\u8d39\u7528\u6c60 \u3010{}\u3011", (Object)JSON.toJSONString((Object)vo));
        Assert.hasLength((String)vo.getBusinessUnitCode(), (String)("\u6d3b\u52a8\u9884\u4ed8[" + vo.getPrepaidCoding() + "]\u4e1a\u52a1\u5355\u5143\u4e3a\u7a7a!"));
        BusinessUnitEnum businessUnitEnum = BusinessUnitEnum.codeToEnum((String)vo.getBusinessUnitCode());
        Assert.notNull((Object)businessUnitEnum, (String)("\u4e1a\u52a1\u5355\u5143[" + vo.getBusinessUnitCode() + "]\u4e0d\u5408\u6cd5!"));
        switch (businessUnitEnum) {
            case SON_COMPANY: 
            case VERTICAL: {
                this.auditUpAccountSonCompany(vo);
                break;
            }
            case HEADQUARTERS: 
            case ONLINE: {
                this.auditUpAccountHeadquarters(vo);
                break;
            }
            default: {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7c7b\u578b\u3010" + businessUnitEnum + "\u3011\uff0c\u8bf7\u68c0\u67e5");
            }
        }
    }

    private void auditUpAccountHeadquarters(EventPrepaymentVo eventPrepaymentVo) {
        BusinessUnitEnum businessUnitEnum = BusinessUnitEnum.codeToEnum((String)eventPrepaymentVo.getBusinessUnitCode());
        switch (businessUnitEnum) {
            case HEADQUARTERS: {
                this.headUpAccount(eventPrepaymentVo);
                break;
            }
            case ONLINE: {
                this.onlineUpAccount(eventPrepaymentVo);
                break;
            }
            default: {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7c7b\u578b\u3010" + businessUnitEnum + "\u3011\uff0c\u8bf7\u68c0\u67e5");
            }
        }
    }

    private void headUpAccount(EventPrepaymentVo eventPrepaymentVo) {
        log.info("\u6d3b\u52a8\u9884\u4ed8\u4e3b\u4f53\u4e0a\u8d26 \u3010\u4e3b\u4f53\u3011");
        AuditFeeUpAccountDto auditFeeUpAccountDto = new AuditFeeUpAccountDto();
        AuditFeeUpAccountDto.MessageHeader messageHeader = new AuditFeeUpAccountDto.MessageHeader();
        messageHeader.setMESSAGEID(UuidCrmUtil.general());
        messageHeader.setINTERFACE("SI_TPM70_EXPENSES_HQ_ASYN_OUT");
        messageHeader.setSENDER("TPM");
        messageHeader.setSENDTIME(String.valueOf(System.currentTimeMillis()));
        messageHeader.setRECEIVER("ECC");
        List customerPrepayment = eventPrepaymentVo.getCustomerPrepayment();
        List customerCodes = customerPrepayment.stream().map(o -> o.getCustomerCode()).collect(Collectors.toList());
        Map<Object, Object> customerVoMap = new HashMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(customerCodes)) {
            List customerVoList = this.customerVoService.findByCustomerCodes(new ArrayList(customerCodes));
            customerVoMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
        }
        auditFeeUpAccountDto.setMessageHeader(messageHeader);
        ArrayList<AuditFeeUpAccountDto.Item1> item1List = new ArrayList<AuditFeeUpAccountDto.Item1>();
        for (CustomerPrepaymentVo customerPrepaymentVo : customerPrepayment) {
            AuditFeeUpAccountDto.Item1 item1 = new AuditFeeUpAccountDto.Item1();
            CustomerVo customerVo = (CustomerVo)customerVoMap.get(customerPrepaymentVo.getCustomerCode());
            if (Objects.isNull(customerVo)) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.eventPrepaymentRepository.lambdaUpdate().eq(EventPrepaymentEntity::getPrepaidCoding, (Object)eventPrepaymentVo.getPrepaidCoding())).set(EventPrepaymentEntity::getSapTransferCommitMessage, (Object)("\u672a\u67e5\u8be2\u5230\u5ba2\u6237\u7f16\u7801\u3010" + customerPrepaymentVo.getCustomerCode() + "\u3011\u7684\u4fe1\u606f"))).set(EventPrepaymentEntity::getSapTransferCommitStatus, (Object)CommitStatusEnum.COMMIT_FAIL.getCode())).update();
                return;
            }
            item1.setKUNNR(customerVo.getErpCode());
            item1.setCAMP_ID(customerPrepaymentVo.getUpAccountCode());
            item1.setMATNR(customerPrepaymentVo.getProductCode());
            item1.setZFLAG("A");
            item1.setVKBUR(customerVo.getSalesRegionErpCode());
            item1.setVKORG(customerVo.getSalesInstitutionErpCode());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            try {
                item1.setZFQSRQ(DateUtil.format((Date)sdf.parse(customerPrepaymentVo.getActivityBeginDate()), (String)"yyyyMMdd"));
                item1.setZFJSRQ(DateUtil.format((Date)sdf.parse(customerPrepaymentVo.getActivityEndDate()), (String)"yyyyMMdd"));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            item1.setKSCHL(null);
            item1.setDMBTR(customerPrepaymentVo.getPrepaidAmount().toPlainString());
            item1.setWAERS("CNY");
            ActivityFormVo activityFormVo = this.activityFormService.findOneByCode(customerPrepaymentVo.getActivityFormCode());
            if (Objects.isNull(activityFormVo)) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.eventPrepaymentRepository.lambdaUpdate().eq(EventPrepaymentEntity::getPrepaidCoding, (Object)eventPrepaymentVo.getPrepaidCoding())).set(EventPrepaymentEntity::getSapTransferCommitMessage, (Object)("\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u3010" + customerPrepaymentVo.getActivityFormCode() + "\u3011\u672a\u627e\u5230"))).set(EventPrepaymentEntity::getSapTransferCommitStatus, (Object)CommitStatusEnum.COMMIT_FAIL.getCode())).update();
                return;
            }
            item1.setCAMP_DES(activityFormVo.getSapCode());
            item1.setVKGRP(customerVo.getSalesOrgErpCode());
            item1List.add(item1);
        }
        auditFeeUpAccountDto.setITEM1(item1List);
        this.sapSdApiService.auditFeeUpAccount(auditFeeUpAccountDto);
    }

    private void onlineUpAccount(EventPrepaymentVo eventPrepaymentVo) {
        log.info("\u6d3b\u52a8\u9884\u4ed8\u7535\u5546\u4e0a\u8d26 \u3010\u4e3b\u4f53\u3011");
        AuditFeeUpAccountDto auditFeeUpAccountDto = new AuditFeeUpAccountDto();
        AuditFeeUpAccountDto.MessageHeader messageHeader = new AuditFeeUpAccountDto.MessageHeader();
        messageHeader.setMESSAGEID(UuidCrmUtil.general());
        messageHeader.setINTERFACE("SI_TPM70_EXPENSES_HQ_ASYN_OUT");
        messageHeader.setSENDER("TPM");
        messageHeader.setSENDTIME(String.valueOf(System.currentTimeMillis()));
        messageHeader.setRECEIVER("ECC");
        auditFeeUpAccountDto.setMessageHeader(messageHeader);
        List prepaidBySupplierVos = eventPrepaymentVo.getPrepaidBySupplier();
        List customerCodes = prepaidBySupplierVos.stream().map(o -> o.getCustomerCode()).collect(Collectors.toList());
        Map<Object, Object> customerVoMap = new HashMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(customerCodes)) {
            List customerVoList = this.customerVoService.findByCustomerCodes(new ArrayList(customerCodes));
            customerVoMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
        }
        List detailCodes = prepaidBySupplierVos.stream().map(o -> o.getPlanningDetailsNo()).collect(Collectors.toList());
        List generalExpensesDtos = this.generalExpensesService.findByDetailCodeList(detailCodes);
        Map generalExpensesDtoMap = generalExpensesDtos.stream().collect(Collectors.toMap(ExpensesDto::getExpensesCode, Function.identity()));
        ArrayList<AuditFeeUpAccountDto.Item1> item1List = new ArrayList<AuditFeeUpAccountDto.Item1>();
        for (PrepaidBySupplierVo prepaidBySupplierVo : prepaidBySupplierVos) {
            AuditFeeUpAccountDto.Item1 item1 = new AuditFeeUpAccountDto.Item1();
            CustomerVo customerVo = (CustomerVo)customerVoMap.get(prepaidBySupplierVo.getCustomerCode());
            GeneralExpensesDto generalExpensesDto = (GeneralExpensesDto)generalExpensesDtoMap.get(prepaidBySupplierVo.getPlanningDetailsNo());
            if (Objects.isNull(customerVo)) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.eventPrepaymentRepository.lambdaUpdate().eq(EventPrepaymentEntity::getPrepaidCoding, (Object)eventPrepaymentVo.getPrepaidCoding())).set(EventPrepaymentEntity::getSapTransferCommitMessage, (Object)("\u672a\u67e5\u8be2\u5230\u5ba2\u6237\u7f16\u7801\u3010" + prepaidBySupplierVo.getCustomerCode() + "\u3011\u7684\u4fe1\u606f"))).set(EventPrepaymentEntity::getSapTransferCommitStatus, (Object)CommitStatusEnum.COMMIT_FAIL.getCode())).update();
                return;
            }
            item1.setKUNNR(customerVo.getErpCode());
            item1.setCAMP_ID(prepaidBySupplierVo.getUpAccountCode());
            item1.setMATNR(generalExpensesDto.getProductCode());
            item1.setZFLAG("A");
            item1.setVKBUR(customerVo.getSalesRegionErpCode());
            item1.setVKORG(customerVo.getSalesInstitutionErpCode());
            item1.setZFQSRQ(generalExpensesDto.getStartDate() == null ? null : DateUtil.format((Date)generalExpensesDto.getStartDate(), (String)"yyyyMMdd"));
            item1.setZFJSRQ(generalExpensesDto.getEndDate() == null ? null : DateUtil.format((Date)generalExpensesDto.getEndDate(), (String)"yyyyMMdd"));
            item1.setKSCHL(null);
            item1.setDMBTR(prepaidBySupplierVo.getPrepaidAmount().toPlainString());
            item1.setWAERS("CNY");
            ActivityFormVo activityFormVo = this.activityFormService.findOneByCode(generalExpensesDto.getActivityFormCode());
            if (Objects.isNull(activityFormVo)) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.eventPrepaymentRepository.lambdaUpdate().eq(EventPrepaymentEntity::getPrepaidCoding, (Object)eventPrepaymentVo.getPrepaidCoding())).set(EventPrepaymentEntity::getSapTransferCommitMessage, (Object)("\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u3010" + generalExpensesDto.getActivityFormCode() + "\u3011\u672a\u627e\u5230"))).set(EventPrepaymentEntity::getSapTransferCommitStatus, (Object)CommitStatusEnum.COMMIT_FAIL.getCode())).update();
                return;
            }
            item1.setCAMP_DES(activityFormVo.getSapCode());
            item1.setVKGRP(customerVo.getSalesOrgErpCode());
            item1List.add(item1);
        }
        auditFeeUpAccountDto.setITEM1(item1List);
        this.sapSdApiService.auditFeeUpAccount(auditFeeUpAccountDto);
    }

    private void auditUpAccountSonCompany(EventPrepaymentVo eventPrepaymentVo) {
        List activityFormVoList;
        log.info("\u6d3b\u52a8\u9884\u4ed8\u4e0a\u8d26 \u3010\u5206\u5b50\u516c\u53f8\u3011");
        AuditFeeUpAccountSonCompanyDto auditFeeUpAccountSonCompanyDto = new AuditFeeUpAccountSonCompanyDto();
        AuditFeeUpAccountSonCompanyDto.MessageHeader messageHeader = new AuditFeeUpAccountSonCompanyDto.MessageHeader();
        messageHeader.setMESSAGEID(UuidCrmUtil.general());
        messageHeader.setINTERFACE("SI_TPM80_HXFYSZ_FGS_ASYN_OUT");
        messageHeader.setSENDER("TPM");
        messageHeader.setSENDTIME(String.valueOf(System.currentTimeMillis()));
        messageHeader.setRECEIVER("ECC");
        auditFeeUpAccountSonCompanyDto.setMessageHeader(messageHeader);
        List customerPrepayment = eventPrepaymentVo.getCustomerPrepayment();
        List customerCodes = customerPrepayment.stream().map(CustomerPrepaymentVo::getCustomerCode).collect(Collectors.toList());
        Map<Object, Object> customerVoMap = new HashMap();
        if (CollectionUtil.isNotEmpty(customerCodes)) {
            if (StringUtils.equals((CharSequence)eventPrepaymentVo.getBusinessUnitCode(), (CharSequence)BusinessUnitEnum.SON_COMPANY.getCode())) {
                List customerMdgCodes = this.customerVoService.findByCustomerMdgCodes(new ArrayList(customerCodes));
                Map<String, List<CustomerVo>> customerVoListMap = customerMdgCodes.stream().collect(Collectors.groupingBy(CustomerVo::getErpCode));
                for (CustomerPrepaymentVo prepaymentVo : customerPrepayment) {
                    List<CustomerVo> customerVos = customerVoListMap.get(prepaymentVo.getCustomerCode());
                    if (CollectionUtil.isEmpty(customerVos)) continue;
                    log.info("\u67e5\u8be2\u5230\u7684\u5ba2\u6237[{}]\u4fe1\u606f\u3010{}\u3011", (Object)prepaymentVo.getCustomerCode(), (Object)JSON.toJSONString(customerVos));
                    List customerVo = customerVos.stream().filter(o -> StringUtils.equals((CharSequence)o.getCustomerChannelCode(), (CharSequence)prepaymentVo.getChannelCode()) && StringUtils.equals((CharSequence)o.getBusinessFormatCode(), (CharSequence)eventPrepaymentVo.getBusinessFormatCode()) && StringUtils.equals((CharSequence)o.getSalesInstitutionCode(), (CharSequence)prepaymentVo.getSalesOrgCode())).collect(Collectors.toList());
                    if (CollectionUtil.isEmpty(customerVo)) continue;
                    customerVoMap.put(prepaymentVo.getCustomerCode(), customerVo.get(0));
                }
            } else {
                List customerVoList = this.customerVoService.findByCustomerCodes(new ArrayList(customerCodes));
                customerVoMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
            }
        }
        ArrayList<AuditFeeUpAccountSonCompanyDto.Item1> item1List = new ArrayList<AuditFeeUpAccountSonCompanyDto.Item1>();
        List dictDataVoList = this.dictDataVoService.findByDictTypeCode("mdm_business_format");
        HashMap dictDataVoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty((Collection)dictDataVoList)) {
            dictDataVoMap.putAll(dictDataVoList.stream().filter(k -> StringUtils.isNotEmpty((CharSequence)k.getDictCode())).collect(Collectors.toMap(DictDataVo::getDictCode, v -> v, (newValue, oldValue) -> newValue)));
        }
        List activityFormCodeList = customerPrepayment.stream().filter(k -> StringUtils.isNotEmpty((CharSequence)k.getActivityFormCode())).map(CustomerPrepaymentVo::getActivityFormCode).distinct().collect(Collectors.toList());
        HashMap activityFormVoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(activityFormCodeList) && CollectionUtil.isNotEmpty((Collection)(activityFormVoList = this.activityFormService.findByCodes(activityFormCodeList)))) {
            activityFormVoMap.putAll(activityFormVoList.stream().filter(k -> StringUtils.isNotEmpty((CharSequence)k.getActivityFormCode())).collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, v -> v, (newValue, oldValue) -> newValue)));
        }
        for (CustomerPrepaymentVo item : customerPrepayment) {
            AuditFeeUpAccountSonCompanyDto.Item1 item1 = new AuditFeeUpAccountSonCompanyDto.Item1();
            item1.setZFTPMHXD(item.getCustomerPrepaymentDetailCode());
            item1.setZFHXDLX("ZSC1");
            CustomerVo customerVo = (CustomerVo)customerVoMap.get(item.getCustomerCode());
            if (Objects.isNull(customerVo)) {
                String errorMsg = "\u672a\u67e5\u8be2\u5230\u5ba2\u6237\u7f16\u7801\u3010" + item.getCustomerCode() + "\u3011\u7684\u4fe1\u606f";
                this.eventPrepaymentRepository.updateSapTransferCommitMessage(eventPrepaymentVo, errorMsg);
                return;
            }
            item1.setKUNNR(customerVo.getErpCode());
            item1.setZFAMT1(item.getPrepaidAmount() == null ? "0" : item.getPrepaidAmount().abs().toPlainString());
            Calendar now = Calendar.getInstance();
            item1.setGJAHR(String.valueOf(now.get(1)));
            item1.setMONAT(String.valueOf(now.get(2) + 1));
            item1.setVKORG(customerVo.getSalesInstitutionErpCode());
            item1.setVTWEG(customerVo.getCustomerChannelCode());
            if (BusinessUnitEnum.VERTICAL.getCode().equals(eventPrepaymentVo.getBusinessUnitCode())) {
                item1.setZFCXHD(item.getActivityDetailItemCode());
                item1.setZFCXHDI(item.getActivityDetailItemCode() + "0001");
            } else if (BusinessUnitEnum.SON_COMPANY.getCode().equals(eventPrepaymentVo.getBusinessUnitCode())) {
                item1.setZFCXHD(StringUtils.substring((String)item.getActivityDetailItemCode(), (int)0, (int)(item.getActivityDetailItemCode().length() - 4)));
                item1.setZFCXHDI(item.getActivityDetailItemCode());
            }
            ActivityFormVo activityFormVo = (ActivityFormVo)activityFormVoMap.get(item.getActivityFormCode());
            if (Objects.isNull(activityFormVo)) {
                String errorMsg = "\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u3010" + item.getActivityFormCode() + "\u3011\u672a\u627e\u5230";
                this.eventPrepaymentRepository.updateSapTransferCommitMessage(eventPrepaymentVo, errorMsg);
                return;
            }
            item1.setZFCXXS(activityFormVo.getSapCode());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            try {
                item1.setZFHDBEGIN(DateUtil.format((Date)sdf.parse(item.getActivityBeginDate()), (String)"yyyyMMdd"));
                item1.setZFHDEND(DateUtil.format((Date)sdf.parse(item.getActivityEndDate()), (String)"yyyyMMdd"));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            DictDataVo businessFormatCodeVo = (DictDataVo)dictDataVoMap.get(eventPrepaymentVo.getBusinessFormatCode());
            if (Objects.isNull(businessFormatCodeVo)) {
                String errorMsg = "\u672a\u67e5\u8be2\u5230\u4e1a\u6001\u3010" + eventPrepaymentVo.getBusinessFormatCode() + "\u3011\u7684\u6570\u636e\u5b57\u5178";
                this.eventPrepaymentRepository.updateSapTransferCommitMessage(eventPrepaymentVo, errorMsg);
                return;
            }
            Map extendMap = businessFormatCodeVo.getExtendMap();
            if (extendMap != null) {
                String zfyt = (String)extendMap.get("ZFYT");
                item1.setZFYT(zfyt);
            }
            item1.setZKHYF(null);
            item1.setZKHMS(null);
            item1.setMATNR(null);
            item1.setZFPP(null);
            item1.setZFPL(null);
            item1.setZFPX(null);
            item1.setZFHDLD(null);
            item1.setZFMED(null);
            item1List.add(item1);
        }
        auditFeeUpAccountSonCompanyDto.setITEM1(item1List);
        this.sapSdApiService.auditFeeUpAccountSonCompany(auditFeeUpAccountSonCompanyDto);
    }

    private void adjustSubmit(EventPrepaymentDto dto, ProcessBusinessDto processBusiness) {
        processBusiness.setBusinessNo(dto.getPrepaidCoding());
        JSONObject jsonObject = JsonUtils.toJSONObject((Object)dto);
        processBusiness.setBusinessFormJson(jsonObject.toJSONString());
        processBusiness.setBusinessCode("event_prepayment_process");
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        EventPrepaymentEntity entity = new EventPrepaymentEntity();
        entity.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
        entity.setProcessInstanceId(processBusinessVo.getProcessNo());
        entity.setId(dto.getId());
        this.eventPrepaymentRepository.updateById((Object)entity);
    }

    private void createValidate(EventPrepaymentDto eventPrepaymentDto) {
        Validate.notNull((Object)eventPrepaymentDto, (String)"\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)eventPrepaymentDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)eventPrepaymentDto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)eventPrepaymentDto.getPrepaymentType(), (String)"\u9884\u4ed8\u7c7b\u578b\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)eventPrepaymentDto.getPrepaymentName(), (String)"\u9884\u4ed8\u540d\u79f0\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)eventPrepaymentDto.getPrepaymentDate(), (String)"\u9884\u4ed8\u5e74\u6708\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (!eventPrepaymentDto.getPrepaymentType().equals(PayInAdvanceEnum.ACTIVITY.getCode())) {
            Validate.notBlank((CharSequence)eventPrepaymentDto.getCompanyCode(), (String)"\u516c\u53f8\u7f16\u7801\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)eventPrepaymentDto.getBusinessTitle(), (String)"\u4e1a\u52a1\u5927\u7c7b\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)eventPrepaymentDto.getProfitCenter(), (String)"\u5229\u6da6\u4e2d\u5fc3\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)eventPrepaymentDto.getBusinessExpItem(), (String)"\u4e1a\u52a1\u7ec6\u7c7b\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)eventPrepaymentDto.getTradeCurrency(), (String)"\u4ea4\u6613\u8d27\u5e01\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)eventPrepaymentDto.getExchangeRate(), (String)"\u6c47\u7387\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)eventPrepaymentDto.getOperatorWorkNo(), (String)"\u7ecf\u529e\u4eba\u5de5\u53f7\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)eventPrepaymentDto.getReimburserWorkNo(), (String)"\u62a5\u8d26\u4eba\u5de5\u53f7\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)eventPrepaymentDto.getPaymentMethod(), (String)"\u4ed8\u6b3e\u65b9\u5f0f\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)eventPrepaymentDto.getAuditDepart(), (String)"FSSC\u5ba1\u6838\u90e8\u95e8\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)eventPrepaymentDto.getExpenseContent(), (String)"\u5f00\u652f\u5185\u5bb9\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
    }

    private void checkPrepaidAmount(EventPrepaymentDto eventPrepaymentDto) {
        if (!CollectionUtils.isEmpty((Collection)eventPrepaymentDto.getCustomerPrepayment())) {
            for (CustomerPrepaymentDto customerPrepaymentDto : eventPrepaymentDto.getCustomerPrepayment()) {
                if (Objects.isNull(customerPrepaymentDto.getPrepaidAmount()) || customerPrepaymentDto.getPrepaidAmount().compareTo(BigDecimal.ZERO) >= 0) continue;
                customerPrepaymentDto.setPrepaidAmount(BigDecimal.ZERO);
            }
        }
    }
}

