/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.event.prepayment.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.event.prepayment.local.entity.MaterialProcurementEntity;
import com.biz.crm.tpm.business.event.prepayment.local.repository.MaterialProcurementRepository;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.MaterialProcurementDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.log.MaterialProcurementLogEventDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.event.MaterialProcurementLogEventListener;
import com.biz.crm.tpm.business.event.prepayment.sdk.service.MaterialProcurementService;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.MaterialProcurementVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service(value="materialProcurementService")
public class MaterialProcurementServiceImpl
implements MaterialProcurementService {
    @Autowired(required=false)
    private MaterialProcurementRepository materialProcurementRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Transactional(rollbackFor={Exception.class})
    public void create(List<MaterialProcurementDto> list, String code) {
        Assert.hasLength((String)code, (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notEmpty(list, (String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a!");
        list.forEach(e -> {
            Assert.notNull((Object)e, (String)"\u660e\u7ec6\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!");
            Assert.hasLength((String)e.getCode(), (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        });
        List<String> codeList = list.stream().filter(k -> StringUtils.isNotEmpty((CharSequence)k.getCode())).map(MaterialProcurementDto::getCode).collect(Collectors.toList());
        List<MaterialProcurementEntity> existEntityList = this.materialProcurementRepository.findByActivityDetailItemCodeListAndProcessStatus(codeList, ProcessStatusEnum.PASS.getDictCode());
        if (!CollectionUtils.isEmpty(existEntityList)) {
            throw new UnsupportedOperationException("\u5df2\u4e0b\u91c7\u8d2d\u5355\u6570\u636e\u5b58\u5728\u672a\u5ba1\u6279\u901a\u8fc7\u7684\u9884\u4ed8\u6570\u636e\uff1a" + JSON.toJSONString(existEntityList.stream().map(MaterialProcurementEntity::getCode).collect(Collectors.toList())));
        }
        HashMap amountMap = Maps.newHashMap();
        List<MaterialProcurementEntity> hasPrepaidList = this.materialProcurementRepository.findByCodeList(codeList);
        if (CollectionUtil.isNotEmpty(hasPrepaidList)) {
            amountMap.putAll(hasPrepaidList.stream().filter(k -> StringUtils.isNotEmpty((CharSequence)k.getCode())).filter(k -> Objects.nonNull(k.getPrepaidAmount())).collect(Collectors.groupingBy(MaterialProcurementEntity::getCode, Collectors.reducing(BigDecimal.ZERO, MaterialProcurementEntity::getPrepaidAmount, BigDecimal::add))));
        }
        list.forEach(e -> {
            e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            e.setTenantCode(TenantUtils.getTenantCode());
            e.setPrepaidCoding(code);
            e.setPrepaidAmountApplied(amountMap.getOrDefault(e.getCode(), BigDecimal.ZERO));
        });
        Collection entities = this.nebulaToolkitService.copyCollectionByWhiteList(list, MaterialProcurementDto.class, MaterialProcurementEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.materialProcurementRepository.saveOrUpdateBatch(entities);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List materialProcurementEntities = this.materialProcurementRepository.listByIds(ids);
        Validate.notEmpty((Collection)materialProcurementEntities, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u4e3b\u952e\u96c6\u5408\u4fe1\u606f\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u6570\u636e", (Object[])new Object[0]);
        this.materialProcurementRepository.removeByIds(ids);
        Collection dtoList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)materialProcurementEntities, MaterialProcurementEntity.class, MaterialProcurementDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable onDelete = MaterialProcurementLogEventListener::onDelete;
        for (MaterialProcurementDto dto : dtoList) {
            MaterialProcurementLogEventDto logEventDto = new MaterialProcurementLogEventDto();
            logEventDto.setOriginal(dto);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, MaterialProcurementLogEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(List<MaterialProcurementDto> list, String code) {
        List<String> idListDto = list.stream().filter(e -> e.getId() != null).map(e -> e.getId()).collect(Collectors.toList());
        this.materialProcurementRepository.deleteByIdNotInList(idListDto, code);
        if (!CollectionUtils.isEmpty(list)) {
            Collection entities = this.nebulaToolkitService.copyCollectionByWhiteList(list, MaterialProcurementDto.class, MaterialProcurementEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            entities.forEach(e -> {
                e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                e.setTenantCode(TenantUtils.getTenantCode());
                e.setPrepaidCoding(code);
            });
            this.materialProcurementRepository.saveOrUpdateBatch(entities);
        }
    }

    public MaterialProcurementVo findById(String id) {
        MaterialProcurementEntity materialProcurementEntity = (MaterialProcurementEntity)((Object)this.materialProcurementRepository.getById((Serializable)((Object)id)));
        if (materialProcurementEntity == null) {
            return null;
        }
        return (MaterialProcurementVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)materialProcurementEntity, MaterialProcurementVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public MaterialProcurementVo findByPrepaidCoding(String prepaidCoding) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"prepaid_coding", (Object)prepaidCoding);
        MaterialProcurementEntity materialProcurementEntity = (MaterialProcurementEntity)((Object)this.materialProcurementRepository.getOne((Wrapper)wrapper));
        return (MaterialProcurementVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)materialProcurementEntity, MaterialProcurementVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public List<MaterialProcurementVo> findByPrepaid(String prepaid) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"prepaid_coding", (Object)prepaid);
        List list = this.materialProcurementRepository.list((Wrapper)wrapper);
        Collection materialProcurementVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, MaterialProcurementEntity.class, MaterialProcurementVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return new ArrayList<MaterialProcurementVo>(materialProcurementVos);
    }

    public List<MaterialProcurementVo> findTotalPrepaidAmountByDetailPlanItemList(List<String> detailPlanItemCodeList, String processCode) {
        return this.materialProcurementRepository.findTotalPrepaidAmountByDetailPlanItemList(detailPlanItemCodeList, processCode);
    }
}

