/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.event.prepayment.local.workFlowListener;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.event.prepayment.local.entity.EventPrepaymentEntity;
import com.biz.crm.tpm.business.event.prepayment.local.repository.EventPrepaymentRepository;
import com.biz.crm.tpm.business.event.prepayment.sdk.event.EventPerpaymentEventListener;
import com.biz.crm.tpm.business.event.prepayment.sdk.service.EventPrepaymentService;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.EventPrepaymentVo;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.bizunited.nebula.common.util.JsonUtils;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class EventPrepaymentProcessCallBackListener
implements ProcessCompleteListener {
    private static final Logger log = LoggerFactory.getLogger(EventPrepaymentProcessCallBackListener.class);
    @Autowired(required=false)
    private EventPrepaymentRepository eventPrepaymentRepository;
    @Autowired
    private EventPrepaymentService eventPrepaymentService;
    @Autowired(required=false)
    private List<EventPerpaymentEventListener> eventListeners;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;

    public String getBusinessCode() {
        return "event_prepayment_process";
    }

    @Transactional(rollbackFor={Exception.class})
    public void onProcessComplete(ProcessStatusDto dto) {
        String processStatus = dto.getProcessStatus();
        EventPrepaymentEntity one = (EventPrepaymentEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.eventPrepaymentRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(EventPrepaymentEntity::getPrepaidCoding, (Object)dto.getBusinessNo())).one());
        Validate.notNull((Object)((Object)one), (String)"\u4fc3\u9500\u89c4\u5212\u5ba1\u6279\u6d41\u7a0b\u56de\u8c03\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u5f53\u524d\u5b9e\u4f8b", (Object[])new Object[0]);
        EventPrepaymentVo eventPrepaymentVo = this.eventPrepaymentService.findByPrepaidCoding(one.getPrepaidCoding());
        eventPrepaymentVo.setProcessStatus(processStatus);
        one.setProcessStatus(processStatus);
        log.info("\u6d3b\u52a8\u9884\u4ed8\u6d41\u7a0b\u7ed3\u675f \u53c2\u6570\u3010{}\u3011", (Object)JSON.toJSONString((Object)dto));
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            Date dateNow = new Date();
            MqMessageVo mqMessage = new MqMessageVo();
            one.setProcessDate(dateNow);
            eventPrepaymentVo.setProcessDate(dateNow);
            mqMessage.setMsgBody(JsonUtils.obj2JsonString((Object)eventPrepaymentVo));
            mqMessage.setTag("TPM_EVENT_PRE_PAYMENT_PUSH_DATA_TAG");
            mqMessage.setTopic("TPM_EVENT_PRE_PAYMENT_PUSH_DATA_TOPIC".concat(RocketMqUtil.mqEnvironment()));
            this.rocketMqProducer.sendMqMsg(mqMessage, 10L);
        }
        this.eventPrepaymentRepository.updateById((Object)one);
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            for (EventPerpaymentEventListener listener : this.eventListeners) {
                listener.onUpdateProcessStatus(processStatus, (List)Lists.newArrayList((Object[])new EventPrepaymentVo[]{eventPrepaymentVo}));
            }
        }
    }
}

