/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.examine.circular.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.constant.CommonConstant;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DataTooLongGenerateRespUtil;
import com.biz.crm.tpm.business.examine.circular.local.entity.TpmExamineCircularEntity;
import com.biz.crm.tpm.business.examine.circular.local.listener.TpmExamineCircularProcessCallBackListener;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.TpmExamineCircularDto;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.TpmExamineCircularProcessSubmitDto;
import com.biz.crm.tpm.business.examine.circular.sdk.service.TpmExamineCircularService;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.TpmExamineCircularRespVo;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/examine/circular"})
@Api(tags={"TPM-\u8003\u6838\u901a\u62a5"})
public class TpmExamineCircularController {
    private static final Logger log = LoggerFactory.getLogger(TpmExamineCircularController.class);
    @Autowired(required=false)
    private TpmExamineCircularService tpmExamineCircularService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private TpmExamineCircularProcessCallBackListener tpmExamineCircularProcessCallBackListener;

    @PostMapping(value={"findByConditions"})
    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5217\u8868\u6570\u636e")
    public Result<Page<TpmExamineCircularRespVo>> findByConditions(Pageable pageable, @RequestBody TpmExamineCircularDto dto) {
        try {
            if (StringUtils.isEmpty((CharSequence)dto.getDelFlag())) {
                dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            }
            return Result.ok((Object)this.tpmExamineCircularService.findByConditions(pageable, dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"findPageForOut"})
    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5217\u8868\u6570\u636e")
    public Result<Page<TpmExamineCircularRespVo>> findPageForOut(@ApiParam(name="pageable") Pageable pageable, TpmExamineCircularDto dto) {
        try {
            return Result.ok((Object)this.tpmExamineCircularService.findPageForOut(pageable, dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"findById"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u8be6\u60c5")
    public Result<TpmExamineCircularRespVo> findById(@RequestParam(value="id") String id) {
        try {
            return Result.ok((Object)this.tpmExamineCircularService.findById(id));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"findByProcessNo"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u7f16\u7801\u67e5\u8be2\u8be6\u60c5(\u4ec5\u8003\u6838\u901a\u62a5\u4e3a\u5355\u6761\u63d0\u4ea4\u65f6\u53ef\u7528)")
    public Result<TpmExamineCircularRespVo> findByProcessNo(@RequestParam(value="processNo") String processNo) {
        try {
            return Result.ok((Object)this.tpmExamineCircularService.findByProcessNo(processNo));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"create"})
    @ApiOperation(value="\u521b\u5efa\u8003\u6838\u901a\u62a5")
    public Result<TpmExamineCircularRespVo> create(@RequestBody TpmExamineCircularDto dto) {
        try {
            TpmExamineCircularRespVo respVo = this.tpmExamineCircularService.create(dto);
            if (!respVo.getIsBalanceEnough().booleanValue()) {
                Result result = new Result();
                result.setResult((Object)respVo);
                result.setMessage("\u8d39\u7528\u6c60\u4f59\u989d\u4e0d\u8db3\uff01\u5f53\u524d\u4f59\u989d:\u3010" + respVo.getFeePoolBalance().toPlainString() + "\u3011");
                result.setCode(CommonConstant.SC_OK_200);
                result.setSuccess(Boolean.TRUE.booleanValue());
                return result;
            }
            return Result.ok((Object)respVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)DataTooLongGenerateRespUtil.generateRespStr((Exception)e, TpmExamineCircularEntity.class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"createAndSubmit"})
    @ApiOperation(value="\u521b\u5efa\u8003\u6838\u901a\u62a5\u5e76\u63d0\u4ea4\u5ba1\u6279")
    public Result<TpmExamineCircularRespVo> createAndSubmit(@RequestBody TpmExamineCircularProcessSubmitDto dto) {
        boolean lockSuccess = false;
        boolean processLock = false;
        String id = "";
        try {
            if (StringUtils.isBlank((CharSequence)dto.getCacheKey())) {
                throw new RuntimeException("cacheKey\u4e3a\u7a7a\uff01");
            }
            String lockKey = "examine_circular_create_update:lock:" + dto.getCacheKey();
            lockSuccess = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 1L);
            if (!lockSuccess) {
                throw new RuntimeException("\u6570\u636e\u6b63\u5728\u4fdd\u6301\u4e2d,\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
            }
            TpmExamineCircularRespVo respVo = this.tpmExamineCircularService.createAndSubmit(dto);
            if (!respVo.getIsBalanceEnough().booleanValue()) {
                Result result = new Result();
                result.setResult((Object)respVo);
                result.setMessage("\u8d39\u7528\u6c60\u4f59\u989d\u4e0d\u8db3\uff01\u5f53\u524d\u4f59\u989d:\u3010" + respVo.getFeePoolBalance().toPlainString() + "\u3011");
                result.setCode(CommonConstant.SC_OK_200);
                result.setSuccess(Boolean.TRUE.booleanValue());
                Result result2 = result;
                return result2;
            }
            Result result = Result.ok((Object)new TpmExamineCircularRespVo());
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (processLock) {
                this.redisLockService.unlock("examine_circular_process:lock:" + id);
            }
            if (lockSuccess) {
                this.redisLockService.unlock("examine_circular_create_update:lock:" + dto.getCacheKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PatchMapping(value={"edit"})
    @ApiOperation(value="\u7f16\u8f91\u8003\u6838\u901a\u62a5")
    public Result<TpmExamineCircularRespVo> edit(@RequestBody TpmExamineCircularDto dto) {
        boolean lock = false;
        try {
            Validate.notNull((Object)dto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            lock = this.redisLockService.tryLock("examine_circular_create_update:lock:" + dto.getId(), TimeUnit.HOURS, 1L);
            if (!lock) {
                throw new RuntimeException("\u6570\u636e\u6b63\u5728\u4fdd\u5b58\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
            }
            TpmExamineCircularRespVo respVo = this.tpmExamineCircularService.edit(dto);
            if (!respVo.getIsBalanceEnough().booleanValue()) {
                Result result = new Result();
                result.setResult((Object)respVo);
                result.setMessage("\u8d39\u7528\u6c60\u4f59\u989d\u4e0d\u8db3\uff01\u5f53\u524d\u4f59\u989d:\u3010" + respVo.getFeePoolBalance().toPlainString() + "\u3011");
                result.setCode(CommonConstant.SC_OK_200);
                result.setSuccess(Boolean.TRUE.booleanValue());
                Result result2 = result;
                return result2;
            }
            Result result = Result.ok((Object)respVo);
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)DataTooLongGenerateRespUtil.generateRespStr((Exception)e, TpmExamineCircularEntity.class));
            return result;
        }
        finally {
            if (lock) {
                this.redisLockService.unlock("examine_circular_create_update:lock:" + dto.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"editPos"})
    @ApiOperation(value="\u7f16\u8f91\u8003\u6838\u901a\u62a5")
    public Result<TpmExamineCircularRespVo> editPos(@RequestBody TpmExamineCircularDto dto) {
        boolean lock = false;
        try {
            Validate.notNull((Object)dto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            lock = this.redisLockService.tryLock("examine_circular_create_update:lock:" + dto.getId(), TimeUnit.HOURS, 1L);
            if (!lock) {
                throw new RuntimeException("\u6570\u636e\u6b63\u5728\u4fdd\u5b58\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
            }
            TpmExamineCircularRespVo respVo = this.tpmExamineCircularService.edit(dto);
            if (!respVo.getIsBalanceEnough().booleanValue()) {
                Result result = new Result();
                result.setResult((Object)respVo);
                result.setMessage("\u8d39\u7528\u6c60\u4f59\u989d\u4e0d\u8db3\uff01\u5f53\u524d\u4f59\u989d:\u3010" + respVo.getFeePoolBalance().toPlainString() + "\u3011");
                result.setCode(CommonConstant.SC_OK_200);
                result.setSuccess(Boolean.TRUE.booleanValue());
                Result result2 = result;
                return result2;
            }
            Result result = Result.ok((Object)respVo);
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lock) {
                this.redisLockService.unlock("examine_circular_create_update:lock:" + dto.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PatchMapping(value={"editAndSubmit"})
    @ApiOperation(value="\u7f16\u8f91\u5e76\u63d0\u4ea4\u8003\u6838\u901a\u62a5")
    public Result<TpmExamineCircularRespVo> editAndSubmit(@RequestBody TpmExamineCircularProcessSubmitDto dto) {
        boolean lockSuccess = false;
        boolean processLock = false;
        try {
            if (StringUtils.isBlank((CharSequence)dto.getId())) {
                throw new RuntimeException("\u8bf7\u9009\u62e9\u6570\u636e\uff01");
            }
            String lockKey = "examine_circular_create_update:lock:" + dto.getId();
            lockSuccess = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 1L);
            if (!lockSuccess) {
                throw new RuntimeException("\u6570\u636e\u6b63\u5728\u4fdd\u5b58\u4e2d,\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
            }
            TpmExamineCircularRespVo respVo = this.tpmExamineCircularService.edit((TpmExamineCircularDto)dto);
            if (StringUtils.isNotBlank((CharSequence)dto.getId())) {
                dto.setIds((List)Lists.newArrayList((Object[])new String[]{dto.getId()}));
                processLock = this.redisLockService.tryLock("examine_circular_process:lock:" + dto.getId(), TimeUnit.HOURS, 1L);
                if (!processLock) {
                    throw new RuntimeException("\u6570\u636e\u4fdd\u5b58\u6210\u529f,\u63d0\u4ea4\u5ba1\u6279\u65f6\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u65b0\u63d0\u4ea4\uff01");
                }
                this.tpmExamineCircularService.submitApproval(dto);
            }
            if (!respVo.getIsBalanceEnough().booleanValue()) {
                Result result = new Result();
                result.setResult((Object)respVo);
                result.setMessage("\u8d39\u7528\u6c60\u4f59\u989d\u4e0d\u8db3\uff01\u5f53\u524d\u4f59\u989d:\u3010" + respVo.getFeePoolBalance().toPlainString() + "\u3011");
                result.setCode(CommonConstant.SC_OK_200);
                result.setSuccess(Boolean.TRUE.booleanValue());
                Result result2 = result;
                return result2;
            }
            Result result = Result.ok((Object)respVo);
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (processLock) {
                this.redisLockService.unlock("examine_circular_process:lock:" + dto.getId());
            }
            if (lockSuccess) {
                this.redisLockService.unlock("examine_circular_create_update:lock:" + dto.getId());
            }
        }
    }

    @DeleteMapping(value={"delete"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u8003\u6838\u901a\u62a5")
    public Result<?> deleteByIdList(@RequestParam(value="ids") List<String> ids) {
        try {
            this.tpmExamineCircularService.deleteByIdList(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"deletePos"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u8003\u6838\u901a\u62a5")
    public Result<?> deletePos(@RequestParam(value="ids") List<String> ids) {
        try {
            this.tpmExamineCircularService.deleteByIdList(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PatchMapping(value={"enable"})
    @ApiOperation(value="\u542f\u7528\u8003\u6838\u901a\u62a5")
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.tpmExamineCircularService.enable(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PatchMapping(value={"disable"})
    @ApiOperation(value="\u7981\u7528\u8003\u6838\u901a\u62a5")
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.tpmExamineCircularService.disable(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"submitApproval"})
    @ApiOperation(value="\u63d0\u4ea4\u5ba1\u6279", notes="")
    public Result<?> submitApproval(@RequestBody TpmExamineCircularProcessSubmitDto submitDto) {
        boolean lockSuccess = false;
        List ids = submitDto.getIds();
        try {
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)ids) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u62e9\u63d0\u4ea4\u6570\u636e!", (Object[])new Object[0]);
            lockSuccess = this.redisLockService.batchLock("examine_circular_process:lock:", ids, TimeUnit.HOURS, 1);
            Validate.isTrue((boolean)lockSuccess, (String)"\u6570\u636e\u52a0\u9501\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5!", (Object[])new Object[0]);
            TpmExamineCircularRespVo respVo = this.tpmExamineCircularService.submitApproval(submitDto);
            if (!respVo.getIsBalanceEnough().booleanValue()) {
                Result result = new Result();
                result.setResult((Object)respVo);
                result.setMessage("\u8d39\u7528\u6c60\u4f59\u989d\u4e0d\u8db3\uff01\u5f53\u524d\u4f59\u989d:\u3010" + respVo.getFeePoolBalance().toPlainString() + "\u3011");
                result.setCode(CommonConstant.SC_OK_200);
                result.setSuccess(Boolean.TRUE.booleanValue());
                Result result2 = result;
                return result2;
            }
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.batchUnLock("examine_circular_process:lock:", ids);
            }
        }
    }

    @PostMapping(value={"onProcessComplete"})
    @ApiOperation(value="\u5ba1\u6279\u56de\u8c03", notes="")
    public Result<?> onProcessComplete(@RequestBody ProcessStatusDto dto) {
        try {
            this.tpmExamineCircularService.onProcessComplete(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"onProcessCompleteListener"})
    @ApiOperation(value="\u5ba1\u6279\u56de\u8c03(Listener)", notes="")
    public Result<?> onProcessCompleteListener(@RequestBody ProcessStatusDto dto) {
        try {
            this.tpmExamineCircularProcessCallBackListener.onProcessComplete(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"calSplitMap"})
    @ApiOperation(value="\u5206\u644a\u8ba1\u7b97", notes="")
    public Result<?> calSplitMap(@ApiParam(name="TpmExamineCircularDto", value="\u8003\u52e4\u901a\u62a5\u5206\u644a\u53c2\u6570") @RequestBody TpmExamineCircularDto dto, @ApiParam(name="cacheKey", value="\u7f13\u5b58key(UUID+\u4e1a\u52a1\u5355\u5143\u7f16\u7801)") @RequestParam String cacheKey) {
        try {
            return Result.ok((Object)this.tpmExamineCircularService.calSplitMap(dto, cacheKey));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u52a8\u63a8\u9001\u8d39\u7528\u6c60")
    @PostMapping(value={"/pushEventPrepaymentToFeelPoolHandle"})
    public Result<?> pushEventPrepaymentToFeelPoolHandle(@ApiParam(name="id", value="\u8003\u6838\u6263\u6b3eID") @RequestBody List<String> ids) {
        try {
            Map map = this.tpmExamineCircularService.pushEventPrepaymentToFeelPoolHandle(ids);
            if (Objects.nonNull(map) && !map.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry entry : map.entrySet()) {
                    sb.append("[").append((String)entry.getKey()).append("]:").append((String)entry.getValue()).append("\n");
                }
                return Result.error((String)sb.toString());
            }
            return Result.ok();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u79fb\u52a8\u7aef\u8003\u6838\u901a\u62a5\u5ba1\u6279\u67e5\u8be2")
    @PostMapping(value={"/mobileExamineCircularApproved"})
    public Result<?> mobileExamineCircularApproved(@RequestParam(value="processNo") String processNo) {
        try {
            return Result.ok((Object)this.tpmExamineCircularService.mobileExamineCircularApproved(processNo));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Result.error((String)e.getMessage());
        }
    }
}

