/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.examine.circular.local.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastService;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastVo;
import com.biz.crm.tpm.business.examine.circular.local.entity.TpmExamineCircularEntity;
import com.biz.crm.tpm.business.examine.circular.local.entity.TpmExamineCircularProductSplitEntity;
import com.biz.crm.tpm.business.examine.circular.local.mapper.TpmExamineCircularProductSplitEntityMapper;
import com.biz.crm.tpm.business.examine.circular.local.repository.TpmExamineCircularEntityRepository;
import com.biz.crm.tpm.business.examine.circular.sdk.constant.TpmExamineCircularRelationTypeEnum;
import com.biz.crm.tpm.business.examine.circular.sdk.constant.TpmExamineCircularSplitTypeEnum;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.TpmExamineCircularDto;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.TpmExamineCircularLogDto;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.TpmExamineCircularProductSplitDto;
import com.biz.crm.tpm.business.examine.circular.sdk.event.TpmExamineCircularLogEventListener;
import com.biz.crm.tpm.business.examine.circular.sdk.service.TpmExamineCircularService;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.TpmExamineCircularImportVo;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import liquibase.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class TpmExamineCircularImportHandler
implements ImportProcess<TpmExamineCircularImportVo> {
    private static final Logger log = LoggerFactory.getLogger(TpmExamineCircularImportHandler.class);
    @Autowired(required=false)
    private TpmExamineCircularService tpmExamineCircularService;
    @Autowired(required=false)
    private TpmExamineCircularProductSplitEntityMapper tpmExamineCircularProductSplitEntityMapper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private TpmExamineCircularLogEventListener tpmExamineCircularLogEventListener;
    @Autowired(required=false)
    private TpmExamineCircularEntityRepository tpmExamineCircularEntityRepository;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private CustomerRetailerVoService customerRetailerVoService;
    @Autowired(required=false)
    private SubComBudgetForecastService subComBudgetForecastService;

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, TpmExamineCircularImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Map<Object, Object> errorMap = Maps.newHashMap();
        try {
            errorMap = this.examineCircularImportSave(data);
        }
        catch (Exception e) {
            log.error("TPM-\u8003\u6838\u901a\u62a5\u5bfc\u5165\u5931\u8d25");
            log.error("", (Throwable)e);
        }
        return errorMap;
    }

    private Map<Integer, String> examineCircularImportSave(LinkedHashMap<Integer, TpmExamineCircularImportVo> data) {
        List activityFormVoList;
        List productVoList;
        List customerVoList;
        List salesOrgVoList;
        log.info("\u8003\u6838\u901a\u62a5\u5bfc\u5165\uff0c\u53c2\u6570\u3010{}\u3011", (Object)JSON.toJSONString(data));
        HashMap<Integer, String> errorMap = new HashMap<Integer, String>();
        this.importSaveValidation(data, errorMap);
        if (!errorMap.isEmpty()) {
            return errorMap;
        }
        this.descToCode(data, errorMap);
        Set productCodeSet = data.values().stream().filter(k -> StringUtil.isNotEmpty((String)k.getProductCode())).map(TpmExamineCircularImportVo::getProductCode).collect(Collectors.toSet());
        Set customerCodeSet = data.values().stream().filter(k -> StringUtil.isNotEmpty((String)k.getCustomerCode())).map(TpmExamineCircularImportVo::getCustomerCode).collect(Collectors.toSet());
        Set activityFormSet = data.values().stream().filter(k -> StringUtil.isNotEmpty((String)k.getActivityForm())).map(TpmExamineCircularImportVo::getActivityForm).collect(Collectors.toSet());
        log.info("\u8003\u6838\u901a\u62a5\u5bfc\u5165\uff0c\u5ba2\u6237\u7f16\u7801:{}", (Object)JSON.toJSONString(customerCodeSet));
        List salesOrgCodeList = data.values().stream().filter(k -> StringUtil.isNotEmpty((String)k.getSalesOrgCode())).map(TpmExamineCircularImportVo::getSalesOrgCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        HashMap salesOrgVoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(salesOrgCodeList) && CollectionUtil.isNotEmpty((Collection)(salesOrgVoList = this.salesOrgVoService.findBySalesOrgCodes(salesOrgCodeList)))) {
            salesOrgVoMap.putAll(salesOrgVoList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, v -> v, (n, o) -> n)));
        }
        HashMap customerVoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(customerCodeSet) && CollectionUtil.isNotEmpty((Collection)(customerVoList = this.customerVoService.findByCustomerCodes(new ArrayList(customerCodeSet))))) {
            customerVoMap.putAll(customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, v -> v, (n, o) -> n)));
        }
        HashMap productVoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(productCodeSet) && CollectionUtil.isNotEmpty((Collection)(productVoList = this.productVoService.findByProductCodes(new ArrayList(productCodeSet))))) {
            productVoMap.putAll(productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, v -> v, (n, o) -> n)));
        }
        HashMap activityFormVoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(activityFormSet) && CollectionUtil.isNotEmpty((Collection)(activityFormVoList = this.activityFormService.findActivityFormByCode(activityFormSet)))) {
            activityFormVoMap.putAll(activityFormVoList.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, v -> v, (n, o) -> n)));
        }
        this.setImportAndValBudgetMsg(errorMap, data);
        HashMap<Integer, TpmExamineCircularImportVo> budgetMap = new HashMap<Integer, TpmExamineCircularImportVo>();
        HashMap<Integer, TpmExamineCircularImportVo> feePoolMap = new HashMap<Integer, TpmExamineCircularImportVo>();
        this.setImportBaseMsg(customerVoMap, productVoMap, activityFormVoMap, salesOrgVoMap, errorMap, data, budgetMap, feePoolMap);
        if (!errorMap.isEmpty()) {
            return errorMap;
        }
        log.info("\u9519\u8bef\u4fe1\u606f{}", (Object)errorMap.size());
        ArrayList<TpmExamineCircularDto> dtos = new ArrayList<TpmExamineCircularDto>();
        if (CollectionUtil.isNotEmpty(budgetMap)) {
            dtos.addAll(this.nebulaToolkitService.copyCollectionByWhiteList(budgetMap.values(), TpmExamineCircularImportVo.class, TpmExamineCircularDto.class, HashSet.class, ArrayList.class, new String[0]));
        }
        if (CollectionUtil.isNotEmpty(feePoolMap)) {
            List<TpmExamineCircularDto> circularDtos = this.importHandleFeePoolRelation(feePoolMap, errorMap);
            dtos.addAll(circularDtos);
        }
        if (!errorMap.isEmpty()) {
            log.error("\u8003\u6838\u901a\u62a5\u5bfc\u5165\u5931\u8d25,errorMap:{}", (Object)errorMap.size());
            return errorMap;
        }
        this.importInsert(dtos);
        log.info("\u8003\u6838\u901a\u62a5\u5bfc\u5165\u6210\u529f,\u6210\u529f\u6761\u6570:\u3010{}\u3011,\u5931\u8d25\u6761\u6570\u3010{}\u3011", (Object)dtos.size(), (Object)errorMap.size());
        return errorMap;
    }

    private void setImportAndValBudgetMsg(Map<Integer, String> errorMap, Map<Integer, TpmExamineCircularImportVo> data) {
        List subComBudgetForecastVos;
        List unionListByCodes;
        Map<Object, Object> monthBudgetVoMap = new HashMap();
        Set budgetCodeSet = data.values().stream().filter(o -> !StringUtils.equals((CharSequence)BusinessUnitEnum.SON_COMPANY.getCode(), (CharSequence)o.getBusinessUnitCode())).filter(o -> StringUtil.isNotEmpty((String)o.getBudgetCode())).map(TpmExamineCircularImportVo::getBudgetCode).collect(Collectors.toSet());
        Map<Object, Object> subComBudgetForecastVoMap = new HashMap();
        Set sonCompanyBudgetCodeSet = data.values().stream().filter(o -> StringUtils.equals((CharSequence)BusinessUnitEnum.SON_COMPANY.getCode(), (CharSequence)o.getBusinessUnitCode())).filter(o -> StringUtil.isNotEmpty((String)o.getBudgetCode())).map(TpmExamineCircularImportVo::getBudgetCode).collect(Collectors.toSet());
        if (CollectionUtil.isNotEmpty(budgetCodeSet) && CollectionUtil.isNotEmpty((Collection)(unionListByCodes = this.monthBudgetService.findUnionListByCodes(new ArrayList(budgetCodeSet))))) {
            monthBudgetVoMap = unionListByCodes.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity()));
        }
        if (CollectionUtil.isNotEmpty(sonCompanyBudgetCodeSet) && CollectionUtil.isNotEmpty((Collection)(subComBudgetForecastVos = this.subComBudgetForecastService.findListByCodes(new ArrayList(sonCompanyBudgetCodeSet))))) {
            subComBudgetForecastVoMap = subComBudgetForecastVos.stream().collect(Collectors.toMap(SubComBudgetForecastVo::getBudgetForecastCode, Function.identity()));
        }
        for (Map.Entry<Integer, TpmExamineCircularImportVo> entry : data.entrySet()) {
            TpmExamineCircularImportVo importVo = entry.getValue();
            Integer index = entry.getKey();
            ArrayList<String> errorMsgList = new ArrayList<String>();
            if (StringUtil.isEmpty((String)importVo.getBudgetCode())) continue;
            if (StringUtils.equals((CharSequence)BusinessUnitEnum.SON_COMPANY.getCode(), (CharSequence)importVo.getBusinessUnitCode())) {
                SubComBudgetForecastVo subComBudgetForecastVo = (SubComBudgetForecastVo)subComBudgetForecastVoMap.get(importVo.getBudgetCode());
                if (Objects.isNull(subComBudgetForecastVo)) {
                    errorMsgList.add("\u3010" + importVo.getBudgetCode() + "\u3011,\u8be5\u5206\u5b50\u9884\u7b97\u7f16\u7801\u4e0d\u5b58\u5728!");
                } else {
                    importVo.setBudgetProjectCode(subComBudgetForecastVo.getBudgetItemCode());
                    importVo.setBudgetProjectName(subComBudgetForecastVo.getBudgetItemName());
                }
            } else {
                MonthBudgetVo monthBudgetVo = (MonthBudgetVo)monthBudgetVoMap.get(importVo.getBudgetCode());
                if (Objects.isNull(monthBudgetVo)) {
                    errorMsgList.add("\u3010" + importVo.getBudgetCode() + "\u3011,\u8be5\u9884\u7b97\u7f16\u7801\u4e0d\u5b58\u5728!");
                } else {
                    importVo.setBudgetProjectCode(monthBudgetVo.getBudgetItemCode());
                    importVo.setBudgetProjectName(monthBudgetVo.getBudgetItemName());
                }
            }
            if (!CollectionUtil.isNotEmpty(errorMsgList)) continue;
            errorMap.put(index, errorMap.getOrDefault(index, "") + "||" + String.join((CharSequence)"||", errorMsgList));
        }
    }

    private void setImportBaseMsg(Map<String, CustomerVo> customerVoMap, Map<String, ProductVo> productVoMap, Map<String, ActivityFormVo> activityFormVoMap, Map<String, SalesOrgVo> salesOrgVoMap, Map<Integer, String> errorMap, LinkedHashMap<Integer, TpmExamineCircularImportVo> data, Map<Integer, TpmExamineCircularImportVo> budgetMap, Map<Integer, TpmExamineCircularImportVo> feePoolMap) {
        data.forEach((index, importVo) -> {
            ArrayList<String> errorMsgList = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)importVo.getSalesOrgCode())) {
                SalesOrgVo salesOrgVo = (SalesOrgVo)salesOrgVoMap.get(importVo.getSalesOrgCode());
                if (Objects.isNull(salesOrgVo)) {
                    errorMsgList.add("\u3010" + importVo.getSalesOrgErpCode() + "\u3011,\u8be5\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u4fe1\u606f\u4e0d\u5b58\u5728!");
                } else {
                    importVo.setSalesOrgCode(salesOrgVo.getSalesOrgCode());
                    importVo.setSalesOrgErpCode(salesOrgVo.getErpCode());
                    importVo.setSalesOrgName(salesOrgVo.getSalesOrgName());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)importVo.getCustomerCode())) {
                CustomerVo customerVo = (CustomerVo)customerVoMap.get(importVo.getCustomerCode());
                if (customerVo == null) {
                    errorMsgList.add("\u3010" + importVo.getCustomerCode() + "\u3011,\u8be5\u5ba2\u6237\u7f16\u7801\u4fe1\u606f\u4e0d\u5b58\u5728!");
                } else {
                    importVo.setCustomerName(customerVo.getCustomerName());
                    importVo.setCustomerCode(customerVo.getCustomerCode());
                    importVo.setMdgCustomerCode(customerVo.getErpCode());
                    importVo.setSalesDepartmentCode(customerVo.getSalesRegionCode());
                    importVo.setSalesDepartmentName(customerVo.getSalesRegionName());
                    importVo.setSalesGroupCode(customerVo.getSalesOrgCode());
                    importVo.setSalesGroupName(customerVo.getSalesOrgName());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)importVo.getActivityForm())) {
                ActivityFormVo activityFormVo = (ActivityFormVo)activityFormVoMap.get(importVo.getActivityForm());
                if (activityFormVo == null) {
                    errorMsgList.add("\u3010" + importVo.getActivityForm() + "\u3011,\u8be5\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u4fe1\u606f\u4e0d\u5b58\u5728!");
                } else {
                    importVo.setActivityForm(activityFormVo.getActivityFormCode());
                    importVo.setActivitySapForm(activityFormVo.getSapCode());
                    importVo.setActivityFormName(activityFormVo.getActivityFormName());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)importVo.getProductCode())) {
                ProductVo productVo = (ProductVo)productVoMap.get(importVo.getProductCode());
                if (productVo == null) {
                    errorMsgList.add("\u3010" + importVo.getProductCode() + "\u3011,\u8be5\u4ea7\u54c1\u7f16\u7801\u4fe1\u606f\u4e0d\u5b58\u5728!");
                } else {
                    importVo.setProductName(productVo.getProductName());
                    importVo.setProductBrandCode(productVo.getProductBrandCode());
                    importVo.setProductBrandName(productVo.getProductBrandName());
                    importVo.setProductLevelCode(productVo.getProductCategoryCode());
                    importVo.setProductLevelName(productVo.getProductCategoryName());
                    importVo.setSubProductLevelCode(productVo.getProductLevelCode());
                    importVo.setSubProductLevelName(productVo.getProductLevelName());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)importVo.getRelationType())) {
                TpmExamineCircularRelationTypeEnum relationTypeEnum = TpmExamineCircularRelationTypeEnum.codeToEnum((String)importVo.getRelationType());
                if (Objects.isNull(relationTypeEnum)) {
                    errorMsgList.add("\u672a\u77e5\u7684\u5173\u8054\u7c7b\u578b'" + importVo.getRelationTypeDesc() + "'");
                } else {
                    switch (relationTypeEnum) {
                        case BUDGET_RELATION: {
                            budgetMap.put((Integer)index, (TpmExamineCircularImportVo)importVo);
                            break;
                        }
                        case FEE_POOL_RELATION: 
                        case FEE_POOL_RELATION_AND_BUDGET: {
                            feePoolMap.put((Integer)index, (TpmExamineCircularImportVo)importVo);
                            break;
                        }
                        default: {
                            errorMsgList.add("\u9519\u8bef\u7684\u5173\u8054\u7c7b\u578b");
                        }
                    }
                }
            } else {
                errorMsgList.add("\u5173\u8054\u7c7b\u578b\u4e0d\u5b58\u5728");
            }
            if (CollectionUtil.isNotEmpty(errorMsgList)) {
                errorMap.put((Integer)index, errorMap.getOrDefault(index, "") + "||" + String.join((CharSequence)"||", errorMsgList));
            }
        });
    }

    private void descToCode(LinkedHashMap<Integer, TpmExamineCircularImportVo> data, Map<Integer, String> errorMap) {
        ArrayList dictTypeCodeList = Lists.newArrayList((Object[])new String[]{"MDM_CUSTOMIZE_ORG", "mdm_business_format", "mdm_business_unit", "examine_circular_relation_type", "examine_circular_examine_type", "examine_circular_split_type_new"});
        Map typeCodeMap = this.dictDataVoService.findByDictTypeCodeList((List)dictTypeCodeList);
        List regionDictType = (List)typeCodeMap.get("MDM_CUSTOMIZE_ORG");
        Map<String, String> map = regionDictType.stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode));
        List businessFormatDict = (List)typeCodeMap.get("mdm_business_format");
        Map<String, String> businessFormatMap = businessFormatDict.stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode));
        List businessUnitDict = (List)typeCodeMap.get("mdm_business_unit");
        Map<String, String> businessUnitDictMap = businessUnitDict.stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode));
        List relationTypeDict = (List)typeCodeMap.get("examine_circular_relation_type");
        Map<String, String> relationTypeMap = relationTypeDict.stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode));
        List examineTypeDictVos = (List)typeCodeMap.get("examine_circular_examine_type");
        Map<String, String> examineTypeMap = examineTypeDictVos.stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode));
        List splitTypeDict = (List)typeCodeMap.get("examine_circular_split_type_new");
        Map<String, String> splitTypeMap = splitTypeDict.stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode));
        Map sysMap = this.customerRetailerVoService.getAllRetailerNameCode();
        data.forEach((index, o) -> {
            StringBuilder sb;
            ArrayList<String> errorMsgList;
            block54: {
                block52: {
                    TpmExamineCircularRelationTypeEnum relationTypeEnum;
                    block53: {
                        errorMsgList = new ArrayList<String>();
                        String businessFormat = (String)businessFormatMap.get(o.getBusinessFormatCodeDesc());
                        if (StringUtils.isNotBlank((CharSequence)businessFormat)) {
                            o.setBusinessFormatCode(businessFormat);
                        } else {
                            errorMsgList.add("\u9519\u8bef\u7684\u4e1a\u6001\u7c7b\u578b");
                        }
                        String businessUnit = (String)businessUnitDictMap.get(o.getBusinessUnitCodeDesc());
                        if (StringUtils.isNotBlank((CharSequence)businessUnit)) {
                            o.setBusinessUnitCode(businessUnit);
                        } else {
                            errorMsgList.add("\u9519\u8bef\u7684\u4e1a\u52a1\u5355\u5143\u7c7b\u578b");
                        }
                        String relationType = (String)relationTypeMap.get(o.getRelationTypeDesc());
                        if (!StringUtils.isNotBlank((CharSequence)relationType)) break block52;
                        o.setRelationType(relationType);
                        relationTypeEnum = TpmExamineCircularRelationTypeEnum.codeToEnum((String)relationType);
                        if (!Objects.isNull(relationTypeEnum)) break block53;
                        errorMsgList.add("\u672a\u77e5\u7684\u5173\u8054\u7c7b\u578b'" + o.getRelationTypeDesc() + "'");
                        break block54;
                    }
                    switch (relationTypeEnum) {
                        case FEE_POOL_RELATION: {
                            o.setBudgetCode("");
                            break;
                        }
                        case BUDGET_RELATION: 
                        case FEE_POOL_RELATION_AND_BUDGET: {
                            if (StringUtil.isEmpty((String)o.getBudgetCode())) {
                                errorMsgList.add("\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                                break;
                            }
                            break block54;
                        }
                        default: {
                            errorMsgList.add("\u9519\u8bef\u7684\u5173\u8054\u7c7b\u578b");
                        }
                    }
                    break block54;
                }
                errorMsgList.add("\u5173\u8054\u7c7b\u578b\u4e0d\u5b58\u5728");
            }
            String examineType = (String)examineTypeMap.get(o.getExamineTypeDesc());
            if (StringUtils.isNotBlank((CharSequence)examineType)) {
                o.setExamineType(examineType);
            } else {
                errorMsgList.add("\u9519\u8bef\u7684\u8003\u6838\u7c7b\u578b");
            }
            if (StringUtils.isNotBlank((CharSequence)o.getRegionDesc())) {
                String regionCode = (String)map.get(o.getRegionDesc());
                if (StringUtils.isNotBlank((CharSequence)regionCode)) {
                    o.setRegion(regionCode);
                } else {
                    errorMsgList.add("\u9519\u8bef\u7684\u533a\u57df\u7f16\u7801");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)o.getSystemCodeDesc())) {
                String code = (String)sysMap.get(o.getSystemCodeDesc());
                if (StringUtils.isNotBlank((CharSequence)code)) {
                    o.setSystemCode(code);
                } else {
                    errorMsgList.add("\u9519\u8bef\u7684\u96f6\u552e\u5546\u7f16\u7801");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)o.getMdgCustomerCode())) {
                sb = new StringBuilder();
                String customerCode = sb.append(o.getMdgCustomerCode()).append(o.getSalesOrgErpCode()).append(o.getChannel()).append(o.getBusinessFormatCode()).toString();
                o.setCustomerCode(customerCode);
            }
            if (StringUtils.isNotBlank((CharSequence)o.getSalesOrgErpCode())) {
                sb = new StringBuilder();
                sb.append(o.getChannel()).append(o.getBusinessFormatCode()).append(o.getSalesOrgErpCode());
                o.setSalesOrgCode(sb.toString());
            }
            if (StringUtils.equals((CharSequence)TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION.getCode(), (CharSequence)o.getRelationType()) || StringUtils.equals((CharSequence)TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION_AND_BUDGET.getCode(), (CharSequence)o.getRelationType())) {
                if (StringUtils.equals((CharSequence)BooleanEnum.TRUE.getSure(), (CharSequence)o.getIsUpAccountDesc())) {
                    o.setIsUpAccount(BooleanEnum.TRUE.getCapital());
                } else if (StringUtils.equals((CharSequence)BooleanEnum.FALSE.getSure(), (CharSequence)o.getIsUpAccountDesc())) {
                    o.setIsUpAccount(BooleanEnum.FALSE.getCapital());
                } else {
                    errorMsgList.add("\u9519\u8bef\u7684\u662f\u5426\u4e0a\u8d26\u7c7b\u578b");
                }
                String splitType = (String)splitTypeMap.get(o.getSplitTypeDesc());
                if (StringUtils.isNotBlank((CharSequence)splitType)) {
                    o.setSplitType(splitType);
                } else {
                    o.setIsSplit(BooleanEnum.FALSE.getCapital());
                }
            }
            if (StringUtils.equals((CharSequence)TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION.getCode(), (CharSequence)o.getRelationType()) || StringUtils.equals((CharSequence)TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION_AND_BUDGET.getCode(), (CharSequence)o.getRelationType())) {
                if (StringUtils.equals((CharSequence)BusinessUnitEnum.HEADQUARTERS.getCode(), (CharSequence)o.getBusinessUnitCode()) || StringUtils.equals((CharSequence)BusinessUnitEnum.SON_COMPANY.getCode(), (CharSequence)o.getBusinessUnitCode())) {
                    if (StringUtils.isEmpty((CharSequence)o.getSplitType())) {
                        o.setIsSplit(BooleanEnum.FALSE.getCapital());
                    } else {
                        o.setIsSplit(BooleanEnum.TRUE.getCapital());
                    }
                } else {
                    o.setIsSplit(BooleanEnum.TRUE.getCapital());
                }
            }
            if (BusinessUnitEnum.SON_COMPANY.getCode().equals(o.getBusinessUnitCode()) && StringUtils.isBlank((CharSequence)o.getSalesOrgErpCode())) {
                errorMsgList.add("\u9500\u552e\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.equals((CharSequence)BusinessUnitEnum.VERTICAL.getCode(), (CharSequence)o.getBusinessUnitCode())) {
                if (StringUtils.equals((CharSequence)TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION.getCode(), (CharSequence)o.getRelationType()) && StringUtils.equals((CharSequence)TpmExamineCircularSplitTypeEnum.SALE_NUM_SPLIT.getCode(), (CharSequence)o.getSplitType())) {
                    errorMsgList.add("\u5782\u76f4\u4e1a\u52a1\u5355\u5143\u4e0d\u652f\u6301\u9500\u91cf\u5206\u644a");
                }
                if (StringUtils.isBlank((CharSequence)o.getRegionDesc())) {
                    errorMsgList.add("\u4e1a\u52a1\u5355\u5143\u4e3a\u5782\u76f4\u65f6\uff0c\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)o.getSystemCodeDesc())) {
                    errorMsgList.add("\u4e1a\u52a1\u5355\u5143\u4e3a\u5782\u76f4\u65f6\uff0c\u96f6\u552e\u5546\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            if (StringUtils.equals((CharSequence)o.getRelationType(), (CharSequence)TpmExamineCircularRelationTypeEnum.BUDGET_RELATION.getCode()) && StringUtils.isBlank((CharSequence)o.getBudgetCode())) {
                errorMsgList.add("\u5173\u8054\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.equals((CharSequence)o.getRelationType(), (CharSequence)TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION.getCode()) || StringUtils.equals((CharSequence)o.getRelationType(), (CharSequence)TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION_AND_BUDGET.getCode())) {
                if (StringUtils.equals((CharSequence)o.getBusinessUnitCode(), (CharSequence)BusinessUnitEnum.ONLINE.getCode()) && StringUtils.isBlank((CharSequence)o.getIsUpAccountDesc())) {
                    errorMsgList.add("\u4e1a\u52a1\u5355\u5143\u4e3a\u7535\u5546\u65f6\uff0c\u662f\u5426\u4e0a\u8d26\u5fc5\u586b");
                }
                if (StringUtils.isBlank((CharSequence)o.getMdgCustomerCode())) {
                    errorMsgList.add("\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)o.getSalesOrgErpCode())) {
                    errorMsgList.add("\u9500\u552e\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)o.getSplitType())) {
                    o.setProductCode(null);
                    o.setProductName(null);
                }
                if (StringUtils.isBlank((CharSequence)o.getAppraisalMonth())) {
                    errorMsgList.add("\u8003\u6838\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (Objects.isNull(o.getStartDate())) {
                    errorMsgList.add("\u8003\u6838\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (Objects.isNull(o.getEndDate())) {
                    errorMsgList.add("\u8003\u6838\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)o.getChannel())) {
                    errorMsgList.add("\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)o.getActivityForm())) {
                    errorMsgList.add("\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.equals((CharSequence)TpmExamineCircularSplitTypeEnum.MANUAL_SPLIT.getCode(), (CharSequence)o.getSplitType())) {
                    if (StringUtils.isBlank((CharSequence)o.getSeq())) {
                        errorMsgList.add("\u5173\u8054\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)o.getProductCode())) {
                        errorMsgList.add("\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (Objects.isNull(o.getSplitAmount())) {
                        errorMsgList.add("\u5206\u644a\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
            }
            if (CollectionUtil.isNotEmpty(errorMsgList)) {
                errorMap.put((Integer)index, errorMap.getOrDefault(index, "") + "||" + String.join((CharSequence)"||", errorMsgList));
            }
        });
    }

    private void importSaveValidation(LinkedHashMap<Integer, TpmExamineCircularImportVo> data, Map<Integer, String> errorMap) {
        data.forEach((index, o) -> {
            ArrayList<String> errorMsgList = new ArrayList<String>();
            if (StringUtils.isBlank((CharSequence)o.getBusinessFormatCodeDesc())) {
                errorMsgList.add("\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)o.getBusinessUnitCodeDesc())) {
                errorMsgList.add("\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)o.getChannel())) {
                errorMsgList.add("\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)o.getRelationTypeDesc())) {
                errorMsgList.add("\u5173\u8054\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)o.getExamineTypeDesc())) {
                errorMsgList.add("\u8003\u6838\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (Objects.isNull(o.getExamineCircularAmount())) {
                errorMsgList.add("\u5956\u52b1\u6263\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (CollectionUtil.isNotEmpty(errorMsgList)) {
                errorMap.put((Integer)index, errorMap.getOrDefault(index, "") + "||" + String.join((CharSequence)"||", errorMsgList));
            }
        });
    }

    public List<TpmExamineCircularDto> importHandleFeePoolRelation(Map<Integer, TpmExamineCircularImportVo> feePoolMap, Map<Integer, String> errorMap) {
        List<TpmExamineCircularDto> circularDtos;
        ArrayList<TpmExamineCircularDto> dtos = new ArrayList<TpmExamineCircularDto>();
        HashMap<Integer, TpmExamineCircularImportVo> noSplitMap = new HashMap<Integer, TpmExamineCircularImportVo>();
        HashMap<Integer, TpmExamineCircularImportVo> splitMap = new HashMap<Integer, TpmExamineCircularImportVo>();
        for (Map.Entry<Integer, TpmExamineCircularImportVo> entry : feePoolMap.entrySet()) {
            if (StringUtils.equals((CharSequence)BooleanEnum.TRUE.getCapital(), (CharSequence)entry.getValue().getIsSplit())) {
                splitMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            noSplitMap.put(entry.getKey(), entry.getValue());
        }
        HashMap<Integer, TpmExamineCircularImportVo> manualMap = new HashMap<Integer, TpmExamineCircularImportVo>();
        HashMap<Integer, TpmExamineCircularImportVo> salesMap = new HashMap<Integer, TpmExamineCircularImportVo>();
        block5: for (Map.Entry entry : splitMap.entrySet()) {
            TpmExamineCircularSplitTypeEnum splitTypeEnum = TpmExamineCircularSplitTypeEnum.codeToEnum((String)((TpmExamineCircularImportVo)entry.getValue()).getSplitType());
            switch (splitTypeEnum) {
                case MANUAL_SPLIT: {
                    manualMap.put((Integer)entry.getKey(), (TpmExamineCircularImportVo)entry.getValue());
                    continue block5;
                }
                case SALE_NUM_SPLIT: {
                    salesMap.put((Integer)entry.getKey(), (TpmExamineCircularImportVo)entry.getValue());
                    continue block5;
                }
            }
            errorMap.put((Integer)entry.getKey(), errorMap.getOrDefault(entry.getKey(), "") + "||\u9519\u8bef\u7684\u5206\u644a\u7c7b\u578b!");
        }
        if (CollectionUtil.isNotEmpty(manualMap)) {
            circularDtos = this.manualSplitHandle(manualMap, errorMap);
            dtos.addAll(circularDtos);
        }
        if (CollectionUtil.isNotEmpty(salesMap)) {
            circularDtos = this.salesSplitOrNoSplitHandle(salesMap, errorMap);
            dtos.addAll(circularDtos);
        }
        if (CollectionUtil.isNotEmpty(noSplitMap)) {
            circularDtos = this.salesSplitOrNoSplitHandle(noSplitMap, errorMap);
            dtos.addAll(circularDtos);
        }
        return dtos;
    }

    public List<TpmExamineCircularDto> manualSplitHandle(Map<Integer, TpmExamineCircularImportVo> manualMap, Map<Integer, String> errorMap) {
        ArrayList<TpmExamineCircularDto> dtos = new ArrayList<TpmExamineCircularDto>();
        manualMap.forEach((index, o) -> o.setIndex(index));
        Map<String, List<TpmExamineCircularImportVo>> map = manualMap.values().stream().collect(Collectors.groupingBy(TpmExamineCircularImportVo::getSeq));
        for (Map.Entry<String, List<TpmExamineCircularImportVo>> entry : map.entrySet()) {
            TpmExamineCircularDto dto = new TpmExamineCircularDto();
            List<TpmExamineCircularImportVo> value = entry.getValue();
            BeanUtils.copyProperties((Object)value.get(0), (Object)dto);
            ArrayList<TpmExamineCircularProductSplitDto> splitDtoList = new ArrayList<TpmExamineCircularProductSplitDto>();
            BigDecimal examineAmount = BigDecimal.ZERO;
            for (TpmExamineCircularImportVo vo2 : value) {
                TpmExamineCircularProductSplitDto splitInfo = new TpmExamineCircularProductSplitDto();
                BeanUtils.copyProperties((Object)vo2, (Object)splitInfo);
                splitDtoList.add(splitInfo);
                examineAmount = examineAmount.add(splitInfo.getSplitAmount());
            }
            if (examineAmount.compareTo(dto.getExamineCircularAmount()) != 0) {
                value.forEach(vo -> errorMap.put(vo.getIndex(), errorMap.getOrDefault(vo.getIndex(), "") + "||\u5206\u644a\u91d1\u989d\u4e4b\u548c\u4e0d\u7b49\u4e8e\u8003\u6838/\u5956\u52b1\u91d1\u989d!"));
            }
            dto.setProductSplitList(splitDtoList);
            dtos.add(dto);
        }
        return dtos;
    }

    private List<TpmExamineCircularDto> salesSplitOrNoSplitHandle(Map<Integer, TpmExamineCircularImportVo> salesMap, Map<Integer, String> errorMap) {
        ArrayList<TpmExamineCircularDto> dtos = new ArrayList<TpmExamineCircularDto>();
        salesMap.forEach((index, o) -> o.setIndex(index));
        for (Map.Entry<Integer, TpmExamineCircularImportVo> entry : salesMap.entrySet()) {
            ArrayList errorMsgList = new ArrayList();
            TpmExamineCircularDto dto = new TpmExamineCircularDto();
            BeanUtils.copyProperties((Object)entry.getValue(), (Object)dto);
            if (StringUtils.equals((CharSequence)entry.getValue().getIsSplit(), (CharSequence)BooleanEnum.TRUE.getCapital())) {
                this.tpmExamineCircularService.constructSalesVolumeSplitInfo(dto);
            }
            if (CollectionUtil.isNotEmpty(errorMsgList)) {
                errorMap.put(dto.getIndex(), errorMap.getOrDefault(dto.getIndex(), "") + "||" + String.join((CharSequence)"||", errorMsgList));
            }
            dtos.add(dto);
        }
        log.info("\u8003\u6838\u901a\u62a5\u5bfc\u5165\u9500\u91cf\u5206\u644a\u7ed3\u675f\u3010{}\u3011", (Object)JSON.toJSONString(dtos));
        return dtos;
    }

    private void importInsert(List<TpmExamineCircularDto> circularDtos) {
        log.info("\u8003\u6838\u901a\u62a5\u5bfc\u5165\u4fdd\u5b58===\u3010{}\u3011", (Object)JSON.toJSONString(circularDtos));
        if (CollectionUtils.isEmpty(circularDtos)) {
            return;
        }
        ArrayList<TpmExamineCircularEntity> insertList = new ArrayList<TpmExamineCircularEntity>();
        ArrayList<TpmExamineCircularProductSplitEntity> splitEntityList = new ArrayList<TpmExamineCircularProductSplitEntity>();
        if (CollectionUtil.isNotEmpty(circularDtos)) {
            FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
            List codeList = this.generateCodeService.generateCode("K", circularDtos.size(), Integer.valueOf(9), 0L, TimeUnit.DAYS);
            int index = 0;
            for (TpmExamineCircularDto dto : circularDtos) {
                Date date = new Date();
                dto.setTenantCode(TenantUtils.getTenantCode());
                TpmExamineCircularEntity entity = (TpmExamineCircularEntity)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmExamineCircularEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                entity.setExamineCircularCode((String)codeList.get(index));
                ++index;
                entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                entity.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
                entity.setApplyTime(date);
                entity.setApplyUserAccount(loginDetails.getUsername());
                entity.setApplyUserName(loginDetails.getRealName());
                entity.setRelationType(dto.getRelationType());
                if (!StringUtils.equals((CharSequence)BusinessUnitEnum.ONLINE.getCode(), (CharSequence)dto.getBusinessUnitCode())) {
                    entity.setIsUpAccount(BooleanEnum.TRUE.getCapital());
                }
                insertList.add(entity);
                if (!StringUtils.equals((CharSequence)TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION.getCode(), (CharSequence)dto.getRelationType()) && !StringUtils.equals((CharSequence)TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION_AND_BUDGET.getCode(), (CharSequence)dto.getRelationType()) || !CollectionUtil.isNotEmpty((Collection)dto.getProductSplitList())) continue;
                for (TpmExamineCircularProductSplitDto splitDto : dto.getProductSplitList()) {
                    TpmExamineCircularProductSplitEntity splitEntity = (TpmExamineCircularProductSplitEntity)this.nebulaToolkitService.copyObjectByWhiteList((Object)splitDto, TpmExamineCircularProductSplitEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                    splitEntity.setId(UuidCrmUtil.general());
                    splitEntity.setExamineCircularCode(entity.getExamineCircularCode());
                    splitEntity.setCreateAccount(loginDetails.getUsername());
                    splitEntity.setCreateName(loginDetails.getRealName());
                    splitEntity.setModifyAccount(loginDetails.getUsername());
                    splitEntity.setModifyName(loginDetails.getRealName());
                    splitEntity.setCreateTime(date);
                    splitEntity.setModifyTime(date);
                    splitEntity.setTenantCode(TenantUtils.getTenantCode());
                    splitEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    splitEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                    splitEntityList.add(splitEntity);
                }
            }
            int pageSize = 600;
            if (CollectionUtil.isNotEmpty(splitEntityList)) {
                int number = splitEntityList.size();
                List splitDetailCodeList = this.generateCodeService.generateCode("KM", number, Integer.valueOf(8), 0L, TimeUnit.DAYS);
                for (int i = 0; i < splitEntityList.size(); ++i) {
                    ((TpmExamineCircularProductSplitEntity)splitEntityList.get(i)).setSplitDetailCode((String)splitDetailCodeList.get(i));
                }
                Lists.partition(splitEntityList, (int)pageSize).forEach(list -> this.tpmExamineCircularProductSplitEntityMapper.insertList((List<TpmExamineCircularProductSplitEntity>)list));
            }
            if (CollectionUtil.isNotEmpty(insertList)) {
                Lists.partition(insertList, (int)pageSize).forEach(list -> this.tpmExamineCircularEntityRepository.saveBatch((Collection)list));
                for (TpmExamineCircularEntity circularEntity : insertList) {
                    TpmExamineCircularLogDto logDto = new TpmExamineCircularLogDto();
                    TpmExamineCircularDto newest = (TpmExamineCircularDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)circularEntity, TpmExamineCircularDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                    logDto.setNewest(newest);
                    this.tpmExamineCircularLogEventListener.onCreate(logDto);
                }
            }
        }
    }

    public Class<TpmExamineCircularImportVo> findCrmExcelVoClass() {
        return TpmExamineCircularImportVo.class;
    }

    public String getTemplateCode() {
        return "TPM_EXAMINE_CIRCULAR_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u8003\u6838\u901a\u62a5\u5bfc\u5165";
    }
}

