/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.examine.circular.local.listener;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.examine.circular.local.entity.TpmExamineCircularEntity;
import com.biz.crm.tpm.business.examine.circular.local.mapper.TpmExamineCircularEntityMapper;
import com.biz.crm.tpm.business.examine.circular.local.service.TpmExamineCircularPushService;
import com.biz.crm.tpm.business.examine.circular.sdk.constant.TpmExamineCircularRelationTypeEnum;
import com.biz.crm.tpm.business.examine.circular.sdk.service.TpmExamineCircularService;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.TpmExamineCircularRespVo;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class TpmExamineCircularProcessCallBackListener
implements ProcessCompleteListener {
    private static final Logger log = LoggerFactory.getLogger(TpmExamineCircularProcessCallBackListener.class);
    @Autowired(required=false)
    private TpmExamineCircularEntityMapper tpmExamineCircularEntityMapper;
    @Autowired(required=false)
    private TpmExamineCircularService tpmExamineCircularService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private TpmExamineCircularPushService tpmExamineCircularPushService;

    public String getBusinessCode() {
        return "examine_circular_process";
    }

    @Transactional(rollbackFor={Exception.class})
    public void onProcessComplete(ProcessStatusDto dto) {
        log.info("\u8003\u6838\u6263\u6b3e\u76d1\u542c \u53c2\u6570\u3010{}\u3011", (Object)dto);
        if (Objects.isNull(dto) || CollectionUtil.isEmpty((Collection)dto.getBusinessNoList()) || StringUtils.isEmpty((CharSequence)dto.getProcessStatus())) {
            return;
        }
        List<TpmExamineCircularEntity> invalidList = this.tpmExamineCircularEntityMapper.findByIdList(dto.getBusinessNoList(), TenantUtils.getTenantCode());
        if (CollectionUtil.isEmpty(invalidList)) {
            log.error("\u8003\u6838\u6263\u6b3e\u76d1\u542c,\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u6570\u636e\uff01");
            return;
        }
        log.info("invalidList \u3010{}\u3011", (Object)JSON.toJSONString(invalidList));
        String processStatus = dto.getProcessStatus();
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            Date curDate = DateUtil.getDate((SimpleDateFormat)DateUtil.date_yyyy_MM_dd_HH_mm_ss);
            this.tpmExamineCircularEntityMapper.updateProcessStatusByCode(processStatus, dto.getBusinessNoList(), curDate);
            this.executeAfterBusiness(invalidList);
        } else if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus) || ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) {
            this.tpmExamineCircularEntityMapper.updateProcessStatusByCode(processStatus, dto.getBusinessNoList(), null);
        }
    }

    private void executeAfterBusiness(List<TpmExamineCircularEntity> invalidList) {
        List<TpmExamineCircularRespVo> respVoList;
        List<TpmExamineCircularRespVo> circularRespVos;
        Map<String, List<TpmExamineCircularRespVo>> map;
        List<TpmExamineCircularRespVo> respVos;
        List<Object> examineCircularRespVos;
        if (CollectionUtils.isEmpty(invalidList)) {
            return;
        }
        Collection tpmExamineCircularRespVos = this.nebulaToolkitService.copyCollectionByWhiteList(invalidList, TpmExamineCircularEntity.class, TpmExamineCircularRespVo.class, HashSet.class, ArrayList.class, new String[0]);
        Map<String, List<TpmExamineCircularRespVo>> listMap = tpmExamineCircularRespVos.stream().collect(Collectors.groupingBy(TpmExamineCircularRespVo::getRelationType));
        if (listMap.containsKey(TpmExamineCircularRelationTypeEnum.BUDGET_RELATION.getCode())) {
            examineCircularRespVos = listMap.get(TpmExamineCircularRelationTypeEnum.BUDGET_RELATION.getCode());
            examineCircularRespVos.forEach(o -> o.setExamineCircularAmount(o.getExamineCircularAmount().negate()));
            this.tpmExamineCircularService.budgetChange(examineCircularRespVos);
        }
        examineCircularRespVos = new ArrayList();
        if (listMap.containsKey(TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION.getCode())) {
            examineCircularRespVos.addAll((Collection<Object>)listMap.get(TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION.getCode()));
        }
        if (listMap.containsKey(TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION_AND_BUDGET.getCode())) {
            examineCircularRespVos.addAll((Collection<Object>)listMap.get(TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION_AND_BUDGET.getCode()));
        }
        if (!CollectionUtils.isEmpty(respVos = (map = examineCircularRespVos.stream().collect(Collectors.groupingBy(TpmExamineCircularRespVo::getIsUpAccount))).get(BooleanEnum.TRUE.getCapital()))) {
            List<String> codes = respVos.stream().filter(k -> StringUtils.isNotEmpty((CharSequence)k.getExamineCircularCode())).map(TpmExamineCircularRespVo::getExamineCircularCode).distinct().collect(Collectors.toList());
            this.tpmExamineCircularPushService.feePoolPushToSapSync(codes);
        }
        if (listMap.containsKey(TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION_AND_BUDGET.getCode()) && !CollectionUtils.isEmpty(circularRespVos = (respVoList = listMap.get(TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION_AND_BUDGET.getCode())).stream().filter(o -> StringUtils.equals((CharSequence)BooleanEnum.TRUE.getCapital(), (CharSequence)o.getIsUpAccount())).collect(Collectors.toList()))) {
            log.info("\u8003\u6838\u901a\u62a5\u5ba1\u6279\u6210\u529f\u56de\u8c03\uff0c\u9884\u7b97\u8c03\u6574,\u53c2\u6570\u3010{}\u3011", (Object)JSON.toJSONString(circularRespVos));
            circularRespVos.forEach(o -> o.setExamineCircularAmount(o.getExamineCircularAmount().negate()));
            this.tpmExamineCircularService.budgetChange(circularRespVos);
        }
    }
}

