/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.examine.circular.local.repository;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.examine.circular.local.entity.ExamineCircularDailyRecord;
import com.biz.crm.tpm.business.examine.circular.local.mapper.ExamineCircularDailyRecordMapper;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.ExamineCircularDailyRecordDto;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.ExamineCircularDailyRecordVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ExamineCircularDailyRecordRepository
extends ServiceImpl<ExamineCircularDailyRecordMapper, ExamineCircularDailyRecord> {
    private static final Logger log = LoggerFactory.getLogger(ExamineCircularDailyRecordRepository.class);
    @Autowired
    private ExamineCircularDailyRecordMapper mapper;

    public Page<ExamineCircularDailyRecordVo> findByConditions(Pageable pageable, ExamineCircularDailyRecordDto dto) {
        return this.mapper.findByConditions((Page<ExamineCircularDailyRecordDto>)new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize()), dto);
    }

    public ExamineCircularDailyRecord findDetailsById(String id) {
        return StringUtils.hasText((String)id) ? (ExamineCircularDailyRecord)((Object)this.getById((Serializable)((Object)id))) : null;
    }

    public List<ExamineCircularDailyRecord> findByListDto(List<ExamineCircularDailyRecordDto> dailyRecordDtos) {
        if (CollectionUtils.isEmpty(dailyRecordDtos)) {
            return Lists.newArrayList();
        }
        ArrayList<ExamineCircularDailyRecord> recordList = new ArrayList<ExamineCircularDailyRecord>();
        for (ExamineCircularDailyRecordDto dto : dailyRecordDtos) {
            List<ExamineCircularDailyRecord> oneList;
            if (StringUtil.isEmpty((CharSequence)dto.getYearAndMonth()) || StringUtil.isEmpty((CharSequence)dto.getSalesInstitutionCode()) || StringUtil.isEmpty((CharSequence)dto.getBusinessFormatCode()) || StringUtil.isEmpty((CharSequence)dto.getChannelCode()) || StringUtil.isEmpty((CharSequence)dto.getCustomerCode()) || !CollectionUtil.isNotEmpty(oneList = ((ExamineCircularDailyRecordMapper)this.getBaseMapper()).findByListDto(dto))) continue;
            recordList.addAll(oneList);
        }
        return recordList;
    }

    public List<ExamineCircularDailyRecord> findByYearMonth(String yearMonth) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).likeRight(ExamineCircularDailyRecord::getExamineDay, (Object)yearMonth)).list();
    }
}

