/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.examine.circular.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.examine.circular.local.entity.ExamineCircularMonthRecordEntity;
import com.biz.crm.tpm.business.examine.circular.local.mapper.ExamineCircularMonthRecordMapper;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.ExamineCircularMonthRecordDto;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ExamineCircularMonthRecordRepository
extends ServiceImpl<ExamineCircularMonthRecordMapper, ExamineCircularMonthRecordEntity> {
    private static final Logger log = LoggerFactory.getLogger(ExamineCircularMonthRecordRepository.class);

    public Page<ExamineCircularMonthRecordDto> findByConditions(Pageable pageable, ExamineCircularMonthRecordDto dto) {
        return ((ExamineCircularMonthRecordMapper)this.baseMapper).findByConditions((Page<ExamineCircularMonthRecordDto>)new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize()), dto);
    }

    public ExamineCircularMonthRecordEntity findDetailsById(String id) {
        return StringUtils.hasText((String)id) ? (ExamineCircularMonthRecordEntity)((Object)this.getById((Serializable)((Object)id))) : null;
    }

    public List<ExamineCircularMonthRecordEntity> findByItemKeys(List<String> itemKeys) {
        if (CollectionUtils.isEmpty(itemKeys)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ExamineCircularMonthRecordEntity::getItemKey, itemKeys)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<ExamineCircularMonthRecordEntity> findByItemKeyFormulaVariable(String itemKey) {
        if (!StringUtils.hasText((String)itemKey)) {
            return Lists.newArrayList();
        }
        return ((ExamineCircularMonthRecordMapper)this.baseMapper).findByItemKeyFormulaVariable(itemKey);
    }

    public List<ExamineCircularMonthRecordEntity> findByListExamineCircularMonthRecordDto(List<ExamineCircularMonthRecordDto> queryList) {
        return ((ExamineCircularMonthRecordMapper)this.getBaseMapper()).findByListExamineCircularMonthRecordDto(queryList);
    }

    public List<ExamineCircularMonthRecordEntity> findByYearAndMonth(String yearAndMonth) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ExamineCircularMonthRecordEntity::getYearAndMonth, (Object)yearAndMonth)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public void deleteByYearAndMonth(String yearAndMonth) {
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ExamineCircularMonthRecordEntity::getYearAndMonth, (Object)yearAndMonth)).remove();
    }
}

