/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.examine.circular.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.examine.circular.local.entity.TpmExamineCircularEntity;
import com.biz.crm.tpm.business.examine.circular.local.mapper.TpmExamineCircularEntityMapper;
import com.biz.crm.tpm.business.examine.circular.sdk.constant.TpmExamineCircularRelationTypeEnum;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.CustomerCostAssessedAmountStatisticsDto;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.SurplusFeePoolBalanceAssessedAmountStatisticsDto;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.TpmExamineCircularDto;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.CostPoolAuditReportVo;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.CustomerCostAssessedAmountStatisticsVo;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.MobileExamineCircularApprovedVo;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.SurplusFeePoolBalanceAssessedAmountStatisticsVo;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.TpmExamineCircularRespVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class TpmExamineCircularEntityRepository
extends ServiceImpl<TpmExamineCircularEntityMapper, TpmExamineCircularEntity> {
    @Autowired(required=false)
    private TpmExamineCircularEntityMapper tpmExamineCircularEntityMapper;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    public List<CustomerCostAssessedAmountStatisticsVo> listAssessedAmountByOrgCusCodes(CustomerCostAssessedAmountStatisticsDto dto) {
        if (StringUtils.isEmpty((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        return this.tpmExamineCircularEntityMapper.listAssessedAmountByOrgCusCodes(dto);
    }

    public List<SurplusFeePoolBalanceAssessedAmountStatisticsVo> statisAssessDeduction(SurplusFeePoolBalanceAssessedAmountStatisticsDto dto) {
        if (Objects.isNull(dto.getFeeYearMonth()) || StringUtils.isBlank((CharSequence)dto.getBusinessFormatCode()) || StringUtils.isBlank((CharSequence)dto.getBusinessUnitCode())) {
            return Lists.newArrayList();
        }
        if (StringUtils.isEmpty((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        return this.tpmExamineCircularEntityMapper.statisAssessDeduction(dto);
    }

    public void updateProcessStatusBatchByIds(List<String> ids, ProcessStatusEnum processStatusEnum, String processNo, String processTitle) {
        if (CollectionUtils.isEmpty(ids) || Objects.isNull(processStatusEnum)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(UuidEntity::getId, ids)).set(TpmExamineCircularEntity::getProcessStatus, (Object)processStatusEnum.getDictCode())).set(TpmExamineCircularEntity::getProcessNo, (Object)processNo)).set(TpmExamineCircularEntity::getProcessTitle, (Object)processTitle)).update();
    }

    public List<TpmExamineCircularEntity> findByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(TpmExamineCircularEntity::getExamineCircularCode, codes)).list();
    }

    public List<TpmExamineCircularEntity> findByProcessNo(String processNo) {
        if (StringUtils.isEmpty((CharSequence)processNo)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(TpmExamineCircularEntity::getProcessNo, (Object)processNo)).list();
    }

    public TpmExamineCircularEntity findById(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        return (TpmExamineCircularEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidEntity::getId, (Object)id)).one();
    }

    public List<TpmExamineCircularEntity> findListForMonitor(TpmExamineCircularDto dto) {
        if (Objects.isNull(dto)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(TpmExamineCircularEntity::getAppraisalMonth, (Object)dto.getAppraisalMonth())).eq(TpmExamineCircularEntity::getProcessStatus, (Object)ProcessStatusEnum.PASS.getDictCode())).and(o -> ((LambdaQueryWrapper)((LambdaQueryWrapper)o.eq(TpmExamineCircularEntity::getRelationType, (Object)TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION.getCode())).or()).eq(TpmExamineCircularEntity::getRelationType, (Object)TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION_AND_BUDGET.getCode()))).in(CollectionUtils.isNotEmpty((Collection)dto.getMdgCustomerCodes()), TpmExamineCircularEntity::getMdgCustomerCode, (Collection)dto.getMdgCustomerCodes())).eq(StringUtils.isNotEmpty((CharSequence)dto.getMdgCustomerCode()), TpmExamineCircularEntity::getMdgCustomerCode, (Object)dto.getMdgCustomerCode())).list();
    }

    public List<TpmExamineCircularEntity> findByExamineCircularCodes(List<String> examineCircularCodes) {
        if (CollectionUtils.isEmpty(examineCircularCodes)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(TpmExamineCircularEntity::getExamineCircularCode, examineCircularCodes)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    public BigDecimal findExamineCircularAmountForVariable(TpmExamineCircularDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        return ((TpmExamineCircularEntityMapper)this.baseMapper).findExamineCircularAmountForVariable(dto);
    }

    public Page<TpmExamineCircularRespVo> findPageForOut(Pageable pageable, TpmExamineCircularDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((TpmExamineCircularEntityMapper)this.baseMapper).findPageForOut((Page<TpmExamineCircularRespVo>)page, dto);
    }

    public List<MobileExamineCircularApprovedVo> mobileExamineCircularApproved(String processNo) {
        if (StringUtils.isEmpty((CharSequence)processNo)) {
            return Lists.newArrayList();
        }
        return ((TpmExamineCircularEntityMapper)this.getBaseMapper()).mobileExamineCircularApproved(processNo);
    }

    public boolean saveBatch(Collection<TpmExamineCircularEntity> entityList, int batchSize) {
        FacturerUserDetails loginUserDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        if (null != loginUserDetails) {
            String orgCode = loginUserDetails.getOrgCode();
            String orgName = loginUserDetails.getOrgName();
            entityList.forEach(item -> {
                item.setOrgCode(orgCode);
                item.setOrgName(orgName);
            });
        }
        return super.saveBatch(entityList, batchSize);
    }

    public BigDecimal getExamineMoney(SurplusFeePoolBalanceAssessedAmountStatisticsDto assessDto) {
        return ((TpmExamineCircularEntityMapper)this.baseMapper).getExamineMoney(assessDto);
    }

    public Page<CostPoolAuditReportVo> findManualUpdateCostPoolReport(Pageable pageable, TpmExamineCircularDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (Objects.isNull(dto)) {
            return page;
        }
        return ((TpmExamineCircularEntityMapper)this.baseMapper).findManualUpdateCostPoolReport((Page<CostPoolAuditReportVo>)page, dto);
    }

    public Page<CostPoolAuditReportVo> findManualUpdateCostPoolReport2(Pageable pageable, TpmExamineCircularDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (Objects.isNull(dto)) {
            return page;
        }
        return ((TpmExamineCircularEntityMapper)this.baseMapper).findManualUpdateCostPoolReport2((Page<CostPoolAuditReportVo>)page, dto);
    }

    public List<TpmExamineCircularRespVo> findByProfitMonitor(List<TpmExamineCircularDto> tpmExamineCircularDto) {
        if (CollectionUtils.isEmpty(tpmExamineCircularDto)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        return this.tpmExamineCircularEntityMapper.findByProfitMonitor(tpmExamineCircularDto);
    }

    public List<String> tpmExamineCircularCustomerList(TpmExamineCircularDto circularDto) {
        return ((TpmExamineCircularEntityMapper)this.baseMapper).tpmExamineCircularCustomerList(circularDto);
    }
}

