/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.examine.circular.local.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.tpm.business.examine.circular.local.entity.ExamineCircularDailyRecord;
import com.biz.crm.tpm.business.examine.circular.local.repository.ExamineCircularDailyRecordRepository;
import com.biz.crm.tpm.business.examine.circular.local.service.ExamineCircularDailyRecordService;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.ExamineCircularDailyRecordDto;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.ExamineCircularDailyRecordVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExamineCircularDailyRecordServiceImpl
implements ExamineCircularDailyRecordService {
    private static final Logger log = LoggerFactory.getLogger(ExamineCircularDailyRecordServiceImpl.class);
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ExamineCircularDailyRecordRepository repository;
    @Autowired
    private SalesOrgVoService salesOrgVoService;
    @Autowired
    private CustomerVoService customerVoService;
    @Autowired
    private DictDataVoService dictDataVoService;

    @Override
    public Page<ExamineCircularDailyRecordVo> findByConditions(Pageable pageable, ExamineCircularDailyRecordDto dto) {
        return this.repository.findByConditions((Pageable)(pageable != null ? pageable : PageRequest.of((int)0, (int)50)), dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.repository.removeByIds(ids);
    }

    @Override
    public void createBatch(List<ExamineCircularDailyRecordVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List entityList = (List)this.nebulaToolkitService.copyCollectionByBlankList(list, ExamineCircularDailyRecordVo.class, ExamineCircularDailyRecord.class, HashSet.class, ArrayList.class, new String[0]);
        List salesOrgCodes = entityList.stream().map(a -> {
            StringBuffer salesOrgCode = new StringBuffer();
            salesOrgCode.append(a.getChannelCode());
            salesOrgCode.append(a.getBusinessFormatCode());
            salesOrgCode.append(a.getSalesInstitutionCode());
            return salesOrgCode.toString();
        }).collect(Collectors.toList());
        List salesOrgVos = this.salesOrgVoService.findBySalesOrgCodes(salesOrgCodes);
        HashMap salesOrgVoMap = CollectionUtils.isEmpty((Collection)salesOrgVos) ? Maps.newHashMap() : salesOrgVos.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity()));
        List customerCodes = entityList.stream().map(a -> {
            StringBuffer customerCode = new StringBuffer();
            customerCode.append(a.getCustomerCode());
            customerCode.append(a.getSalesInstitutionCode());
            customerCode.append(a.getChannelCode());
            customerCode.append(a.getBusinessFormatCode());
            return customerCode.toString();
        }).collect(Collectors.toList());
        List customerVos = this.customerVoService.findByCustomerCodes(customerCodes);
        HashMap customerVoMap = CollectionUtils.isEmpty((Collection)customerVos) ? Maps.newHashMap() : customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
        List dictDataVos = this.dictDataVoService.findByDictTypeCode("tpm_assess_type");
        HashMap dictDataVoMap = CollectionUtils.isEmpty((Collection)dictDataVos) ? Maps.newHashMap() : dictDataVos.stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode));
        entityList.forEach(e -> {
            e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            e.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            e.setTenantCode(TenantUtils.getTenantCode());
            StringBuffer salesOrgCode = new StringBuffer();
            salesOrgCode.append(e.getChannelCode());
            salesOrgCode.append(e.getBusinessFormatCode());
            salesOrgCode.append(e.getSalesInstitutionCode());
            if (salesOrgVoMap.containsKey(salesOrgCode.toString())) {
                e.setSalesInstitutionName(((SalesOrgVo)salesOrgVoMap.get(salesOrgCode.toString())).getSalesOrgName());
            }
            StringBuffer customerCode = new StringBuffer();
            customerCode.append(e.getCustomerCode());
            customerCode.append(e.getSalesInstitutionCode());
            customerCode.append(e.getChannelCode());
            customerCode.append(e.getBusinessFormatCode());
            if (customerVoMap.containsKey(customerCode.toString())) {
                e.setCustomerName(((CustomerVo)customerVoMap.get(customerCode.toString())).getCustomerName());
            }
            if (dictDataVoMap.containsKey(e.getExamineType())) {
                e.setExamineTypeCode((String)dictDataVoMap.get(e.getExamineType()));
            }
        });
        this.repository.saveBatch(entityList);
    }

    @Override
    public List<ExamineCircularDailyRecord> findByListDto(List<ExamineCircularDailyRecordDto> dailyRecordDtos) {
        if (CollectionUtils.isEmpty(dailyRecordDtos)) {
            return Lists.newArrayList();
        }
        return this.repository.findByListDto(dailyRecordDtos);
    }

    @Override
    public List<ExamineCircularDailyRecord> findByYearMonth(String yearMonth) {
        return this.repository.findByYearMonth(yearMonth);
    }
}

