/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.examine.circular.local.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.reconciliation.manage.sdk.dto.Zmfi046Dto;
import com.biz.crm.kms.business.reconciliation.manage.sdk.service.Zmfi046Voservice;
import com.biz.crm.kms.business.reconciliation.manage.sdk.vo.Zmfi046SdkVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditCustomerDetailDto;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailVo;
import com.biz.crm.tpm.business.examine.circular.local.entity.ExamineCircularDailyRecord;
import com.biz.crm.tpm.business.examine.circular.local.entity.ExamineCircularMonthRecordEntity;
import com.biz.crm.tpm.business.examine.circular.local.repository.ExamineCircularMonthRecordRepository;
import com.biz.crm.tpm.business.examine.circular.local.service.ExamineCircularDailyRecordService;
import com.biz.crm.tpm.business.examine.circular.local.service.ExamineCircularMonthRecordService;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.ExamineCircularMonthRecordDto;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.ExamineCircularMonthRecordVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ExamineCircularMonthRecordServiceImpl
implements ExamineCircularMonthRecordService {
    private static final Logger log = LoggerFactory.getLogger(ExamineCircularMonthRecordServiceImpl.class);
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ExamineCircularMonthRecordRepository repository;
    @Autowired
    private SalesOrgVoService salesOrgVoService;
    @Autowired
    private CustomerVoService customerVoService;
    @Autowired
    private AuditService auditService;
    @Autowired
    private ExamineCircularDailyRecordService examineCircularDailyRecordService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private Zmfi046Voservice zmfi046Voservice;

    @Override
    public Page<ExamineCircularMonthRecordDto> findByConditions(Pageable pageable, ExamineCircularMonthRecordDto dto) {
        return this.repository.findByConditions((Pageable)(pageable != null ? pageable : PageRequest.of((int)0, (int)50)), dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.repository.removeByIds(ids);
    }

    @Override
    public List<ExamineCircularMonthRecordVo> findByItemKeys(List<String> itemKeys) {
        if (CollectionUtils.isEmpty(itemKeys)) {
            return Lists.newArrayList();
        }
        List<ExamineCircularMonthRecordEntity> list = this.repository.findByItemKeys(itemKeys);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, ExamineCircularMonthRecordEntity.class, ExamineCircularMonthRecordVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createBatch(List<ExamineCircularMonthRecordVo> list) {
        Assert.notEmpty(list, (String)"\u65b0\u589e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!");
        List entityList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, ExamineCircularMonthRecordVo.class, ExamineCircularMonthRecordEntity.class, HashSet.class, ArrayList.class, new String[0]);
        this.calculateAmount(entityList, "create", null);
        entityList.forEach(e -> {
            e.setTenantCode(TenantUtils.getTenantCode());
            e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            e.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            String itemKey = e.getSalesInstitutionCode() + e.getBusinessFormatCode() + e.getChannelCode() + e.getCustomerCode() + e.getYearAndMonth();
            e.setItemKey(itemKey);
        });
        this.repository.saveBatch(entityList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void getDailyData(String yearAndMonth) {
        Validate.notEmpty((CharSequence)yearAndMonth, (String)"\u8bf7\u9009\u62e9\u5e74\u6708", (Object[])new Object[0]);
        ArrayList<ExamineCircularMonthRecordEntity> entityList = new ArrayList<ExamineCircularMonthRecordEntity>();
        this.calculateAmount(entityList, "update", yearAndMonth);
        this.repository.saveOrUpdateBatch(entityList);
    }

    private void calculateAmount(List<ExamineCircularMonthRecordEntity> entityList, String type, String yearAndMonth) {
        HashMap dailyRecordMap = Maps.newHashMap();
        if ("update".equals(type)) {
            dailyRecordMap.putAll(this.dailyRecordMap(entityList, yearAndMonth));
        }
        List dictDataVoList = this.dictDataVoService.findByDictTypeCode("tpm_assessment_deductions");
        Validate.notEmpty((Collection)dictDataVoList, (String)"\u672a\u627e\u5230\u4e0d\u53c2\u4e0e\u8003\u6838\u6263\u6b3e\u7684\u5df2\u7ed3\u6848\u91d1\u989d\u53d6\u503c\u7684\u6d3b\u52a8\u5f62\u5f0f\u7684\u6570\u636e\u5b57\u5178", (Object[])new Object[0]);
        List<String> activityFormCodeList = dictDataVoList.stream().map(e -> e.getDictCode()).collect(Collectors.toList());
        Map<String, SalesOrgVo> salesOrgVoMap = this.getSalesOrgVoMap(entityList);
        Map<String, CustomerVo> customerVoMap = this.getCustomerVoMap(entityList);
        Map<String, List<AuditCustomerDetailVo>> auditCustomerDetailVoMap = this.getAuditCustomerDetailVoMap(entityList, activityFormCodeList);
        LinkedHashMap<String, List<ExamineCircularMonthRecordEntity>> monthRecordMap = this.getMonthRecordList(entityList);
        Map<String, Zmfi046SdkVo> zmfi046Map = this.get046(entityList);
        entityList.forEach(e -> {
            StringBuilder dailyRecordKey = new StringBuilder();
            dailyRecordKey.append(e.getSalesInstitutionCode());
            dailyRecordKey.append(e.getBusinessFormatCode());
            dailyRecordKey.append(e.getChannelCode());
            dailyRecordKey.append(e.getCustomerCode());
            dailyRecordKey.append(e.getYearAndMonth());
            AtomicReference<BigDecimal> monthRewardAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            AtomicReference<BigDecimal> monthDeductAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            if (dailyRecordMap.containsKey(dailyRecordKey.toString())) {
                ((List)dailyRecordMap.get(dailyRecordKey.toString())).forEach(a -> {
                    monthRewardAmount.set(((BigDecimal)monthRewardAmount.get()).add(Optional.ofNullable(a.getExamineRewardAmount()).orElse(BigDecimal.ZERO)));
                    monthDeductAmount.set(((BigDecimal)monthDeductAmount.get()).add(Optional.ofNullable(a.getExamineDeductAmount()).orElse(BigDecimal.ZERO)));
                });
            }
            e.setMonthRewardAmount(monthRewardAmount.get());
            e.setMonthDeductAmount(monthDeductAmount.get());
            StringBuilder salesOrgCode = new StringBuilder();
            salesOrgCode.append(e.getChannelCode());
            salesOrgCode.append(e.getBusinessFormatCode());
            salesOrgCode.append(e.getSalesInstitutionCode());
            if (salesOrgVoMap.containsKey(salesOrgCode.toString())) {
                e.setSalesInstitutionName(((SalesOrgVo)salesOrgVoMap.get(salesOrgCode.toString())).getSalesOrgName());
            }
            StringBuilder customerCode = new StringBuilder();
            customerCode.append(e.getCustomerCode());
            customerCode.append(e.getSalesInstitutionCode());
            customerCode.append(e.getChannelCode());
            customerCode.append(e.getBusinessFormatCode());
            if (customerVoMap.containsKey(customerCode.toString())) {
                e.setCustomerName(((CustomerVo)customerVoMap.get(customerCode.toString())).getCustomerName());
            }
            StringBuilder auditCustomer = new StringBuilder();
            auditCustomer.append(e.getCustomerCode());
            auditCustomer.append(e.getSalesInstitutionCode());
            auditCustomer.append(e.getChannelCode());
            auditCustomer.append(e.getBusinessFormatCode());
            auditCustomer.append(e.getYearAndMonth());
            AtomicReference<BigDecimal> alreadyAuditAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            if (auditCustomerDetailVoMap.containsKey(auditCustomer.toString())) {
                ((List)auditCustomerDetailVoMap.get(auditCustomer.toString())).forEach(a -> {
                    if (Objects.nonNull(a.getThisAuditAmount())) {
                        alreadyAuditAmount.set(((BigDecimal)alreadyAuditAmount.get()).add(a.getThisAuditAmount()));
                    }
                });
            }
            e.setMonthEndAmount(alreadyAuditAmount.get());
            StringBuilder monthRecordKey = new StringBuilder();
            monthRecordKey.append(e.getSalesInstitutionCode());
            monthRecordKey.append(e.getBusinessFormatCode());
            monthRecordKey.append(e.getChannelCode());
            monthRecordKey.append(e.getCustomerCode());
            if (monthRecordMap.containsKey(monthRecordKey.toString())) {
                e.setExamineDeductAmount(((ExamineCircularMonthRecordEntity)((Object)((Object)((List)monthRecordMap.get(monthRecordKey.toString())).get(0)))).getWaitExamineDeductAmount().add(e.getMonthDeductAmount().subtract(e.getMonthRewardAmount())));
            } else {
                e.setExamineDeductAmount(BigDecimal.ZERO.add(e.getMonthDeductAmount().subtract(e.getMonthRewardAmount())));
            }
            if (zmfi046Map.containsKey(e.getCustomerCode())) {
                e.setRealExamineDeductAmount(((Zmfi046SdkVo)zmfi046Map.get(e.getCustomerCode())).getFinalBalc());
            } else {
                e.setRealExamineDeductAmount(BigDecimal.ZERO);
            }
            e.setRealExamineDeductAmount(e.getExamineDeductAmount().min(e.getRealExamineDeductAmount()));
            e.setWaitExamineDeductAmount(e.getExamineDeductAmount().subtract(e.getRealExamineDeductAmount()));
        });
    }

    private LinkedHashMap<String, List<ExamineCircularMonthRecordEntity>> getMonthRecordList(List<ExamineCircularMonthRecordEntity> entityList) {
        List<ExamineCircularMonthRecordDto> queryList = entityList.stream().map(a -> {
            ExamineCircularMonthRecordDto dto = new ExamineCircularMonthRecordDto();
            dto.setSalesInstitutionCode(a.getSalesInstitutionCode());
            dto.setBusinessFormatCode(a.getBusinessFormatCode());
            dto.setChannelCode(a.getChannelCode());
            dto.setCustomerCode(a.getCustomerCode());
            dto.setYearAndMonth(a.getYearAndMonth().replace("-", ""));
            return dto;
        }).collect(Collectors.toList());
        List<ExamineCircularMonthRecordEntity> monthRecordList = this.repository.findByListExamineCircularMonthRecordDto(queryList);
        return CollectionUtils.isEmpty(monthRecordList) ? Maps.newLinkedHashMap() : monthRecordList.stream().collect(Collectors.groupingBy(e -> {
            String recordKey = e.getSalesInstitutionCode() + e.getBusinessFormatCode() + e.getChannelCode() + e.getCustomerCode();
            return recordKey;
        }, LinkedHashMap::new, Collectors.toList()));
    }

    private Map<String, Zmfi046SdkVo> get046(List<ExamineCircularMonthRecordEntity> entityList) {
        Map<String, Object> map = new HashMap<String, Zmfi046SdkVo>();
        Set customerCodeSet = entityList.stream().map(ExamineCircularMonthRecordEntity::getCustomerCode).collect(Collectors.toSet());
        Zmfi046Dto dto = new Zmfi046Dto();
        dto.setGenLegrCtmList(new ArrayList(customerCodeSet));
        dto.setCyM(DateUtil.formatDate((Date)DateUtil.dateAddMonth((Date)DateUtil.dateYYYYMMDD((String)(entityList.get(0).getYearAndMonth() + "-01")), (Integer)-1), (String)"yyyyMM"));
        List list = this.zmfi046Voservice.findZmfi046VoForExamineCircular(dto);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            map = list.stream().collect(Collectors.toMap(Zmfi046SdkVo::getGenLegrCtm, Function.identity()));
        }
        return map;
    }

    private Map<String, List<AuditCustomerDetailVo>> getAuditCustomerDetailVoMap(List<ExamineCircularMonthRecordEntity> entityList, List<String> activityFormCodeList) {
        List dtoList = entityList.stream().map(a -> {
            StringBuffer crmCustomerCode = new StringBuffer();
            crmCustomerCode.append(a.getCustomerCode());
            crmCustomerCode.append(a.getSalesInstitutionCode());
            crmCustomerCode.append(a.getChannelCode());
            crmCustomerCode.append(a.getBusinessFormatCode());
            AuditCustomerDetailDto dto = new AuditCustomerDetailDto();
            dto.setCustomerCode(crmCustomerCode.toString());
            dto.setYearAndMonth(a.getYearAndMonth());
            return dto;
        }).collect(Collectors.toList());
        List auditCustomerDetailVos = this.auditService.findDetailByListAuditCustomerDetailDto(dtoList, ProcessStatusEnum.PASS.getKey(), activityFormCodeList);
        return CollectionUtils.isEmpty((Collection)auditCustomerDetailVos) ? Maps.newHashMap() : auditCustomerDetailVos.stream().collect(Collectors.groupingBy(e -> {
            StringBuffer key = new StringBuffer();
            key.append(e.getCustomerCode());
            key.append(DateFormatUtils.format((Date)e.getActivityBeginTime(), (String)"yyyy-MM"));
            return key.toString();
        }));
    }

    private Map<String, CustomerVo> getCustomerVoMap(List<ExamineCircularMonthRecordEntity> entityList) {
        List customerCodes = entityList.stream().map(a -> {
            StringBuffer customerCode = new StringBuffer();
            customerCode.append(a.getCustomerCode());
            customerCode.append(a.getSalesInstitutionCode());
            customerCode.append(a.getChannelCode());
            customerCode.append(a.getBusinessFormatCode());
            return customerCode.toString();
        }).collect(Collectors.toList());
        List customerVos = this.customerVoService.findByCustomerCodes(customerCodes);
        return CollectionUtils.isEmpty((Collection)customerVos) ? Maps.newHashMap() : customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
    }

    private Map<String, SalesOrgVo> getSalesOrgVoMap(List<ExamineCircularMonthRecordEntity> entityList) {
        List salesOrgCodes = entityList.stream().map(a -> {
            StringBuffer salesOrgCode = new StringBuffer();
            salesOrgCode.append(a.getChannelCode());
            salesOrgCode.append(a.getBusinessFormatCode());
            salesOrgCode.append(a.getSalesInstitutionCode());
            return salesOrgCode.toString();
        }).collect(Collectors.toList());
        List salesOrgVos = this.salesOrgVoService.findBySalesOrgCodes(salesOrgCodes);
        return CollectionUtils.isEmpty((Collection)salesOrgVos) ? Maps.newHashMap() : salesOrgVos.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity()));
    }

    private Map<String, ? extends List<ExamineCircularDailyRecord>> dailyRecordMap(List<ExamineCircularMonthRecordEntity> entityList, String yearAndMonth) {
        this.repository.deleteByYearAndMonth(yearAndMonth);
        List<ExamineCircularDailyRecord> dailyRecordList = this.examineCircularDailyRecordService.findByYearMonth(yearAndMonth);
        Validate.notEmpty(dailyRecordList, (String)"\u672a\u627e\u5230\u4efb\u610f\u65e5\u8bb0\u5f55\u660e\u7ec6\u6570\u636e", (Object[])new Object[0]);
        Map<String, List<ExamineCircularDailyRecord>> mapList = dailyRecordList.stream().collect(Collectors.groupingBy(e -> e.getSalesInstitutionCode() + e.getBusinessFormatCode() + e.getChannelCode() + e.getCustomerCode() + e.getExamineDay().substring(0, 7)));
        mapList.forEach((k, v) -> {
            ExamineCircularMonthRecordEntity monthRecordEntity = new ExamineCircularMonthRecordEntity();
            monthRecordEntity.setSalesInstitutionCode(((ExamineCircularDailyRecord)((Object)((Object)v.get(0)))).getSalesInstitutionCode());
            monthRecordEntity.setSalesInstitutionName(((ExamineCircularDailyRecord)((Object)((Object)v.get(0)))).getSalesInstitutionName());
            monthRecordEntity.setBusinessFormatCode(((ExamineCircularDailyRecord)((Object)((Object)v.get(0)))).getBusinessFormatCode());
            monthRecordEntity.setChannelCode(((ExamineCircularDailyRecord)((Object)((Object)v.get(0)))).getChannelCode());
            monthRecordEntity.setChannelName(((ExamineCircularDailyRecord)((Object)((Object)v.get(0)))).getChannelName());
            monthRecordEntity.setCustomerCode(((ExamineCircularDailyRecord)((Object)((Object)v.get(0)))).getCustomerCode());
            monthRecordEntity.setCustomerName(((ExamineCircularDailyRecord)((Object)((Object)v.get(0)))).getCustomerName());
            monthRecordEntity.setYearAndMonth(yearAndMonth);
            monthRecordEntity.setTenantCode(TenantUtils.getTenantCode());
            monthRecordEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            monthRecordEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entityList.add(monthRecordEntity);
        });
        return CollectionUtils.isEmpty(dailyRecordList) ? Maps.newHashMap() : dailyRecordList.stream().collect(Collectors.groupingBy(e -> e.getSalesInstitutionCode() + e.getBusinessFormatCode() + e.getChannelCode() + e.getCustomerCode() + e.getExamineDay().substring(0, 7)));
    }
}

