/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.examine.circular.local.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.examine.circular.local.entity.TpmExamineCircularEntity;
import com.biz.crm.tpm.business.examine.circular.local.entity.TpmExamineCircularMonitorEntity;
import com.biz.crm.tpm.business.examine.circular.local.entity.TpmExamineCircularMonitorRelationEntity;
import com.biz.crm.tpm.business.examine.circular.local.repository.TpmExamineCircularEntityRepository;
import com.biz.crm.tpm.business.examine.circular.local.repository.TpmExamineCircularMonitorEntityRepository;
import com.biz.crm.tpm.business.examine.circular.local.repository.TpmExamineCircularMonitorRelationEntityRepository;
import com.biz.crm.tpm.business.examine.circular.sdk.constant.TpmExamineCircularConstant;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.TpmExamineCircularDto;
import com.biz.crm.tpm.business.examine.circular.sdk.service.TpmExamineCircularMonitorSdkService;
import com.biz.crm.tpm.business.examine.circular.sdk.service.TpmExamineCircularService;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.TpmExamineCircularMonitorVo;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.TpmExamineCircularRespVo;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.dto.ProfitGoalDiscountDto;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.service.ProfitGoalDiscountService;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.vo.ProfitGoalDiscountVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class TpmExamineCircularMonitorSdkServiceImpl
implements TpmExamineCircularMonitorSdkService {
    private static final Logger log = LoggerFactory.getLogger(TpmExamineCircularMonitorSdkServiceImpl.class);
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private TpmExamineCircularService tpmExamineCircularService;
    @Autowired(required=false)
    private TpmExamineCircularEntityRepository tpmExamineCircularEntityRepository;
    @Autowired(required=false)
    private ProfitGoalDiscountService profitGoalDiscountService;
    @Autowired(required=false)
    private SalesOrgSubComOrgService salesOrgSubComOrgService;
    @Autowired(required=false)
    private TpmExamineCircularMonitorEntityRepository monitorEntityRepository;
    @Autowired(required=false)
    private TpmExamineCircularMonitorRelationEntityRepository relationEntityRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    @DynamicTaskService(cornExpression="0 50 23 1 * ? ", taskDesc="\u6bcf\u6708\u6708\u521d1\u53f7\u665a\u4e0a 23\uff1a50 \u66f4\u65b0\u8003\u6838\u901a\u62a5\u76d1\u63a7\u8868\u6570\u636e")
    public void examineCircularMonitorScheduleTask() {
        this.loginUserService.refreshAuthentication(null);
        boolean lockSuccess = false;
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        String lockKey = "examine_circular:lock:" + sdf.format(date);
        try {
            lockSuccess = this.redisLockService.tryLock(lockKey, TimeUnit.SECONDS, (long)TpmExamineCircularConstant.EXAMINE_CIRCULAR_LOCK_Time.intValue());
            if (!lockSuccess) {
                return;
            }
            this.generateMonitorData();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock(lockKey);
            }
        }
    }

    public TpmExamineCircularMonitorVo findById(String id) {
        Validate.notBlank((CharSequence)id, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        TpmExamineCircularMonitorEntity one = this.monitorEntityRepository.findById(id);
        Validate.notNull((Object)((Object)one), (String)"\u8be5\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664", (Object[])new Object[0]);
        TpmExamineCircularMonitorVo circularMonitorVo = (TpmExamineCircularMonitorVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)one, TpmExamineCircularMonitorVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<TpmExamineCircularMonitorRelationEntity> relationEntities = this.relationEntityRepository.findByUniqueKey(one.getAppraisalMonth() + "-" + one.getOrgCode() + "-" + one.getExamineType());
        if (!CollectionUtils.isEmpty(relationEntities)) {
            List<String> codes = relationEntities.stream().map(o -> o.getExamineCircularCode()).filter(Objects::nonNull).collect(Collectors.toList());
            List<TpmExamineCircularEntity> examineCircularEntities = this.tpmExamineCircularEntityRepository.findByExamineCircularCodes(codes);
            Collection respVos = this.nebulaToolkitService.copyCollectionByWhiteList(examineCircularEntities, TpmExamineCircularEntity.class, TpmExamineCircularRespVo.class, HashSet.class, ArrayList.class, new String[0]);
            circularMonitorVo.setExamineCircularRespVos(new ArrayList(respVos));
        }
        return circularMonitorVo;
    }

    private void generateMonitorData() {
        log.info("\u66f4\u65b0\u8003\u6838\u901a\u62a5\u76d1\u63a7\u8868\u6570\u636e \u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb");
        String yearMonthLy = DateUtil.format((Date)new Date(), (String)"yyyy-MM");
        this.relationEntityRepository.removerAllByYearMonthLy(yearMonthLy);
        this.monitorEntityRepository.removerAllByYearMonthLy(yearMonthLy);
        ProfitGoalDiscountDto discountDto = new ProfitGoalDiscountDto();
        discountDto.setYearMonthLy(yearMonthLy);
        List goalDiscountVos = this.profitGoalDiscountService.findForExamineCircularMonitor(discountDto);
        log.info("\u66f4\u65b0\u8003\u6838\u901a\u62a5\u76d1\u63a7\u8868\u6570\u636e goalDiscountVos\uff1a{}", (Object)goalDiscountVos.size());
        if (CollectionUtils.isEmpty((Collection)goalDiscountVos)) {
            return;
        }
        Map<String, List<ProfitGoalDiscountVo>> discountListMap = goalDiscountVos.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getYearMonthLy()) && StringUtils.isNotBlank((CharSequence)o.getOrgCode()) && StringUtils.isNotBlank((CharSequence)o.getAssessTypeCode())).collect(Collectors.groupingBy(o -> o.getYearMonthLy() + "-" + o.getOrgCode() + "-" + o.getAssessTypeCode()));
        log.info("\u66f4\u65b0\u8003\u6838\u901a\u62a5\u76d1\u63a7\u8868\u6570\u636e discountListMap\uff1a{}", (Object)discountListMap.size());
        log.info("\u66f4\u65b0\u8003\u6838\u901a\u62a5\u76d1\u63a7\u8868\u6570\u636e salesOrgSubComOrgService,{}", (Object)Objects.isNull(this.salesOrgSubComOrgService));
        Set orgCodes = goalDiscountVos.stream().map(ProfitGoalDiscountVo::getOrgCode).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
        log.info("\u66f4\u65b0\u8003\u6838\u901a\u62a5\u76d1\u63a7\u8868\u6570\u636e orgCodes,{}", (Object)orgCodes.size());
        List subComOrgVos = this.salesOrgSubComOrgService.findByOrgCodes(new ArrayList(orgCodes));
        if (CollectionUtils.isEmpty((Collection)subComOrgVos)) {
            return;
        }
        log.info("\u66f4\u65b0\u8003\u6838\u901a\u62a5\u76d1\u63a7\u8868\u6570\u636e subComOrgVos\uff1a{}", (Object)subComOrgVos.size());
        Map subComOrgVoMap = subComOrgVos.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getOrgCode()) && StringUtils.isNotBlank((CharSequence)o.getSubComOrgCode())).collect(Collectors.toMap(SalesOrgSubComOrgVo::getSubComOrgCode, Function.identity(), (v1, v2) -> v2));
        Set subComOrgCodes = subComOrgVos.stream().map(o -> o.getSubComOrgCode()).filter(Objects::nonNull).collect(Collectors.toSet());
        TpmExamineCircularDto dto = new TpmExamineCircularDto();
        dto.setMdgCustomerCodes(new ArrayList(subComOrgCodes));
        dto.setAppraisalMonth(yearMonthLy);
        List listForMonitor = this.tpmExamineCircularService.findListForMonitor(dto);
        log.info("\u66f4\u65b0\u8003\u6838\u901a\u62a5\u76d1\u63a7\u8868\u6570\u636e listForMonitor\uff1a{}", (Object)listForMonitor.size());
        if (CollectionUtils.isEmpty((Collection)listForMonitor)) {
            return;
        }
        Map<String, List<TpmExamineCircularRespVo>> examineListMap = listForMonitor.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getAppraisalMonth()) && StringUtils.isNotBlank((CharSequence)o.getCustomerCode()) && StringUtils.isNotBlank((CharSequence)o.getExamineType())).collect(Collectors.groupingBy(o -> o.getAppraisalMonth() + "-" + o.getCustomerCode() + "-" + o.getExamineType()));
        ArrayList<TpmExamineCircularMonitorEntity> saveList = new ArrayList<TpmExamineCircularMonitorEntity>();
        ArrayList<TpmExamineCircularMonitorRelationEntity> relationSaveList = new ArrayList<TpmExamineCircularMonitorRelationEntity>();
        for (Map.Entry<String, List<TpmExamineCircularRespVo>> entry : examineListMap.entrySet()) {
            ProfitGoalDiscountVo discountVo2;
            TpmExamineCircularMonitorEntity monitorEntity = new TpmExamineCircularMonitorEntity();
            monitorEntity.setId(UUID.randomUUID().toString().replaceAll("-", ""));
            TpmExamineCircularRespVo tpmVo = entry.getValue().get(0);
            SalesOrgSubComOrgVo salesOrgSubComOrgVo = (SalesOrgSubComOrgVo)subComOrgVoMap.get(tpmVo.getMdgCustomerCode());
            if (Objects.isNull(salesOrgSubComOrgVo)) {
                log.info("\u66f4\u65b0\u8003\u6838\u901a\u62a5\u76d1\u63a7\u8868\u6570\u636e salesOrgSubComOrgVo\uff1anull");
                continue;
            }
            List<ProfitGoalDiscountVo> discountVos = discountListMap.get(tpmVo.getAppraisalMonth() + salesOrgSubComOrgVo.getOrgCode() + tpmVo.getExamineType());
            BigDecimal monthBeginningExamineCircularAmount = BigDecimal.ZERO;
            if (!CollectionUtils.isEmpty(discountVos)) {
                for (ProfitGoalDiscountVo discountVo2 : discountVos) {
                    if (!Objects.nonNull(discountVo2.getAmount())) continue;
                    monthBeginningExamineCircularAmount = monthBeginningExamineCircularAmount.add(discountVo2.getAmount());
                }
            }
            BigDecimal actualAmount = BigDecimal.ZERO;
            discountVo2 = entry.getValue().iterator();
            while (discountVo2.hasNext()) {
                TpmExamineCircularRespVo respVo = (TpmExamineCircularRespVo)discountVo2.next();
                if (!Objects.nonNull(respVo.getExamineCircularAmount())) continue;
                actualAmount = actualAmount.add(respVo.getExamineCircularAmount());
                TpmExamineCircularMonitorRelationEntity relationEntity = new TpmExamineCircularMonitorRelationEntity();
                relationEntity.setUniqueKey(entry.getKey());
                relationEntity.setMonitorId(monitorEntity.getId());
                relationEntity.setExamineCircularCode(respVo.getExamineCircularCode());
                relationEntity.setTenantCode(TenantUtils.getTenantCode());
                relationSaveList.add(relationEntity);
            }
            BigDecimal diffAmount = NumberUtil.sub((Number)actualAmount, (Number)monthBeginningExamineCircularAmount);
            monitorEntity.setBusinessFormatCode(tpmVo.getBusinessFormatCode());
            monitorEntity.setBusinessUnitCode(tpmVo.getBusinessUnitCode());
            monitorEntity.setAppraisalMonth(tpmVo.getAppraisalMonth());
            monitorEntity.setExamineType(tpmVo.getExamineType());
            monitorEntity.setOrgCode(salesOrgSubComOrgVo.getOrgCode());
            monitorEntity.setMonthBeginningExamineCircularAmount(monthBeginningExamineCircularAmount);
            monitorEntity.setActualExamineCircularAmount(actualAmount);
            monitorEntity.setExamineCircularDiffAmount(diffAmount);
            monitorEntity.setIsOverEstimatedExamineCircular(diffAmount.compareTo(BigDecimal.ZERO) > 0 ? BooleanEnum.TRUE.getCapital() : BooleanEnum.FALSE.getCapital());
            monitorEntity.setTenantCode(TenantUtils.getTenantCode());
            monitorEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            monitorEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            monitorEntity.setCustomerCode(tpmVo.getCustomerCode());
            monitorEntity.setCustomerName(tpmVo.getCustomerName());
            monitorEntity.setMdgCustomerCode(tpmVo.getMdgCustomerCode());
            saveList.add(monitorEntity);
        }
        this.monitorEntityRepository.saveBatch(saveList);
        this.relationEntityRepository.saveBatch(relationSaveList);
        log.info("\u66f4\u65b0\u8003\u6838\u901a\u62a5\u76d1\u63a7\u8868\u6570\u636e \u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f");
    }
}

