/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.examine.circular.local.service.impl;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.third.system.sd.sdk.dto.AuditFeeUpAccountDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.AuditFeeUpAccountSonCompanyDto;
import com.biz.crm.mn.third.system.sd.sdk.service.SapSdApiService;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.examine.circular.local.entity.TpmExamineCircularEntity;
import com.biz.crm.tpm.business.examine.circular.local.mapper.TpmExamineCircularEntityMapper;
import com.biz.crm.tpm.business.examine.circular.local.mapper.TpmExamineCircularProductSplitEntityMapper;
import com.biz.crm.tpm.business.examine.circular.local.service.TpmExamineCircularPushService;
import com.biz.crm.tpm.business.examine.circular.sdk.constant.TpmExamineCircularRelationTypeEnum;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.TpmExamineCircularProductSplitRespVo;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.TpmExamineCircularRespVo;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.flowable.common.engine.impl.util.CollectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TpmExamineCircularPushServiceImpl
implements TpmExamineCircularPushService {
    private static final Logger log = LoggerFactory.getLogger(TpmExamineCircularPushServiceImpl.class);
    @Autowired(required=false)
    private FileHandleService fileHandleService;
    @Autowired(required=false)
    private TpmExamineCircularEntityMapper tpmExamineCircularEntityMapper;
    @Autowired(required=false)
    private TpmExamineCircularProductSplitEntityMapper tpmExamineCircularProductSplitEntityMapper;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private SapSdApiService sapSdApiService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;

    @Override
    @Async(value="asyncThread")
    public void feePoolPushToSapSync(List<String> codeList) {
        if (CollectionUtil.isEmpty(codeList)) {
            log.error("\u8003\u6838\u901a\u62a5\u7f16\u7801\u4e3a\u7a7a,\u4e0d\u6267\u884c\u63a8\u9001");
            return;
        }
        try {
            Thread.sleep(5000L);
            this.loginUserService.refreshAuthentication(null);
            this.feePoolPushToSap(codeList);
        }
        catch (InterruptedException e) {
            log.error("\u7ebf\u7a0b\u4f11\u77202\u79d2\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    @Override
    public void feePoolPushToSap(List<String> codeList) {
        if (CollectionUtil.isEmpty(codeList)) {
            log.error("\u8003\u6838\u901a\u62a5\u7f16\u7801\u4e3a\u7a7a,\u4e0d\u6267\u884c\u63a8\u9001");
            return;
        }
        List<TpmExamineCircularEntity> entities = this.tpmExamineCircularEntityMapper.findByCodeList(codeList, TenantUtils.getTenantCode());
        if (CollectionUtil.isEmpty(entities)) {
            log.error("\u8003\u6838\u901a\u62a5{}\u672a\u67e5\u8be2\u5230\u6570\u636e,\u4e0d\u6267\u884c\u63a8\u9001", codeList);
            return;
        }
        List customerCodes = entities.stream().filter(k -> StringUtils.isNotEmpty((CharSequence)k.getCustomerCode())).map(TpmExamineCircularEntity::getCustomerCode).distinct().collect(Collectors.toList());
        Map<String, CustomerVo> customerVoMap = new HashMap<String, CustomerVo>();
        if (CollectionUtil.isNotEmpty(customerCodes)) {
            List customerVoList = this.customerVoService.findBaseByCustomerCodes(new ArrayList(customerCodes));
            customerVoMap = customerVoList.stream().filter(k -> StringUtils.isNotEmpty((CharSequence)k.getCustomerCode())).collect(Collectors.toMap(CustomerVo::getCustomerCode, v -> v, (newValue, oldValue) -> newValue));
        }
        String businessUnitCode = entities.get(0).getBusinessUnitCode();
        BusinessUnitEnum businessUnitEnum = BusinessUnitEnum.codeToEnum((String)businessUnitCode);
        switch (businessUnitEnum) {
            case HEADQUARTERS: 
            case ONLINE: {
                this.pushFeePoolHead(entities, customerVoMap);
                break;
            }
            case SON_COMPANY: 
            case VERTICAL: {
                this.pushFeePoolSonCompany(entities, customerVoMap);
                break;
            }
            default: {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7c7b\u578b\u3010" + businessUnitEnum + "\u3011\uff0c\u8bf7\u68c0\u67e5");
            }
        }
    }

    private void pushFeePoolHead(List<TpmExamineCircularEntity> entities, Map<String, CustomerVo> customerVoMap) {
        log.info("\u8003\u6838\u6263\u6b3e\u4e0a\u8d26 \u3010\u603b\u516c\u53f8\u63a5\u53e3\u3011\u53c2\u6570\u3010{}\u3011", (Object)JSON.toJSONString(entities));
        List<String> ids = entities.stream().map(o -> o.getId()).collect(Collectors.toList());
        List<TpmExamineCircularRespVo> respVos = this.findByIds(ids);
        for (TpmExamineCircularRespVo respVo : respVos) {
            AuditFeeUpAccountDto auditFeeUpAccountDto = new AuditFeeUpAccountDto();
            AuditFeeUpAccountDto.MessageHeader messageHeader = new AuditFeeUpAccountDto.MessageHeader();
            messageHeader.setMESSAGEID(UuidCrmUtil.general());
            messageHeader.setINTERFACE("SI_TPM70_EXPENSES_HQ_ASYN_OUT");
            messageHeader.setSENDER("TPM");
            messageHeader.setSENDTIME(String.valueOf(System.currentTimeMillis()));
            messageHeader.setRECEIVER("ECC");
            auditFeeUpAccountDto.setMessageHeader(messageHeader);
            ArrayList<AuditFeeUpAccountDto.Item1> item1List = new ArrayList<AuditFeeUpAccountDto.Item1>();
            CustomerVo customerVo = customerVoMap.get(respVo.getCustomerCode());
            Validate.notNull((Object)customerVo, (String)"\u672a\u67e5\u8be2\u5230\u5ba2\u6237\u7f16\u7801\u3010%s\u3011\u7684\u4fe1\u606f", (Object[])new Object[]{respVo.getCustomerCode()});
            ActivityFormVo activityFormVo = this.activityFormService.findOneByCode(respVo.getActivityForm());
            log.info("\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u4e3a\uff1a{},activityFormVo:{}", (Object)respVo.getActivityForm(), (Object)JsonUtils.obj2JsonString((Object)activityFormVo));
            if (!StringUtils.equals((CharSequence)BooleanEnum.FALSE.getCapital(), (CharSequence)respVo.getIsSplit())) {
                List productSplitList = respVo.getProductSplitList();
                for (TpmExamineCircularProductSplitRespVo splitRespVo : productSplitList) {
                    AuditFeeUpAccountDto.Item1 item1 = new AuditFeeUpAccountDto.Item1();
                    item1.setKUNNR(customerVo.getErpCode());
                    item1.setCAMP_ID(splitRespVo.getExamineCircularCode());
                    item1.setZFID(splitRespVo.getSplitDetailCode());
                    item1.setMATNR(splitRespVo.getProductCode());
                    if (Objects.nonNull(activityFormVo)) {
                        item1.setKSCHL(activityFormVo.getSapCode());
                    }
                    item1.setVKBUR(customerVo.getSalesRegionErpCode());
                    item1.setVKORG(customerVo.getSalesInstitutionErpCode());
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                    item1.setZFQSRQ(Objects.isNull(respVo.getStartDate()) ? null : sdf.format(respVo.getStartDate()));
                    item1.setZFJSRQ(Objects.isNull(respVo.getStartDate()) ? null : sdf.format(respVo.getEndDate()));
                    if (splitRespVo.getSplitAmount().compareTo(BigDecimal.ZERO) >= 0) {
                        item1.setZFLAG("A");
                    } else {
                        item1.setZFLAG("B");
                    }
                    item1.setDMBTR(splitRespVo.getSplitAmount().toPlainString());
                    item1.setWAERS("CNY");
                    item1.setVKGRP(customerVo.getSalesOrgErpCode());
                    item1List.add(item1);
                }
            } else {
                AuditFeeUpAccountDto.Item1 item1 = new AuditFeeUpAccountDto.Item1();
                item1.setKUNNR(customerVo.getErpCode());
                item1.setCAMP_ID(respVo.getExamineCircularCode());
                if (Objects.nonNull(activityFormVo)) {
                    item1.setKSCHL(activityFormVo.getSapCode());
                }
                item1.setVKBUR(customerVo.getSalesRegionErpCode());
                item1.setVKORG(customerVo.getSalesInstitutionErpCode());
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                item1.setZFQSRQ(Objects.isNull(respVo.getStartDate()) ? null : sdf.format(respVo.getStartDate()));
                item1.setZFJSRQ(Objects.isNull(respVo.getStartDate()) ? null : sdf.format(respVo.getEndDate()));
                if (respVo.getExamineCircularAmount().compareTo(BigDecimal.ZERO) >= 0) {
                    item1.setZFLAG("A");
                } else {
                    item1.setZFLAG("B");
                }
                item1.setDMBTR(respVo.getExamineCircularAmount().toPlainString());
                item1.setWAERS("CNY");
                item1.setVKGRP(customerVo.getSalesOrgErpCode());
                item1List.add(item1);
            }
            auditFeeUpAccountDto.setITEM1(item1List);
            this.sapSdApiService.auditFeeUpAccount(auditFeeUpAccountDto);
        }
        log.info("\u603b\u516c\u53f8 \u8d39\u7528\u6c60\u4e0a\u8d26\u7ed3\u675f");
    }

    private void pushFeePoolSonCompany(List<TpmExamineCircularEntity> entities, Map<String, CustomerVo> customerVoMap) {
        log.info("\u8003\u6838\u6263\u6b3e\u4e0a\u8d26 \u3010\u5206\u5b50\u516c\u53f8\u63a5\u53e3\u3011\u53c2\u6570\u3010{}\u3011", (Object)JSON.toJSONString(entities));
        List<String> ids = entities.stream().map(o -> o.getId()).collect(Collectors.toList());
        List<TpmExamineCircularRespVo> respVos = this.findByIds(ids);
        for (TpmExamineCircularRespVo respVo : respVos) {
            List productSplitList = respVo.getProductSplitList();
            AuditFeeUpAccountSonCompanyDto auditFeeUpAccountSonCompanyDto = new AuditFeeUpAccountSonCompanyDto();
            AuditFeeUpAccountSonCompanyDto.MessageHeader messageHeader = new AuditFeeUpAccountSonCompanyDto.MessageHeader();
            messageHeader.setMESSAGEID(UuidCrmUtil.general());
            messageHeader.setINTERFACE("SI_TPM80_HXFYSZ_FGS_ASYN_OUT");
            messageHeader.setSENDER("TPM");
            messageHeader.setSENDTIME(String.valueOf(System.currentTimeMillis()));
            messageHeader.setRECEIVER("ECC");
            auditFeeUpAccountSonCompanyDto.setMessageHeader(messageHeader);
            ArrayList<AuditFeeUpAccountSonCompanyDto.Item1> item1List = new ArrayList<AuditFeeUpAccountSonCompanyDto.Item1>();
            CustomerVo customerVo = customerVoMap.get(respVo.getCustomerCode());
            Validate.notNull((Object)customerVo, (String)"\u672a\u67e5\u8be2\u5230\u5ba2\u6237\u7f16\u7801\u3010%s\u3011\u7684\u4fe1\u606f", (Object[])new Object[]{respVo.getCustomerCode()});
            ActivityFormVo activityFormVo = this.activityFormService.findOneByCode(respVo.getActivityForm());
            if (!StringUtils.equals((CharSequence)BooleanEnum.FALSE.getCapital(), (CharSequence)respVo.getIsSplit())) {
                for (TpmExamineCircularProductSplitRespVo splitRespVo : productSplitList) {
                    AuditFeeUpAccountSonCompanyDto.Item1 item1 = new AuditFeeUpAccountSonCompanyDto.Item1();
                    item1.setZFTPMHXD(splitRespVo.getSplitDetailCode());
                    item1.setZFHXDLX(respVo.getExamineCircularAmount().compareTo(BigDecimal.ZERO) >= 0 ? "ZSC1" : "ZSC2");
                    item1.setKUNNR(customerVo.getErpCode());
                    item1.setZFAMT1(respVo.getExamineCircularAmount() == null ? "0" : splitRespVo.getSplitAmount().abs().toPlainString());
                    item1.setMATNR(splitRespVo.getProductCode());
                    Calendar now = Calendar.getInstance();
                    item1.setGJAHR(String.valueOf(now.get(1)));
                    item1.setMONAT(String.valueOf(now.get(2) + 1));
                    item1.setVKORG(customerVo.getSalesInstitutionErpCode());
                    item1.setVTWEG(customerVo.getCustomerChannelCode());
                    item1.setZFCXHD(respVo.getExamineCircularCode());
                    item1.setZFCXHDI(splitRespVo.getSplitDetailCode());
                    if (Objects.nonNull(activityFormVo)) {
                        item1.setZFCXXS(activityFormVo.getSapCode());
                    }
                    DictDataVo businessFormatCodeVo = this.dictDataVoService.findByDictTypeCodeAndDictCode("mdm_business_format", respVo.getBusinessFormatCode());
                    Validate.notNull((Object)businessFormatCodeVo, (String)"\u672a\u67e5\u8be2\u5230\u4e1a\u6001\u3010%s\u3011\u7684\u6570\u636e\u5b57\u5178", (Object[])new Object[]{respVo.getBusinessFormatCode()});
                    Map extendMap = businessFormatCodeVo.getExtendMap();
                    if (extendMap != null) {
                        String zfyt = (String)extendMap.get("ZFYT");
                        item1.setZFYT(zfyt);
                    }
                    item1List.add(item1);
                }
            } else {
                AuditFeeUpAccountSonCompanyDto.Item1 item1 = new AuditFeeUpAccountSonCompanyDto.Item1();
                item1.setZFTPMHXD(respVo.getExamineCircularCode());
                item1.setZFHXDLX(respVo.getExamineCircularAmount().compareTo(BigDecimal.ZERO) >= 0 ? "ZSC1" : "ZSC2");
                item1.setKUNNR(customerVo.getErpCode());
                item1.setZFAMT1(respVo.getExamineCircularAmount() == null ? "0" : respVo.getExamineCircularAmount().abs().toPlainString());
                Calendar now = Calendar.getInstance();
                item1.setGJAHR(String.valueOf(now.get(1)));
                item1.setMONAT(String.valueOf(now.get(2) + 1));
                item1.setVKORG(customerVo.getSalesInstitutionErpCode());
                item1.setVTWEG(customerVo.getCustomerChannelCode());
                item1.setZFCXHD(respVo.getExamineCircularCode());
                if (Objects.nonNull(activityFormVo)) {
                    item1.setZFCXXS(activityFormVo.getSapCode());
                }
                DictDataVo businessFormatCodeVo = this.dictDataVoService.findByDictTypeCodeAndDictCode("mdm_business_format", respVo.getBusinessFormatCode());
                Validate.notNull((Object)businessFormatCodeVo, (String)"\u672a\u67e5\u8be2\u5230\u4e1a\u6001\u3010%s\u3011\u7684\u6570\u636e\u5b57\u5178", (Object[])new Object[]{respVo.getBusinessFormatCode()});
                Map extendMap = businessFormatCodeVo.getExtendMap();
                if (extendMap != null) {
                    String zfyt = (String)extendMap.get("ZFYT");
                    item1.setZFYT(zfyt);
                }
                item1List.add(item1);
            }
            auditFeeUpAccountSonCompanyDto.setITEM1(item1List);
            this.sapSdApiService.auditFeeUpAccountSonCompany(auditFeeUpAccountSonCompanyDto);
        }
        log.info("\u5206\u5b50\u516c\u53f8 \u8d39\u7528\u6c60\u4e0a\u8d26\u7ed3\u675f");
    }

    private List<TpmExamineCircularRespVo> findByIds(List<String> ids) {
        List<TpmExamineCircularRespVo> respVos = this.tpmExamineCircularEntityMapper.findByIdsAndTenantCode(ids, TenantUtils.getTenantCode());
        if (!CollectionUtils.isEmpty(respVos)) {
            for (TpmExamineCircularRespVo respVo : respVos) {
                String[] protocolIdList;
                if (TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION.getCode().equals(respVo.getRelationType()) || TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION_AND_BUDGET.getCode().equals(respVo.getRelationType())) {
                    List<TpmExamineCircularProductSplitRespVo> productSplitRespVoList = this.tpmExamineCircularProductSplitEntityMapper.findByExamineCircularCode(respVo.getExamineCircularCode());
                    respVo.setProductSplitList(productSplitRespVoList);
                }
                if (StringUtils.isEmpty((CharSequence)respVo.getProtocols())) continue;
                ArrayList<OrdinaryFileVo> files = new ArrayList<OrdinaryFileVo>();
                for (String protocolId : protocolIdList = (String[])respVo.getProtocols().split(",").clone()) {
                    OrdinaryFileVo fileVo = this.fileHandleService.findById(protocolId);
                    files.add(fileVo);
                }
                respVo.setProtocolList(files);
            }
        }
        return respVos;
    }
}

